/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.traits;

import java.io.Serializable;

public final class MinOptMax
implements Serializable {
    private static final long serialVersionUID = -4791524475122206142L;
    public static final MinOptMax ZERO = MinOptMax.getInstance(0);
    private final int min;
    private final int opt;
    private final int max;

    public static MinOptMax getInstance(int min2, int opt, int max) throws IllegalArgumentException {
        if (min2 > opt) {
            throw new IllegalArgumentException("min (" + min2 + ") > opt (" + opt + ")");
        }
        if (max < opt) {
            throw new IllegalArgumentException("max (" + max + ") < opt (" + opt + ")");
        }
        return new MinOptMax(min2, opt, max);
    }

    public static MinOptMax getInstance(int value) {
        return new MinOptMax(value, value, value);
    }

    private MinOptMax(int min2, int opt, int max) {
        assert (min2 <= opt && opt <= max);
        this.min = min2;
        this.opt = opt;
        this.max = max;
    }

    public int getMin() {
        return this.min;
    }

    public int getOpt() {
        return this.opt;
    }

    public int getMax() {
        return this.max;
    }

    public int getShrink() {
        return this.opt - this.min;
    }

    public int getStretch() {
        return this.max - this.opt;
    }

    public MinOptMax plus(MinOptMax operand) {
        return new MinOptMax(this.min + operand.min, this.opt + operand.opt, this.max + operand.max);
    }

    public MinOptMax plus(int value) {
        return new MinOptMax(this.min + value, this.opt + value, this.max + value);
    }

    public MinOptMax minus(MinOptMax operand) throws ArithmeticException {
        this.checkCompatibility(this.getShrink(), operand.getShrink(), "shrink");
        this.checkCompatibility(this.getStretch(), operand.getStretch(), "stretch");
        return new MinOptMax(this.min - operand.min, this.opt - operand.opt, this.max - operand.max);
    }

    private void checkCompatibility(int thisElasticity, int operandElasticity, String msge) {
        if (thisElasticity < operandElasticity) {
            throw new ArithmeticException("Cannot subtract a MinOptMax from another MinOptMax that has less " + msge + " (" + thisElasticity + " < " + operandElasticity + ")");
        }
    }

    public MinOptMax minus(int value) {
        return new MinOptMax(this.min - value, this.opt - value, this.max - value);
    }

    public MinOptMax plusMin(int minOperand) throws IllegalArgumentException {
        return MinOptMax.getInstance(this.min + minOperand, this.opt, this.max);
    }

    public MinOptMax minusMin(int minOperand) throws IllegalArgumentException {
        return MinOptMax.getInstance(this.min - minOperand, this.opt, this.max);
    }

    public MinOptMax plusMax(int maxOperand) throws IllegalArgumentException {
        return MinOptMax.getInstance(this.min, this.opt, this.max + maxOperand);
    }

    public MinOptMax minusMax(int maxOperand) throws IllegalArgumentException {
        return MinOptMax.getInstance(this.min, this.opt, this.max - maxOperand);
    }

    public MinOptMax mult(int factor) throws IllegalArgumentException {
        if (factor < 0) {
            throw new IllegalArgumentException("factor < 0; was: " + factor);
        }
        if (factor == 1) {
            return this;
        }
        return MinOptMax.getInstance(this.min * factor, this.opt * factor, this.max * factor);
    }

    public boolean isNonZero() {
        return this.min != 0 || this.max != 0;
    }

    public boolean isStiff() {
        return this.min == this.max;
    }

    public boolean isElastic() {
        return this.min != this.opt || this.opt != this.max;
    }

    public MinOptMax extendMinimum(int newMin) {
        if (this.min < newMin) {
            int newOpt = Math.max(newMin, this.opt);
            int newMax = Math.max(newOpt, this.max);
            return MinOptMax.getInstance(newMin, newOpt, newMax);
        }
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MinOptMax minOptMax = (MinOptMax)obj;
        return this.opt == minOptMax.opt && this.max == minOptMax.max && this.min == minOptMax.min;
    }

    public int hashCode() {
        int result = this.min;
        result = 31 * result + this.opt;
        result = 31 * result + this.max;
        return result;
    }

    public String toString() {
        return "MinOptMax[min = " + this.min + ", opt = " + this.opt + ", max = " + this.max + "]";
    }
}

