/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg.font;

import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.CharacterIterator;
import java.util.Collections;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.fop.complexscripts.util.CharAssociation;
import org.apache.fop.complexscripts.util.CharMirror;
import org.apache.fop.fonts.Font;
import org.apache.fop.svg.font.FOPGVTFont;
import org.apache.fop.svg.font.FOPGVTGlyphVector;

class ComplexGlyphVector
extends FOPGVTGlyphVector {
    public static final AttributedCharacterIterator.Attribute WRITING_MODE = GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE;
    public static final Integer WRITING_MODE_RTL = GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE_RTL;
    private boolean reversed;
    private boolean mirrored;

    ComplexGlyphVector(FOPGVTFont font, CharacterIterator iter, FontRenderContext frc) {
        super(font, iter, frc);
    }

    @Override
    public void performDefaultLayout() {
        super.performDefaultLayout();
    }

    @Override
    public boolean isReversed() {
        return this.reversed;
    }

    @Override
    public void maybeReverse(boolean mirror) {
        if (!this.reversed) {
            if (this.glyphs != null) {
                if (this.glyphs.length > 1) {
                    ComplexGlyphVector.reverse(this.glyphs);
                    if (this.associations != null) {
                        Collections.reverse(this.associations);
                    }
                    if (this.gposAdjustments != null) {
                        ComplexGlyphVector.reverse(this.gposAdjustments);
                    }
                    if (this.positions != null) {
                        ComplexGlyphVector.reverse(this.positions);
                    }
                    if (this.boundingBoxes != null) {
                        ComplexGlyphVector.reverse(this.boundingBoxes);
                    }
                    if (this.glyphTransforms != null) {
                        ComplexGlyphVector.reverse(this.glyphTransforms);
                    }
                    if (this.glyphVisibilities != null) {
                        ComplexGlyphVector.reverse(this.glyphVisibilities);
                    }
                }
                if (this.maybeMirror()) {
                    this.mirrored = true;
                }
            }
            this.reversed = true;
        }
    }

    private boolean maybeMirror() {
        boolean mirrored = false;
        String s2 = this.text.subSequence(this.text.getBeginIndex(), this.text.getEndIndex()).toString();
        if (CharMirror.hasMirrorable(s2)) {
            String m4 = CharMirror.mirror(s2);
            assert (m4.length() == s2.length());
            int n = m4.length();
            for (int i = 0; i < n; ++i) {
                char cs = s2.charAt(i);
                char cm = m4.charAt(i);
                if (cm == cs || !this.substituteMirroredGlyph(i, cm)) continue;
                mirrored = true;
            }
        }
        return mirrored;
    }

    private boolean substituteMirroredGlyph(int index, char mirror) {
        Font f = this.font.getFont();
        int gi = 0;
        for (CharAssociation ca : this.associations) {
            if (ca.contained(index, 1)) {
                this.setGlyphCode(gi, f.mapChar(mirror));
                return true;
            }
            ++gi;
        }
        return false;
    }

    private static void reverse(boolean[] ba) {
        int n = ba.length;
        int m4 = n / 2;
        for (int i = 0; i < m4; ++i) {
            int k = n - i - 1;
            boolean t2 = ba[k];
            ba[k] = ba[i];
            ba[i] = t2;
        }
    }

    private static void reverse(int[] ia) {
        int n = ia.length;
        int m4 = n / 2;
        for (int i = 0; i < m4; ++i) {
            int k = n - i - 1;
            int t2 = ia[k];
            ia[k] = ia[i];
            ia[i] = t2;
        }
    }

    private static void reverse(int[][] iaa) {
        int n = iaa.length;
        int m4 = n / 2;
        for (int i = 0; i < m4; ++i) {
            int k = n - i - 1;
            int[] t2 = iaa[k];
            iaa[k] = iaa[i];
            iaa[i] = t2;
        }
    }

    private static void reverse(float[] fa) {
        int skip = 2;
        int numPositions = fa.length / skip;
        int n = numPositions;
        int m4 = n / 2;
        for (int i = 0; i < m4; ++i) {
            int j = n - i - 1;
            for (int k = 0; k < skip; ++k) {
                int l1 = i * skip + k;
                int l2 = j * skip + k;
                float t2 = fa[l2];
                fa[l2] = fa[l1];
                fa[l1] = t2;
            }
        }
        float runAdvanceX = fa[0];
        int n2 = numPositions;
        for (int i = 0; i < n2; ++i) {
            int k = i * 2;
            fa[k + 0] = runAdvanceX - fa[k + 0];
            if (i <= 0) continue;
            fa[k - 1] = fa[k + 1];
        }
    }

    private static void reverse(Rectangle2D[] ra) {
        int n = ra.length;
        int m4 = n / 2;
        for (int i = 0; i < m4; ++i) {
            int k = n - i - 1;
            Rectangle2D t2 = ra[k];
            ra[k] = ra[i];
            ra[i] = t2;
        }
    }

    private static void reverse(AffineTransform[] ta) {
        int n = ta.length;
        int m4 = n / 2;
        for (int i = 0; i < m4; ++i) {
            int k = n - i - 1;
            AffineTransform t2 = ta[k];
            ta[k] = ta[i];
            ta[i] = t2;
        }
    }
}

