/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.util.List;
import org.apache.fop.render.gradient.Function;
import org.apache.fop.render.gradient.GradientMaker;
import org.apache.fop.render.gradient.Pattern;
import org.apache.fop.render.gradient.Shading;

public final class Gradient {
    private Gradient() {
    }

    public static String outputPattern(Pattern pattern, GradientMaker.DoubleFormatter doubleFormatter) {
        StringBuilder p = new StringBuilder(64);
        p.append("/Pattern setcolorspace\n");
        p.append("<< \n/Type /Pattern \n");
        p.append("/PatternType " + pattern.getPatternType() + " \n");
        if (pattern.getShading() != null) {
            p.append("/Shading ");
            Gradient.outputShading(p, pattern.getShading(), doubleFormatter);
            p.append(" \n");
        }
        p.append(">> \n");
        List<Double> matrix = pattern.getMatrix();
        if (matrix == null) {
            p.append("matrix ");
        } else {
            p.append("[ ");
            for (double m4 : pattern.getMatrix()) {
                p.append(doubleFormatter.formatDouble(m4));
                p.append(" ");
            }
            p.append("] ");
        }
        p.append("makepattern setcolor\n");
        return p.toString();
    }

    private static void outputShading(StringBuilder out, Shading shading, final GradientMaker.DoubleFormatter doubleFormatter) {
        final Function function = shading.getFunction();
        Shading.FunctionRenderer functionRenderer = new Shading.FunctionRenderer(){

            @Override
            public void outputFunction(StringBuilder out) {
                Function.SubFunctionRenderer subFunctionRenderer = new Function.SubFunctionRenderer(){

                    @Override
                    public void outputFunction(StringBuilder out, int functionIndex) {
                        Function subFunction = function.getFunctions().get(functionIndex);
                        assert (subFunction.getFunctions().isEmpty());
                        subFunction.output(out, doubleFormatter, null);
                    }
                };
                function.output(out, doubleFormatter, subFunctionRenderer);
            }
        };
        shading.output(out, doubleFormatter, functionRenderer);
    }
}

