/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.render.ImageHandler;
import org.apache.fop.render.RenderingContext;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.util.Service;

public class ImageHandlerRegistry {
    private static Log log = LogFactory.getLog(ImageHandlerRegistry.class);
    private static final Comparator<ImageHandler> HANDLER_COMPARATOR = new Comparator<ImageHandler>(){

        @Override
        public int compare(ImageHandler o1, ImageHandler o2) {
            ImageHandler h1 = o1;
            ImageHandler h2 = o2;
            return h1.getPriority() - h2.getPriority();
        }
    };
    private Map<Class<? extends Image>, ImageHandler> handlers = new HashMap<Class<? extends Image>, ImageHandler>();
    private List<ImageHandler> handlerList = new LinkedList<ImageHandler>();
    private int handlerRegistrations;

    public ImageHandlerRegistry() {
        this.discoverHandlers();
    }

    public void addHandler(String classname) {
        try {
            ImageHandler handlerInstance = (ImageHandler)Class.forName(classname).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.addHandler(handlerInstance);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not find " + classname);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Could not instantiate " + classname);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Could not access " + classname);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(classname + " is not an " + ImageHandler.class.getName());
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public synchronized void addHandler(ImageHandler handler) {
        Class imageClass = handler.getSupportedImageClass();
        this.handlers.put(imageClass, handler);
        ListIterator<ImageHandler> iter = this.handlerList.listIterator();
        while (iter.hasNext()) {
            ImageHandler h2 = iter.next();
            if (HANDLER_COMPARATOR.compare(handler, h2) >= 0) continue;
            iter.previous();
            break;
        }
        iter.add(handler);
        ++this.handlerRegistrations;
    }

    public ImageHandler getHandler(RenderingContext targetContext, Image image) {
        for (ImageHandler h2 : this.handlerList) {
            if (!h2.isCompatible(targetContext, image)) continue;
            return h2;
        }
        return null;
    }

    public synchronized ImageFlavor[] getSupportedFlavors(RenderingContext context) {
        ArrayList flavors = new ArrayList();
        for (ImageHandler handler : this.handlerList) {
            if (!handler.isCompatible(context, null)) continue;
            ImageFlavor[] f = handler.getSupportedImageFlavors();
            Collections.addAll(flavors, f);
        }
        return flavors.toArray(new ImageFlavor[flavors.size()]);
    }

    private void discoverHandlers() {
        Iterator<Object> providers = Service.providers(ImageHandler.class);
        if (providers != null) {
            while (providers.hasNext()) {
                ImageHandler handler = (ImageHandler)providers.next();
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Dynamically adding ImageHandler: " + handler.getClass().getName());
                    }
                    this.addHandler(handler);
                }
                catch (IllegalArgumentException e) {
                    log.error("Error while adding ImageHandler", e);
                }
            }
        }
    }
}

