/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

public enum PDFUAMode {
    DISABLED("PDF/UA disabled"),
    PDFUA_1(1);

    private final String name;
    private final int part;

    private PDFUAMode(String name) {
        this.name = name;
        this.part = 0;
    }

    private PDFUAMode(int part) {
        this.name = "PDF/UA-" + part;
        this.part = part;
    }

    public String getName() {
        return this.name;
    }

    public int getPart() {
        return this.part;
    }

    public boolean isEnabled() {
        return this != DISABLED;
    }

    public static PDFUAMode getValueOf(String s2) {
        for (PDFUAMode mode : PDFUAMode.values()) {
            if (!mode.name.equalsIgnoreCase(s2)) continue;
            return mode;
        }
        return DISABLED;
    }

    public String toString() {
        return this.name;
    }
}

