/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.fop.pdf.AbstractPDFStream;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.StreamCache;
import org.apache.fop.pdf.StreamCacheFactory;

public class PDFStream
extends AbstractPDFStream {
    protected StreamCache data;
    private transient Writer streamWriter;
    private transient char[] charBuffer;

    public PDFStream() {
        this.setUp();
    }

    public PDFStream(PDFDictionary dictionary) {
        super(dictionary);
        this.setUp();
    }

    public PDFStream(PDFDictionary dictionary, boolean encodeOnTheFly) {
        super(dictionary, encodeOnTheFly);
        this.setUp();
    }

    public PDFStream(boolean encodeOnTheFly) {
        super(encodeOnTheFly);
        this.setUp();
    }

    private void setUp() {
        try {
            this.data = StreamCacheFactory.getInstance().createStreamCache();
            this.streamWriter = new OutputStreamWriter(this.getBufferOutputStream(), "ISO-8859-1");
            this.streamWriter = new BufferedWriter(this.streamWriter);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void add(String s2) {
        try {
            this.streamWriter.write(s2);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void add(StringBuffer sb) {
        try {
            int nHave = sb.length();
            if (this.charBuffer == null) {
                this.charBuffer = new char[nHave * 2];
            } else {
                int nAvail = this.charBuffer.length;
                if (nAvail < nHave) {
                    int nAlloc;
                    for (nAlloc = nAvail; nAlloc < nHave; nAlloc *= 2) {
                    }
                    this.charBuffer = new char[nAlloc];
                }
            }
            sb.getChars(0, nHave, this.charBuffer, 0);
            this.streamWriter.write(this.charBuffer, 0, nHave);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void flush() throws IOException {
        this.streamWriter.flush();
    }

    public Writer getBufferWriter() {
        return this.streamWriter;
    }

    public OutputStream getBufferOutputStream() throws IOException {
        if (this.streamWriter != null) {
            this.flush();
        }
        return this.data.getOutputStream();
    }

    public void setData(byte[] data) throws IOException {
        this.data.clear();
        this.data.write(data);
    }

    public int getDataLength() {
        try {
            this.flush();
            return this.data.getSize();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    @Override
    protected int getSizeHint() throws IOException {
        this.flush();
        return this.data.getSize();
    }

    @Override
    protected void outputRawStreamData(OutputStream out) throws IOException {
        this.flush();
        this.data.outputContents(out);
    }

    @Override
    public int output(OutputStream stream) throws IOException {
        int len = super.output(stream);
        return len;
    }

    public String streamHashCode() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.outputRawStreamData(bos);
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] thedigest = md.digest(bos.toByteArray());
            StringBuilder hex = new StringBuilder();
            for (byte b : thedigest) {
                hex.append(String.format("%02x", b));
            }
            return hex.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
    }
}

