/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.hyphenation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.fop.hyphenation.ByteVector;
import org.apache.fop.hyphenation.Hyphenation;
import org.apache.fop.hyphenation.HyphenationException;
import org.apache.fop.hyphenation.PatternConsumer;
import org.apache.fop.hyphenation.PatternParser;
import org.apache.fop.hyphenation.TernaryTree;
import org.xml.sax.InputSource;

public class HyphenationTree
extends TernaryTree
implements PatternConsumer {
    private static final long serialVersionUID = -7842107987915665573L;
    protected ByteVector vspace;
    protected HashMap stoplist = new HashMap(23);
    protected TernaryTree classmap = new TernaryTree();
    private transient TernaryTree ivalues;

    public HyphenationTree() {
        this.vspace = new ByteVector();
        this.vspace.alloc(1);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
    }

    protected int packValues(String values) {
        int n = values.length();
        int m4 = (n & 1) == 1 ? (n >> 1) + 2 : (n >> 1) + 1;
        int offset = this.vspace.alloc(m4);
        byte[] va = this.vspace.getArray();
        for (int i = 0; i < n; ++i) {
            int j = i >> 1;
            byte v = (byte)(values.charAt(i) - 48 + 1 & 0xF);
            va[j + offset] = (i & 1) == 1 ? (byte)(va[j + offset] | v) : (byte)(v << 4);
        }
        va[m4 - 1 + offset] = 0;
        return offset;
    }

    protected String unpackValues(int k) {
        StringBuffer buf = new StringBuffer();
        byte v = this.vspace.get(k++);
        while (v != 0) {
            char c = (char)((v >>> 4) - 1 + 48);
            buf.append(c);
            c = (char)(v & 0xF);
            if (c == '\u0000') break;
            c = (char)(c - '\u0001' + 48);
            buf.append(c);
            v = this.vspace.get(k++);
        }
        return buf.toString();
    }

    public void loadPatterns(String filename) throws HyphenationException {
        File f = new File(filename);
        try {
            InputSource src = new InputSource(f.toURI().toURL().toExternalForm());
            this.loadPatterns(src);
        }
        catch (MalformedURLException e) {
            throw new HyphenationException("Error converting the File '" + f + "' to a URL: " + e.getMessage());
        }
    }

    public void loadPatterns(InputSource source) throws HyphenationException {
        PatternParser pp = new PatternParser(this);
        this.ivalues = new TernaryTree();
        pp.parse(source);
        this.trimToSize();
        this.vspace.trimToSize();
        this.classmap.trimToSize();
        this.ivalues = null;
    }

    public String findPattern(String pat) {
        int k = super.find(pat);
        if (k >= 0) {
            return this.unpackValues(k);
        }
        return "";
    }

    protected int hstrcmp(char[] s2, int si, char[] t2, int ti) {
        while (s2[si] == t2[ti]) {
            if (s2[si] == '\u0000') {
                return 0;
            }
            ++si;
            ++ti;
        }
        if (t2[ti] == '\u0000') {
            return 0;
        }
        return s2[si] - t2[ti];
    }

    protected byte[] getValues(int k) {
        StringBuffer buf = new StringBuffer();
        byte v = this.vspace.get(k++);
        while (v != 0) {
            char c = (char)((v >>> 4) - 1);
            buf.append(c);
            c = (char)(v & 0xF);
            if (c == '\u0000') break;
            c = (char)(c - '\u0001');
            buf.append(c);
            v = this.vspace.get(k++);
        }
        byte[] res = new byte[buf.length()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = (byte)buf.charAt(i);
        }
        return res;
    }

    protected void searchPatterns(char[] word, int index, byte[] il) {
        int i = index;
        char sp = word[i];
        char p = this.root;
        block0: while (p > '\u0000' && p < this.sc.length) {
            byte[] values;
            if (this.sc[p] == '\uffff') {
                if (this.hstrcmp(word, i, this.kv.getArray(), this.lo[p]) == 0) {
                    values = this.getValues(this.eq[p]);
                    int j = index;
                    for (byte value : values) {
                        if (j < il.length && value > il[j]) {
                            il[j] = value;
                        }
                        ++j;
                    }
                }
                return;
            }
            int d = sp - this.sc[p];
            if (d == 0) {
                if (sp == '\u0000') break;
                sp = word[++i];
                char q = p = this.eq[p];
                while (q > '\u0000' && q < this.sc.length && this.sc[q] != '\uffff') {
                    if (this.sc[q] == '\u0000') {
                        values = this.getValues(this.eq[q]);
                        int j = index;
                        for (byte value : values) {
                            if (j < il.length && value > il[j]) {
                                il[j] = value;
                            }
                            ++j;
                        }
                        continue block0;
                    }
                    q = this.lo[q];
                }
                continue;
            }
            p = d < 0 ? this.lo[p] : this.hi[p];
        }
    }

    public Hyphenation hyphenate(String word, int remainCharCount, int pushCharCount) {
        char[] w = word.toCharArray();
        if (this.isMultiPartWord(w, w.length)) {
            List<char[]> words = this.splitOnNonCharacters(w);
            return new Hyphenation(new String(w), this.getHyphPointsForWords(words, remainCharCount, pushCharCount));
        }
        return this.hyphenate(w, 0, w.length, remainCharCount, pushCharCount);
    }

    private boolean isMultiPartWord(char[] w, int len) {
        int wordParts = 0;
        for (int i = 0; i < len; ++i) {
            char[] c = new char[2];
            c[0] = w[i];
            int nc = this.classmap.find(c, 0);
            if (nc > 0) {
                if (wordParts > 1) {
                    return true;
                }
                wordParts = 1;
                continue;
            }
            if (wordParts != true) continue;
            ++wordParts;
        }
        return false;
    }

    private List<char[]> splitOnNonCharacters(char[] word) {
        List<Integer> breakPoints = this.getNonLetterBreaks(word);
        if (breakPoints.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<char[]> words = new ArrayList<char[]>();
        for (int ibreak = 0; ibreak < breakPoints.size(); ++ibreak) {
            char[] newWord = this.getWordFromCharArray(word, ibreak == 0 ? 0 : breakPoints.get(ibreak - 1), breakPoints.get(ibreak));
            words.add(newWord);
        }
        if (word.length - breakPoints.get(breakPoints.size() - 1) - 1 > 1) {
            char[] newWord = this.getWordFromCharArray(word, breakPoints.get(breakPoints.size() - 1), word.length);
            words.add(newWord);
        }
        return words;
    }

    private List<Integer> getNonLetterBreaks(char[] word) {
        char[] c = new char[2];
        ArrayList<Integer> breakPoints = new ArrayList<Integer>();
        boolean foundLetter = false;
        for (int i = 0; i < word.length; ++i) {
            c[0] = word[i];
            if (this.classmap.find(c, 0) < 0) {
                if (!foundLetter) continue;
                breakPoints.add(i);
                continue;
            }
            foundLetter = true;
        }
        return breakPoints;
    }

    private char[] getWordFromCharArray(char[] word, int startIndex, int endIndex) {
        int i;
        char[] newWord = new char[endIndex - (startIndex == 0 ? startIndex : startIndex + 1)];
        int iChar = 0;
        int n = i = startIndex == 0 ? 0 : startIndex + 1;
        while (i < endIndex) {
            newWord[iChar++] = word[i];
            ++i;
        }
        return newWord;
    }

    private int[] getHyphPointsForWords(List<char[]> nonLetterWords, int remainCharCount, int pushCharCount) {
        int[] breaks = new int[]{};
        for (int iNonLetterWord = 0; iNonLetterWord < nonLetterWords.size(); ++iNonLetterWord) {
            char[] nonLetterWord = nonLetterWords.get(iNonLetterWord);
            Hyphenation curHyph = this.hyphenate(nonLetterWord, 0, nonLetterWord.length, iNonLetterWord == 0 ? remainCharCount : 1, iNonLetterWord == nonLetterWords.size() - 1 ? pushCharCount : 1);
            if (curHyph == null) continue;
            int[] combined = new int[breaks.length + curHyph.getHyphenationPoints().length];
            int[] hyphPoints = curHyph.getHyphenationPoints();
            int foreWordsSize = this.calcForeWordsSize(nonLetterWords, iNonLetterWord);
            int i = 0;
            while (i < hyphPoints.length) {
                int n = i++;
                hyphPoints[n] = hyphPoints[n] + foreWordsSize;
            }
            System.arraycopy(breaks, 0, combined, 0, breaks.length);
            System.arraycopy(hyphPoints, 0, combined, breaks.length, hyphPoints.length);
            breaks = combined;
        }
        return breaks;
    }

    private int calcForeWordsSize(List<char[]> nonLetterWords, int iNonLetterWord) {
        int result = 0;
        for (int i = 0; i < iNonLetterWord; ++i) {
            result += nonLetterWords.get(i).length + 1;
        }
        return result;
    }

    public Hyphenation hyphenate(char[] w, int offset, int len, int remainCharCount, int pushCharCount) {
        int i;
        char[] word = new char[len + 3];
        char[] c = new char[2];
        int iIgnoreAtBeginning = 0;
        int iLength = len;
        boolean bEndOfLetters = false;
        for (i = 1; i <= len; ++i) {
            c[0] = w[offset + i - 1];
            int nc = this.classmap.find(c, 0);
            if (nc < 0) {
                if (i == 1 + iIgnoreAtBeginning) {
                    ++iIgnoreAtBeginning;
                } else {
                    bEndOfLetters = true;
                }
                --iLength;
                continue;
            }
            if (!bEndOfLetters) {
                word[i - iIgnoreAtBeginning] = (char)nc;
                continue;
            }
            return null;
        }
        len = iLength;
        if (len < remainCharCount + pushCharCount) {
            return null;
        }
        int[] result = new int[len + 1];
        int k = 0;
        String sw = new String(word, 1, len);
        if (this.stoplist.containsKey(sw)) {
            ArrayList hw = (ArrayList)this.stoplist.get(sw);
            int j = 0;
            for (i = 0; i < hw.size(); ++i) {
                Object o = hw.get(i);
                if (!(o instanceof String) || (j += ((String)o).length()) < remainCharCount || j >= len - pushCharCount) continue;
                result[k++] = j + iIgnoreAtBeginning;
            }
        } else {
            word[0] = 46;
            word[len + 1] = 46;
            word[len + 2] = '\u0000';
            byte[] il = new byte[len + 3];
            for (i = 0; i < len + 1; ++i) {
                this.searchPatterns(word, i, il);
            }
            for (i = 0; i < len; ++i) {
                if ((il[i + 1] & 1) != 1 || i < remainCharCount || i > len - pushCharCount) continue;
                result[k++] = i + iIgnoreAtBeginning;
            }
        }
        if (k > 0) {
            int[] res = new int[k];
            System.arraycopy(result, 0, res, 0, k);
            return new Hyphenation(new String(w, offset, len), res);
        }
        return null;
    }

    @Override
    public void addClass(String chargroup) {
        if (chargroup.length() > 0) {
            char equivChar = chargroup.charAt(0);
            char[] key = new char[2];
            key[1] = '\u0000';
            for (int i = 0; i < chargroup.length(); ++i) {
                key[0] = chargroup.charAt(i);
                this.classmap.insert(key, 0, equivChar);
            }
        }
    }

    @Override
    public void addException(String word, ArrayList hyphenatedword) {
        this.stoplist.put(word, hyphenatedword);
    }

    @Override
    public void addPattern(String pattern, String ivalue) {
        int k = this.ivalues.find(ivalue);
        if (k <= 0) {
            k = this.packValues(ivalue);
            this.ivalues.insert(ivalue, (char)k);
        }
        this.insert(pattern, (char)k);
    }

    @Override
    public void printStats() {
        System.out.println("Value space size = " + Integer.toString(this.vspace.length()));
        super.printStats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void main(String[] argv) throws Exception {
        block46: {
            ht = null;
            minCharCount = 2;
            in = new BufferedReader(new InputStreamReader(System.in));
            while (true) lbl-1000:
            // 17 sources

            {
                block47: {
                    System.out.print("l:\tload patterns from XML\nL:\tload patterns from serialized object\ns:\tset minimum character count\nw:\twrite hyphenation tree to object file\nh:\thyphenate\nf:\tfind pattern\nb:\tbenchmark\nq:\tquit\n\nCommand:");
                    token = in.readLine();
                    if (token == null) break block46;
                    if ((token = token.trim()).equals("f")) {
                        System.out.print("Pattern: ");
                        token = in.readLine();
                        if (token != null) {
                            token = token.trim();
                            System.out.println("Values: " + ht.findPattern(token));
                            continue;
                        }
                        break;
                    }
                    if (token.equals("s")) {
                        System.out.print("Minimun value: ");
                        token = in.readLine();
                        if (token != null) {
                            token = token.trim();
                            minCharCount = Integer.parseInt(token);
                            continue;
                        }
                        break;
                    }
                    if (token.equals("l")) {
                        ht = new HyphenationTree();
                        System.out.print("XML file name: ");
                        token = in.readLine();
                        if (token != null) {
                            token = token.trim();
                            ht.loadPatterns(token);
                            continue;
                        }
                        break;
                    }
                    if (token.equals("L")) {
                        ois = null;
                        System.out.print("Object file name: ");
                        token = in.readLine();
                        if (token == null) break block46;
                        token = token.trim();
                        try {
                            ois = new ObjectInputStream(new FileInputStream(token));
                            ht = (HyphenationTree)ois.readObject();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        finally {
                            if (ois == null) ** GOTO lbl-1000
                            try {
                                ois.close();
                            }
                            catch (IOException e) {}
                        }
                        continue;
                    }
                    if (token.equals("w")) {
                        System.out.print("Object file name: ");
                        token = in.readLine();
                        if (token == null) break block46;
                        token = token.trim();
                        oos = null;
                        try {
                            oos = new ObjectOutputStream(new FileOutputStream(token));
                            oos.writeObject(ht);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        finally {
                            if (oos == null) ** GOTO lbl-1000
                            try {
                                oos.flush();
                            }
                            catch (IOException var6_15) {}
                            try {
                                oos.close();
                            }
                            catch (IOException var6_16) {}
                        }
                        continue;
                    }
                    if (token.equals("h")) {
                        System.out.print("Word: ");
                        token = in.readLine();
                        if (token != null) {
                            token = token.trim();
                            System.out.print("Hyphenation points: ");
                            System.out.println(ht.hyphenate(token, minCharCount, minCharCount));
                            continue;
                        }
                        break;
                    }
                    if (!token.equals("b")) break block47;
                    if (ht == null) {
                        System.out.println("No patterns have been loaded.");
                        break;
                    }
                    System.out.print("Word list filename: ");
                    token = in.readLine();
                    if (token == null) break block46;
                    token = token.trim();
                    starttime = 0L;
                    counter = 0;
                    reader = null;
                    try {
                        reader = new BufferedReader(new FileReader(token));
                        starttime = System.currentTimeMillis();
                        while ((line = reader.readLine()) != null) {
                            hyp = ht.hyphenate(line, minCharCount, minCharCount);
                            if (hyp != null) {
                                var11_29 = hyp.toString();
                            }
                            ++counter;
                        }
                    }
                    catch (Exception ioe) {
                        try {
                            System.out.println("Exception " + ioe);
                            ioe.printStackTrace();
                        }
                        catch (Throwable var12_30) {
                            IOUtils.closeQuietly(reader);
                            throw var12_30;
                        }
                        IOUtils.closeQuietly(reader);
                    }
                    IOUtils.closeQuietly(reader);
                    endtime = System.currentTimeMillis();
                    result = endtime - starttime;
                    System.out.println(counter + " words in " + result + " Milliseconds hyphenated");
                    continue;
                }
                if (token.equals("q")) ** break;
            }
        }
    }
}

