/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow.table;

import java.util.LinkedList;
import java.util.List;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.flow.table.FixedColRowGroupBuilder;
import org.apache.fop.fo.flow.table.RowGroupBuilder;
import org.apache.fop.fo.flow.table.Table;
import org.apache.fop.fo.flow.table.TableCell;
import org.apache.fop.fo.flow.table.TablePart;
import org.apache.fop.fo.flow.table.TableRow;

class VariableColRowGroupBuilder
extends RowGroupBuilder {
    private List events = new LinkedList();

    VariableColRowGroupBuilder(Table t2) {
        super(t2);
    }

    @Override
    void addTableCell(final TableCell cell) {
        this.events.add(new Event(){

            @Override
            public void play(RowGroupBuilder rowGroupBuilder) {
                rowGroupBuilder.addTableCell(cell);
            }
        });
    }

    @Override
    void startTableRow(final TableRow tableRow) {
        this.events.add(new Event(){

            @Override
            public void play(RowGroupBuilder rowGroupBuilder) {
                rowGroupBuilder.startTableRow(tableRow);
            }
        });
    }

    @Override
    void endTableRow() {
        this.events.add(new Event(){

            @Override
            public void play(RowGroupBuilder rowGroupBuilder) {
                rowGroupBuilder.endTableRow();
            }
        });
    }

    @Override
    void endRow(final TablePart part) {
        this.events.add(new Event(){

            @Override
            public void play(RowGroupBuilder rowGroupBuilder) {
                rowGroupBuilder.endRow(part);
            }
        });
    }

    @Override
    void startTablePart(final TablePart part) {
        this.events.add(new Event(){

            @Override
            public void play(RowGroupBuilder rowGroupBuilder) {
                rowGroupBuilder.startTablePart(part);
            }
        });
    }

    @Override
    void endTablePart() throws ValidationException {
        this.events.add(new Event(){

            @Override
            public void play(RowGroupBuilder rowGroupBuilder) throws ValidationException {
                rowGroupBuilder.endTablePart();
            }
        });
    }

    @Override
    void endTable() throws ValidationException {
        FixedColRowGroupBuilder delegate = new FixedColRowGroupBuilder(this.table);
        for (Object event : this.events) {
            ((Event)event).play(delegate);
        }
        ((RowGroupBuilder)delegate).endTable();
    }

    private static interface Event {
        public void play(RowGroupBuilder var1) throws ValidationException;
    }
}

