/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.expr;

import org.apache.fop.datatypes.PercentBase;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.FunctionBase;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.expr.PropertyInfo;
import org.apache.fop.fo.flow.table.Table;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.TableColLength;

public class ProportionalColumnWidthFunction
extends FunctionBase {
    @Override
    public int getRequiredArgsCount() {
        return 1;
    }

    @Override
    public PercentBase getPercentBase() {
        return new ProportionalColumnWidthPercentBase();
    }

    @Override
    public Property eval(Property[] args, PropertyInfo pInfo) throws PropertyException {
        Number d = args[0].getNumber();
        if (d == null) {
            throw new PropertyException("Non numeric operand to proportional-column-width() function.");
        }
        PropertyList pList = pInfo.getPropertyList();
        if (!"fo:table-column".equals(pList.getFObj().getName())) {
            throw new PropertyException("proportional-column-width() function may only be used on fo:table-column.");
        }
        Table t2 = (Table)pList.getParentFObj();
        if (t2.isAutoLayout()) {
            throw new PropertyException("proportional-column-width() function may only be used when fo:table has table-layout=\"fixed\".");
        }
        return new TableColLength(d.doubleValue(), pInfo.getFO());
    }

    private static class ProportionalColumnWidthPercentBase
    implements PercentBase {
        private ProportionalColumnWidthPercentBase() {
        }

        @Override
        public int getBaseLength(PercentBaseContext context) throws PropertyException {
            return 0;
        }

        @Override
        public double getBaseValue() {
            return 1.0;
        }

        @Override
        public int getDimension() {
            return 0;
        }
    }
}

