/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.expr;

import java.util.List;
import org.apache.fop.fo.FOPropertyMapping;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.expr.FunctionBase;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.expr.PropertyInfo;
import org.apache.fop.fo.flow.table.ColumnNumberManager;
import org.apache.fop.fo.flow.table.Table;
import org.apache.fop.fo.flow.table.TableCell;
import org.apache.fop.fo.flow.table.TableColumn;
import org.apache.fop.fo.flow.table.TableFObj;
import org.apache.fop.fo.properties.Property;

public class FromTableColumnFunction
extends FunctionBase {
    @Override
    public int getRequiredArgsCount() {
        return 0;
    }

    @Override
    public int getOptionalArgsCount() {
        return 1;
    }

    @Override
    public Property getOptionalArgDefault(int index, PropertyInfo pi) throws PropertyException {
        if (index == 0) {
            return this.getPropertyName(pi);
        }
        return super.getOptionalArgDefault(index, pi);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Property eval(Property[] args, PropertyInfo pInfo) throws PropertyException {
        FObj fo = pInfo.getPropertyList().getFObj();
        int propId = 0;
        if (args.length == 0) {
            propId = pInfo.getPropertyMaker().getPropId();
        } else {
            String propName = args[0].getString();
            propId = FOPropertyMapping.getPropertyId(propName);
        }
        if (propId == -1) throw new PropertyException("Incorrect parameter to from-table-column() function");
        int columnNumber = -1;
        int span = 0;
        if (fo.getNameId() != 75) {
            while ((fo = (FObj)fo.getParent()).getNameId() != 75 && fo.getNameId() != 53) {
            }
            if (fo.getNameId() != 75) throw new PropertyException("from-table-column() may only be used on fo:table-cell or its descendants.");
            columnNumber = ((TableCell)fo).getColumnNumber();
            span = ((TableCell)fo).getNumberColumnsSpanned();
        } else {
            columnNumber = pInfo.getPropertyList().get(76).getNumeric().getValue();
            span = pInfo.getPropertyList().get(165).getNumeric().getValue();
        }
        Table t2 = ((TableFObj)fo).getTable();
        List cols = t2.getColumns();
        ColumnNumberManager columnIndexManager = t2.getColumnNumberManager();
        if (cols == null) {
            return pInfo.getPropertyList().get(propId, false, true);
        }
        if (columnIndexManager.isColumnNumberUsed(columnNumber)) {
            return ((TableColumn)cols.get(columnNumber - 1)).getProperty(propId);
        }
        while (--span > 0 && !columnIndexManager.isColumnNumberUsed(++columnNumber)) {
        }
        if (!columnIndexManager.isColumnNumberUsed(columnNumber)) return pInfo.getPropertyList().get(propId, false, true);
        return ((TableColumn)cols.get(columnNumber - 1)).getProperty(propId);
    }
}

