/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import java.util.HashMap;
import java.util.Map;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.fo.BorderShorthandParser;
import org.apache.fop.fo.Constants;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.flow.table.TableFObj;
import org.apache.fop.fo.properties.BackgroundPositionShorthand;
import org.apache.fop.fo.properties.BorderSpacingShorthandParser;
import org.apache.fop.fo.properties.BorderWidthPropertyMaker;
import org.apache.fop.fo.properties.BoxCornerPropShorthandParser;
import org.apache.fop.fo.properties.BoxPropShorthandParser;
import org.apache.fop.fo.properties.CharacterProperty;
import org.apache.fop.fo.properties.ColorProperty;
import org.apache.fop.fo.properties.CondLengthProperty;
import org.apache.fop.fo.properties.CorrespondingPropertyMaker;
import org.apache.fop.fo.properties.DimensionPropertyMaker;
import org.apache.fop.fo.properties.EnumProperty;
import org.apache.fop.fo.properties.FontFamilyProperty;
import org.apache.fop.fo.properties.FontShorthandParser;
import org.apache.fop.fo.properties.FontShorthandProperty;
import org.apache.fop.fo.properties.FontSizePropertyMaker;
import org.apache.fop.fo.properties.FontStretchPropertyMaker;
import org.apache.fop.fo.properties.FontWeightPropertyMaker;
import org.apache.fop.fo.properties.GenericShorthandParser;
import org.apache.fop.fo.properties.IndentPropertyMaker;
import org.apache.fop.fo.properties.KeepProperty;
import org.apache.fop.fo.properties.LengthPairProperty;
import org.apache.fop.fo.properties.LengthProperty;
import org.apache.fop.fo.properties.LengthRangeProperty;
import org.apache.fop.fo.properties.LineHeightPropertyMaker;
import org.apache.fop.fo.properties.ListProperty;
import org.apache.fop.fo.properties.NumberProperty;
import org.apache.fop.fo.properties.OptionalCharacterProperty;
import org.apache.fop.fo.properties.PageBreakShorthandParser;
import org.apache.fop.fo.properties.PageDimensionMaker;
import org.apache.fop.fo.properties.PositionShorthandParser;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.PropertyMaker;
import org.apache.fop.fo.properties.ReferenceOrientationMaker;
import org.apache.fop.fo.properties.SpaceProperty;
import org.apache.fop.fo.properties.SpacePropertyMaker;
import org.apache.fop.fo.properties.SpacingPropertyMaker;
import org.apache.fop.fo.properties.StringProperty;
import org.apache.fop.fo.properties.TableBorderPrecedence;
import org.apache.fop.fo.properties.TextDecorationMaker;
import org.apache.fop.fo.properties.ToBeImplementedProperty;
import org.apache.fop.fo.properties.URIProperty;
import org.apache.fop.fo.properties.VerticalAlignShorthandParser;
import org.apache.fop.fo.properties.WhiteSpaceShorthandParser;
import org.apache.fop.fo.properties.XMLLangShorthandParser;

public final class FOPropertyMapping
implements Constants {
    private static Map<String, Integer> propNames = new HashMap<String, Integer>();
    private static Map<String, Integer> subPropNames = new HashMap<String, Integer>();
    private static Map<Integer, String> propIds = new HashMap<Integer, String>();
    private static PropertyMaker[] generics = new PropertyMaker[295];
    private Property[] enums;
    private PropertyMaker genericColor;
    private PropertyMaker genericBoolean;
    private PropertyMaker genericKeep;
    private PropertyMaker genericCondLength;
    private PropertyMaker genericCondPadding;
    private PropertyMaker genericPadding;
    private PropertyMaker genericCondBorderWidth;
    PropertyMaker genericBorderWidth;
    private PropertyMaker genericBorderStyle;
    private PropertyMaker genericCondCornerRadius;
    private PropertyMaker genericBreak;
    private PropertyMaker genericSpace;

    private FOPropertyMapping() {
    }

    private void createGenerics() {
        this.genericColor = new ColorProperty.Maker(0);
        this.genericBoolean = new EnumProperty.Maker(0);
        this.genericBoolean.addEnum("true", this.getEnumProperty(149, "TRUE"));
        this.genericBoolean.addEnum("false", this.getEnumProperty(48, "FALSE"));
        this.genericKeep = new KeepProperty.Maker(0);
        PropertyMaker sub = new NumberProperty.Maker(5632);
        sub.setByShorthand(true);
        sub.setDefault("auto");
        sub.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        sub.addEnum("always", this.getEnumProperty(7, "ALWAYS"));
        this.genericKeep.addSubpropMaker(sub);
        sub = new NumberProperty.Maker(5120);
        sub.setByShorthand(true);
        sub.setDefault("auto");
        sub.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        sub.addEnum("always", this.getEnumProperty(7, "ALWAYS"));
        this.genericKeep.addSubpropMaker(sub);
        sub = new NumberProperty.Maker(4608);
        sub.setByShorthand(true);
        sub.setDefault("auto");
        sub.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        sub.addEnum("always", this.getEnumProperty(7, "ALWAYS"));
        this.genericKeep.addSubpropMaker(sub);
        this.genericCondLength = new CondLengthProperty.Maker(0);
        sub = new LengthProperty.Maker(2048);
        sub.setByShorthand(true);
        this.genericCondLength.addSubpropMaker(sub);
        sub = new EnumProperty.Maker(1024);
        sub.addEnum("discard", this.getEnumProperty(32, "DISCARD"));
        sub.addEnum("retain", this.getEnumProperty(118, "RETAIN"));
        this.genericCondLength.addSubpropMaker(sub);
        this.genericCondPadding = new CondLengthProperty.Maker(0);
        this.genericCondPadding.useGeneric(this.genericCondLength);
        this.genericCondPadding.setInherited(false);
        this.genericCondPadding.getSubpropMaker(2048).setDefault("0pt");
        this.genericCondPadding.setPercentBase(5);
        this.genericPadding = new LengthProperty.Maker(0);
        this.genericPadding.setInherited(false);
        this.genericPadding.setDefault("0pt");
        this.genericPadding.setPercentBase(5);
        this.genericPadding.addShorthand(generics[170]);
        this.genericCondBorderWidth = new CondLengthProperty.Maker(0);
        this.genericCondBorderWidth.setInherited(false);
        this.genericCondBorderWidth.addKeyword("thin", "0.5pt");
        this.genericCondBorderWidth.addKeyword("medium", "1pt");
        this.genericCondBorderWidth.addKeyword("thick", "2pt");
        sub = new LengthProperty.Maker(2048);
        sub.setByShorthand(true);
        sub.addKeyword("thin", "0.5pt");
        sub.addKeyword("medium", "1pt");
        sub.addKeyword("thick", "2pt");
        sub.setDefault("medium");
        this.genericCondBorderWidth.addSubpropMaker(sub);
        sub = new EnumProperty.Maker(1024);
        sub.addEnum("discard", this.getEnumProperty(32, "DISCARD"));
        sub.addEnum("retain", this.getEnumProperty(118, "RETAIN"));
        this.genericCondBorderWidth.addSubpropMaker(sub);
        this.genericBorderWidth = new LengthProperty.Maker(0);
        this.genericBorderWidth.setInherited(false);
        this.genericBorderWidth.addKeyword("thin", "0.5pt");
        this.genericBorderWidth.addKeyword("medium", "1pt");
        this.genericBorderWidth.addKeyword("thick", "2pt");
        this.genericBorderWidth.setDefault("medium");
        this.genericBorderStyle = new EnumProperty.Maker(0);
        this.genericBorderStyle.setInherited(false);
        this.genericBorderStyle.addEnum("none", this.getEnumProperty(95, "NONE"));
        this.genericBorderStyle.addEnum("hidden", this.getEnumProperty(57, "HIDDEN"));
        this.genericBorderStyle.addEnum("dotted", this.getEnumProperty(36, "DOTTED"));
        this.genericBorderStyle.addEnum("dashed", this.getEnumProperty(31, "DASHED"));
        this.genericBorderStyle.addEnum("solid", this.getEnumProperty(133, "SOLID"));
        this.genericBorderStyle.addEnum("double", this.getEnumProperty(37, "DOUBLE"));
        this.genericBorderStyle.addEnum("groove", this.getEnumProperty(55, "GROOVE"));
        this.genericBorderStyle.addEnum("ridge", this.getEnumProperty(119, "RIDGE"));
        this.genericBorderStyle.addEnum("inset", this.getEnumProperty(67, "INSET"));
        this.genericBorderStyle.addEnum("outset", this.getEnumProperty(101, "OUTSET"));
        this.genericBorderStyle.setDefault("none");
        this.genericCondCornerRadius = new CondLengthProperty.Maker(0);
        this.genericCondCornerRadius.useGeneric(this.genericCondLength);
        this.genericCondCornerRadius.setInherited(false);
        this.genericCondCornerRadius.getSubpropMaker(2048).setDefault("0pt");
        this.genericCondCornerRadius.setPercentBase(6);
        this.genericBreak = new EnumProperty.Maker(0);
        this.genericBreak.setInherited(false);
        this.genericBreak.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        this.genericBreak.addEnum("column", this.getEnumProperty(28, "COLUMN"));
        this.genericBreak.addEnum("page", this.getEnumProperty(104, "PAGE"));
        this.genericBreak.addEnum("even-page", this.getEnumProperty(44, "EVEN_PAGE"));
        this.genericBreak.addEnum("odd-page", this.getEnumProperty(100, "ODD_PAGE"));
        this.genericBreak.setDefault("auto");
        this.genericSpace = new SpaceProperty.Maker(0);
        this.genericSpace.setInherited(false);
        sub = new LengthProperty.Maker(3072);
        sub.setDefault("0pt");
        sub.setByShorthand(true);
        this.genericSpace.addSubpropMaker(sub);
        sub = new LengthProperty.Maker(3584);
        sub.setDefault("0pt");
        sub.setByShorthand(true);
        this.genericSpace.addSubpropMaker(sub);
        sub = new LengthProperty.Maker(2560);
        sub.setDefault("0pt");
        sub.setByShorthand(true);
        this.genericSpace.addSubpropMaker(sub);
        sub = new NumberProperty.Maker(4096);
        sub.addEnum("force", this.getEnumProperty(53, "FORCE"));
        sub.setDefault("0");
        this.genericSpace.addSubpropMaker(sub);
        sub = new EnumProperty.Maker(1024);
        sub.addEnum("discard", this.getEnumProperty(32, "DISCARD"));
        sub.addEnum("retain", this.getEnumProperty(118, "RETAIN"));
        sub.setDefault("discard");
        this.genericSpace.addSubpropMaker(sub);
    }

    private static void addPropertyMaker(String name, PropertyMaker maker) {
        FOPropertyMapping.generics[maker.getPropId()] = maker;
        propNames.put(name, maker.getPropId());
        propIds.put(maker.getPropId(), name);
    }

    private static void addSubpropMakerName(String name, int id) {
        subPropNames.put(name, id);
        propIds.put(id, name);
    }

    private Property getEnumProperty(int enumValue, String text) {
        if (this.enums == null) {
            this.enums = new Property[206];
        }
        if (this.enums[enumValue] == null) {
            this.enums[enumValue] = EnumProperty.getInstance(enumValue, text);
        }
        return this.enums[enumValue];
    }

    public static PropertyMaker[] getGenericMappings() {
        return generics;
    }

    public static int getPropertyId(String name) {
        Integer i;
        if (name != null && (i = propNames.get(name)) != null) {
            return i;
        }
        return -1;
    }

    public static int getSubPropertyId(String name) {
        Integer i;
        if (name != null && (i = subPropNames.get(name)) != null) {
            return i;
        }
        return -1;
    }

    public static String getPropertyName(int id) {
        if ((id & 0xFFFFFE00) == 0 || (id & 0x1FF) == 0) {
            return propIds.get(id);
        }
        return propIds.get(id & 0x1FF) + "." + propIds.get(id & 0xFFFFFE00);
    }

    private void createAccessibilityProperties() {
        StringProperty.Maker m4 = new StringProperty.Maker(221);
        m4.setInherited(false);
        m4.setDefault("none");
        FOPropertyMapping.addPropertyMaker("source-document", m4);
        m4 = new StringProperty.Maker(212);
        m4.setInherited(false);
        m4.setDefault("none");
        FOPropertyMapping.addPropertyMaker("role", m4);
    }

    private void createAbsolutePositionProperties() {
        EnumProperty.Maker m4 = new EnumProperty.Maker(1);
        m4.setInherited(false);
        m4.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        m4.addEnum("fixed", this.getEnumProperty(51, "FIXED"));
        m4.addEnum("absolute", this.getEnumProperty(1, "ABSOLUTE"));
        m4.setDefault("auto");
        m4.addShorthand(generics[193]);
        FOPropertyMapping.addPropertyMaker("absolute-position", m4);
        LengthProperty.Maker l = new LengthProperty.Maker(253);
        l.setInherited(false);
        l.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        l.setDefault("auto");
        l.setPercentBase(6);
        FOPropertyMapping.addPropertyMaker("top", l);
        l = new LengthProperty.Maker(211);
        l.setInherited(false);
        l.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        l.setDefault("auto");
        l.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("right", l);
        l = new LengthProperty.Maker(57);
        l.setInherited(false);
        l.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        l.setDefault("auto");
        l.setPercentBase(6);
        FOPropertyMapping.addPropertyMaker("bottom", l);
        l = new LengthProperty.Maker(140);
        l.setInherited(false);
        l.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        l.setDefault("auto");
        l.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("left", l);
    }

    private void createAuralProperties() {
        ToBeImplementedProperty.Maker m4 = new ToBeImplementedProperty.Maker(6);
        m4.setInherited(true);
        m4.setDefault("center");
        FOPropertyMapping.addPropertyMaker("azimuth", m4);
        m4 = new ToBeImplementedProperty.Maker(83);
        m4.setInherited(false);
        m4.setDefault("none");
        FOPropertyMapping.addPropertyMaker("cue-after", m4);
        m4 = new ToBeImplementedProperty.Maker(84);
        m4.setInherited(false);
        m4.setDefault("none");
        FOPropertyMapping.addPropertyMaker("cue-before", m4);
        m4 = new ToBeImplementedProperty.Maker(89);
        m4.setInherited(true);
        m4.setDefault("level");
        FOPropertyMapping.addPropertyMaker("elevation", m4);
        m4 = new ToBeImplementedProperty.Maker(188);
        m4.setInherited(false);
        m4.setDefault("");
        FOPropertyMapping.addPropertyMaker("pause-after", m4);
        m4 = new ToBeImplementedProperty.Maker(189);
        m4.setInherited(false);
        m4.setDefault("");
        FOPropertyMapping.addPropertyMaker("pause-before", m4);
        m4 = new ToBeImplementedProperty.Maker(190);
        m4.setInherited(true);
        m4.setDefault("medium");
        FOPropertyMapping.addPropertyMaker("pitch", m4);
        m4 = new ToBeImplementedProperty.Maker(191);
        m4.setInherited(true);
        m4.setDefault("50");
        FOPropertyMapping.addPropertyMaker("pitch-range", m4);
        m4 = new ToBeImplementedProperty.Maker(192);
        m4.setInherited(false);
        m4.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("play-during", m4);
        m4 = new ToBeImplementedProperty.Maker(210);
        m4.setInherited(true);
        m4.setDefault("50");
        FOPropertyMapping.addPropertyMaker("richness", m4);
        m4 = new ToBeImplementedProperty.Maker(227);
        m4.setInherited(true);
        m4.setDefault("normal");
        FOPropertyMapping.addPropertyMaker("speak", m4);
        m4 = new ToBeImplementedProperty.Maker(228);
        m4.setInherited(true);
        m4.setDefault("once");
        FOPropertyMapping.addPropertyMaker("speak-header", m4);
        m4 = new ToBeImplementedProperty.Maker(229);
        m4.setInherited(true);
        m4.setDefault("continuous");
        FOPropertyMapping.addPropertyMaker("speak-numeral", m4);
        m4 = new ToBeImplementedProperty.Maker(230);
        m4.setInherited(true);
        m4.setDefault("none");
        FOPropertyMapping.addPropertyMaker("speak-punctuation", m4);
        m4 = new ToBeImplementedProperty.Maker(231);
        m4.setInherited(true);
        m4.setDefault("medium");
        FOPropertyMapping.addPropertyMaker("speech-rate", m4);
        m4 = new ToBeImplementedProperty.Maker(236);
        m4.setInherited(true);
        m4.setDefault("50");
        FOPropertyMapping.addPropertyMaker("stress", m4);
        m4 = new ToBeImplementedProperty.Maker(258);
        m4.setInherited(true);
        m4.setDefault("");
        FOPropertyMapping.addPropertyMaker("voice-family", m4);
        m4 = new ToBeImplementedProperty.Maker(259);
        m4.setInherited(true);
        m4.setDefault("medium");
        FOPropertyMapping.addPropertyMaker("volume", m4);
    }

    private void createBorderPaddingBackgroundProperties() {
        PropertyMaker m4 = new EnumProperty.Maker(8);
        m4.setInherited(false);
        m4.addEnum("scroll", this.getEnumProperty(126, "SCROLL"));
        m4.addEnum("fixed", this.getEnumProperty(51, "FIXED"));
        m4.setDefault("scroll");
        FOPropertyMapping.addPropertyMaker("background-attachment", m4);
        m4 = new ColorProperty.Maker(9){

            @Override
            protected Property convertPropertyDatatype(Property p, PropertyList propertyList, FObj fo) throws PropertyException {
                String nameval = p.getNCname();
                if (nameval != null) {
                    FObj fobj = fo == null ? propertyList.getFObj() : fo;
                    FOUserAgent ua = fobj == null ? null : fobj.getUserAgent();
                    return ColorProperty.getInstance(ua, nameval);
                }
                return super.convertPropertyDatatype(p, propertyList, fo);
            }
        };
        m4.useGeneric(this.genericColor);
        m4.setInherited(false);
        m4.setDefault("transparent");
        FOPropertyMapping.addPropertyMaker("background-color", m4);
        m4 = new StringProperty.Maker(10);
        m4.setInherited(false);
        m4.setDefault("none");
        FOPropertyMapping.addPropertyMaker("background-image", m4);
        m4 = new EnumProperty.Maker(14);
        m4.setInherited(false);
        m4.addEnum("repeat", this.getEnumProperty(112, "REPEAT"));
        m4.addEnum("repeat-x", this.getEnumProperty(113, "REPEATX"));
        m4.addEnum("repeat-y", this.getEnumProperty(114, "REPEATY"));
        m4.addEnum("no-repeat", this.getEnumProperty(96, "NOREPEAT"));
        m4.setDefault("repeat");
        FOPropertyMapping.addPropertyMaker("background-repeat", m4);
        m4 = new LengthProperty.Maker(12);
        m4.setInherited(false);
        m4.setDefault("0pt");
        m4.addKeyword("left", "0pt");
        m4.addKeyword("center", "50%");
        m4.addKeyword("right", "100%");
        m4.setPercentBase(9);
        m4.addShorthand(generics[11]);
        FOPropertyMapping.addPropertyMaker("background-position-horizontal", m4);
        m4 = new LengthProperty.Maker(13);
        m4.setInherited(false);
        m4.setDefault("0pt");
        m4.addKeyword("top", "0pt");
        m4.addKeyword("center", "50%");
        m4.addKeyword("bottom", "100%");
        m4.setPercentBase(10);
        m4.addShorthand(generics[11]);
        FOPropertyMapping.addPropertyMaker("background-position-vertical", m4);
        m4 = new ColorProperty.Maker(23);
        m4.useGeneric(this.genericColor);
        m4.setInherited(false);
        m4.setDefault("black");
        CorrespondingPropertyMaker corr = new CorrespondingPropertyMaker(m4);
        corr.setCorresponding(53, 53, 42, 38);
        corr.setRelative(true);
        FOPropertyMapping.addPropertyMaker("border-before-color", m4);
        m4 = new EnumProperty.Maker(25);
        m4.useGeneric(this.genericBorderStyle);
        corr = new CorrespondingPropertyMaker(m4);
        corr.setCorresponding(54, 54, 43, 39);
        corr.setRelative(true);
        FOPropertyMapping.addPropertyMaker("border-before-style", m4);
        m4 = new CondLengthProperty.Maker(26);
        m4.useGeneric(this.genericCondBorderWidth);
        m4.getSubpropMaker(1024).setDefault("discard");
        corr = new CorrespondingPropertyMaker(m4);
        corr.setCorresponding(55, 55, 44, 40);
        corr.setRelative(true);
        FOPropertyMapping.addPropertyMaker("border-before-width", m4);
        m4 = new ColorProperty.Maker(19);
        m4.useGeneric(this.genericColor);
        m4.setInherited(false);
        m4.setDefault("black");
        corr = new CorrespondingPropertyMaker(m4);
        corr.setCorresponding(28, 28, 38, 42);
        corr.setRelative(true);
        FOPropertyMapping.addPropertyMaker("border-after-color", m4);
        m4 = new EnumProperty.Maker(21);
        m4.useGeneric(this.genericBorderStyle);
        corr = new CorrespondingPropertyMaker(m4);
        corr.setCorresponding(29, 29, 39, 43);
        corr.setRelative(true);
        FOPropertyMapping.addPropertyMaker("border-after-style", m4);
        m4 = new CondLengthProperty.Maker(22);
        m4.useGeneric(this.genericCondBorderWidth);
        m4.getSubpropMaker(1024).setDefault("discard");
        corr = new CorrespondingPropertyMaker(m4);
        corr.setCorresponding(30, 30, 40, 40);
        corr.setRelative(true);
        FOPropertyMapping.addPropertyMaker("border-after-width", m4);
        m4 = new ColorProperty.Maker(47);
        m4.useGeneric(this.genericColor);
        m4.setInherited(false);
        m4.setDefault("black");
        corr = new CorrespondingPropertyMaker(m4);
        corr.setCorresponding(38, 42, 53, 53);
        corr.setRelative(true);
        FOPropertyMapping.addPropertyMaker("border-start-color", m4);
        m4 = new EnumProperty.Maker(49);
        m4.useGeneric(this.genericBorderStyle);
        corr = new CorrespondingPropertyMaker(m4);
        corr.setCorresponding(39, 43, 54, 54);
        corr.setRelative(true);
        FOPropertyMapping.addPropertyMaker("border-start-style", m4);
        m4 = new CondLengthProperty.Maker(50);
        m4.useGeneric(this.genericCondBorderWidth);
        m4.getSubpropMaker(1024).setDefault("discard");
        corr = new CorrespondingPropertyMaker(m4);
        corr.setCorresponding(40, 44, 55, 55);
        corr.setRelative(true);
        FOPropertyMapping.addPropertyMaker("border-start-width", m4);
        m4 = new ColorProperty.Maker(33);
        m4.useGeneric(this.genericColor);
        m4.setInherited(false);
        m4.setDefault("black");
        corr = new CorrespondingPropertyMaker(m4);
        corr.setCorresponding(42, 38, 28, 28);
        corr.setRelative(true);
        FOPropertyMapping.addPropertyMaker("border-end-color", m4);
        m4 = new EnumProperty.Maker(35);
        m4.useGeneric(this.genericBorderStyle);
        corr = new CorrespondingPropertyMaker(m4);
        corr.setCorresponding(43, 39, 29, 29);
        corr.setRelative(true);
        FOPropertyMapping.addPropertyMaker("border-end-style", m4);
        m4 = new CondLengthProperty.Maker(36);
        m4.useGeneric(this.genericCondBorderWidth);
        m4.getSubpropMaker(1024).setDefault("discard");
        corr = new CorrespondingPropertyMaker(m4);
        corr.setCorresponding(44, 40, 30, 30);
        corr.setRelative(true);
        FOPropertyMapping.addPropertyMaker("border-end-width", m4);
        m4 = new ColorProperty.Maker(53);
        m4.useGeneric(this.genericColor);
        m4.setInherited(false);
        m4.setDefault("black");
        m4.addShorthand(generics[52]);
        m4.addShorthand(generics[32]);
        m4.addShorthand(generics[18]);
        corr = new CorrespondingPropertyMaker(m4);
        corr.setCorresponding(23, 23, 47, 47);
        FOPropertyMapping.addPropertyMaker("border-top-color", m4);
        m4 = new EnumProperty.Maker(54);
        m4.useGeneric(this.genericBorderStyle);
        m4.addShorthand(generics[52]);
        m4.addShorthand(generics[51]);
        m4.addShorthand(generics[18]);
        corr = new CorrespondingPropertyMaker(m4);
        corr.setCorresponding(25, 25, 49, 49);
        FOPropertyMapping.addPropertyMaker("border-top-style", m4);
        BorderWidthPropertyMaker bwm = new BorderWidthPropertyMaker(55);
        bwm.useGeneric(this.genericBorderWidth);
        bwm.setBorderStyleId(54);
        bwm.addShorthand(generics[52]);
        bwm.addShorthand(generics[56]);
        bwm.addShorthand(generics[18]);
        corr = new CorrespondingPropertyMaker(bwm);
        corr.setCorresponding(26, 26, 50, 50);
        FOPropertyMapping.addPropertyMaker("border-top-width", bwm);
        m4 = new ColorProperty.Maker(28);
        m4.useGeneric(this.genericColor);
        m4.setInherited(false);
        m4.setDefault("black");
        m4.addShorthand(generics[27]);
        m4.addShorthand(generics[32]);
        m4.addShorthand(generics[18]);
        corr = new CorrespondingPropertyMaker(m4);
        corr.setCorresponding(19, 19, 33, 33);
        FOPropertyMapping.addPropertyMaker("border-bottom-color", m4);
        m4 = new EnumProperty.Maker(29);
        m4.useGeneric(this.genericBorderStyle);
        m4.addShorthand(generics[27]);
        m4.addShorthand(generics[51]);
        m4.addShorthand(generics[18]);
        corr = new CorrespondingPropertyMaker(m4);
        corr.setCorresponding(21, 21, 35, 35);
        FOPropertyMapping.addPropertyMaker("border-bottom-style", m4);
        bwm = new BorderWidthPropertyMaker(30);
        bwm.useGeneric(this.genericBorderWidth);
        bwm.setBorderStyleId(29);
        bwm.addShorthand(generics[27]);
        bwm.addShorthand(generics[56]);
        bwm.addShorthand(generics[18]);
        corr = new CorrespondingPropertyMaker(bwm);
        corr.setCorresponding(22, 22, 36, 36);
        FOPropertyMapping.addPropertyMaker("border-bottom-width", bwm);
        m4 = new ColorProperty.Maker(38);
        m4.useGeneric(this.genericColor);
        m4.setInherited(false);
        m4.setDefault("black");
        m4.addShorthand(generics[37]);
        m4.addShorthand(generics[32]);
        m4.addShorthand(generics[18]);
        corr = new CorrespondingPropertyMaker(m4);
        corr.setCorresponding(47, 33, 19, 23);
        FOPropertyMapping.addPropertyMaker("border-left-color", m4);
        m4 = new EnumProperty.Maker(39);
        m4.useGeneric(this.genericBorderStyle);
        m4.addShorthand(generics[37]);
        m4.addShorthand(generics[51]);
        m4.addShorthand(generics[18]);
        corr = new CorrespondingPropertyMaker(m4);
        corr.setCorresponding(49, 35, 21, 25);
        FOPropertyMapping.addPropertyMaker("border-left-style", m4);
        bwm = new BorderWidthPropertyMaker(40);
        bwm.useGeneric(this.genericBorderWidth);
        bwm.setBorderStyleId(39);
        bwm.addShorthand(generics[37]);
        bwm.addShorthand(generics[56]);
        bwm.addShorthand(generics[18]);
        corr = new CorrespondingPropertyMaker(bwm);
        corr.setCorresponding(50, 36, 22, 26);
        FOPropertyMapping.addPropertyMaker("border-left-width", bwm);
        m4 = new ColorProperty.Maker(42);
        m4.useGeneric(this.genericColor);
        m4.setInherited(false);
        m4.setDefault("black");
        m4.addShorthand(generics[41]);
        m4.addShorthand(generics[32]);
        m4.addShorthand(generics[18]);
        corr = new CorrespondingPropertyMaker(m4);
        corr.setCorresponding(33, 47, 23, 19);
        FOPropertyMapping.addPropertyMaker("border-right-color", m4);
        m4 = new EnumProperty.Maker(43);
        m4.useGeneric(this.genericBorderStyle);
        m4.addShorthand(generics[41]);
        m4.addShorthand(generics[51]);
        m4.addShorthand(generics[18]);
        corr = new CorrespondingPropertyMaker(m4);
        corr.setCorresponding(35, 49, 25, 21);
        FOPropertyMapping.addPropertyMaker("border-right-style", m4);
        bwm = new BorderWidthPropertyMaker(44);
        bwm.useGeneric(this.genericBorderWidth);
        bwm.setBorderStyleId(43);
        bwm.addShorthand(generics[41]);
        bwm.addShorthand(generics[56]);
        bwm.addShorthand(generics[18]);
        corr = new CorrespondingPropertyMaker(bwm);
        corr.setCorresponding(36, 50, 26, 22);
        FOPropertyMapping.addPropertyMaker("border-right-width", bwm);
        m4 = new CondLengthProperty.Maker(172);
        m4.useGeneric(this.genericCondPadding);
        m4.getSubpropMaker(1024).setDefault("discard");
        corr = new CorrespondingPropertyMaker(m4);
        corr.setCorresponding(178, 178, 176, 175);
        corr.setRelative(true);
        FOPropertyMapping.addPropertyMaker("padding-before", m4);
        m4 = new CondLengthProperty.Maker(171);
        m4.useGeneric(this.genericCondPadding);
        m4.getSubpropMaker(1024).setDefault("discard");
        corr = new CorrespondingPropertyMaker(m4);
        corr.setCorresponding(173, 173, 175, 176);
        corr.setRelative(true);
        FOPropertyMapping.addPropertyMaker("padding-after", m4);
        m4 = new CondLengthProperty.Maker(177);
        m4.useGeneric(this.genericCondPadding);
        m4.getSubpropMaker(1024).setDefault("discard");
        corr = new CorrespondingPropertyMaker(m4);
        corr.setCorresponding(175, 176, 178, 178);
        corr.setRelative(true);
        FOPropertyMapping.addPropertyMaker("padding-start", m4);
        m4 = new CondLengthProperty.Maker(174);
        m4.useGeneric(this.genericCondPadding);
        m4.getSubpropMaker(1024).setDefault("discard");
        corr = new CorrespondingPropertyMaker(m4);
        corr.setCorresponding(176, 175, 173, 173);
        corr.setRelative(true);
        FOPropertyMapping.addPropertyMaker("padding-end", m4);
        m4 = new LengthProperty.Maker(178);
        m4.useGeneric(this.genericPadding);
        corr = new CorrespondingPropertyMaker(m4);
        corr.setCorresponding(172, 172, 177, 177);
        FOPropertyMapping.addPropertyMaker("padding-top", m4);
        m4 = new LengthProperty.Maker(173);
        m4.useGeneric(this.genericPadding);
        corr = new CorrespondingPropertyMaker(m4);
        corr.setCorresponding(171, 171, 174, 174);
        FOPropertyMapping.addPropertyMaker("padding-bottom", m4);
        m4 = new LengthProperty.Maker(175);
        m4.useGeneric(this.genericPadding);
        corr = new CorrespondingPropertyMaker(m4);
        corr.setCorresponding(177, 174, 171, 172);
        FOPropertyMapping.addPropertyMaker("padding-left", m4);
        m4 = new LengthProperty.Maker(176);
        m4.useGeneric(this.genericPadding);
        corr = new CorrespondingPropertyMaker(m4);
        corr.setCorresponding(174, 177, 172, 171);
        FOPropertyMapping.addPropertyMaker("padding-right", m4);
    }

    private void createFontProperties() {
        PropertyMaker m4 = new FontFamilyProperty.Maker(101);
        m4.setInherited(true);
        m4.setDefault("sans-serif,Symbol,ZapfDingbats");
        m4.addShorthand(generics[100]);
        FOPropertyMapping.addPropertyMaker("font-family", m4);
        m4 = new EnumProperty.Maker(102);
        m4.setInherited(true);
        m4.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        m4.addEnum("character-by-character", this.getEnumProperty(25, "CHARACTER_BY_CHARACTER"));
        m4.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("font-selection-strategy", m4);
        m4 = new FontSizePropertyMaker(103);
        m4.setInherited(true);
        m4.setDefault("12pt");
        m4.addKeyword("xx-small", "6.944pt");
        m4.addKeyword("x-small", "8.333pt");
        m4.addKeyword("small", "10pt");
        m4.addKeyword("medium", "12pt");
        m4.addKeyword("large", "14.4pt");
        m4.addKeyword("x-large", "17.28pt");
        m4.addKeyword("xx-large", "20.736pt");
        m4.addEnum("larger", this.getEnumProperty(71, "LARGER"));
        m4.addEnum("smaller", this.getEnumProperty(132, "SMALLER"));
        m4.setPercentBase(2);
        m4.addShorthand(generics[100]);
        FOPropertyMapping.addPropertyMaker("font-size", m4);
        m4 = new FontStretchPropertyMaker(105);
        m4.addEnum("normal", this.getEnumProperty(97, "NORMAL"));
        m4.addEnum("wider", this.getEnumProperty(160, "WIDER"));
        m4.addEnum("narrower", this.getEnumProperty(85, "NARROWER"));
        m4.addEnum("ultra-condensed", this.getEnumProperty(150, "ULTRA_CONDENSED"));
        m4.addEnum("extra-condensed", this.getEnumProperty(46, "EXTRA_CONDENSED"));
        m4.addEnum("condensed", this.getEnumProperty(29, "CONDENSED"));
        m4.addEnum("semi-condensed", this.getEnumProperty(127, "SEMI_CONDENSED"));
        m4.addEnum("semi-expanded", this.getEnumProperty(128, "SEMI_EXPANDED"));
        m4.addEnum("expanded", this.getEnumProperty(45, "EXPANDED"));
        m4.addEnum("extra-expanded", this.getEnumProperty(47, "EXTRA_EXPANDED"));
        m4.addEnum("ultra-expanded", this.getEnumProperty(151, "ULTRA_EXPANDED"));
        m4.setDefault("normal");
        FOPropertyMapping.addPropertyMaker("font-stretch", m4);
        m4 = new NumberProperty.Maker(104);
        m4.setInherited(true);
        m4.addEnum("none", this.getEnumProperty(95, "NONE"));
        m4.setDefault("none");
        FOPropertyMapping.addPropertyMaker("font-size-adjust", m4);
        m4 = new EnumProperty.Maker(106);
        m4.setInherited(true);
        m4.addEnum("normal", this.getEnumProperty(97, "NORMAL"));
        m4.addEnum("italic", this.getEnumProperty(162, "ITALIC"));
        m4.addEnum("oblique", this.getEnumProperty(163, "OBLIQUE"));
        m4.addEnum("backslant", this.getEnumProperty(164, "BACKSLANT"));
        m4.setDefault("normal");
        m4.addShorthand(generics[100]);
        FOPropertyMapping.addPropertyMaker("font-style", m4);
        m4 = new EnumProperty.Maker(107);
        m4.setInherited(true);
        m4.addEnum("normal", this.getEnumProperty(97, "NORMAL"));
        m4.addEnum("small-caps", this.getEnumProperty(131, "SMALL_CAPS"));
        m4.setDefault("normal");
        m4.addShorthand(generics[100]);
        FOPropertyMapping.addPropertyMaker("font-variant", m4);
        m4 = new FontWeightPropertyMaker(108);
        m4.setInherited(true);
        m4.addKeyword("normal", "400");
        m4.addKeyword("bold", "700");
        m4.addEnum("bolder", this.getEnumProperty(165, "BOLDER"));
        m4.addEnum("lighter", this.getEnumProperty(166, "LIGHTER"));
        m4.addEnum("100", this.getEnumProperty(167, "100"));
        m4.addEnum("200", this.getEnumProperty(168, "200"));
        m4.addEnum("300", this.getEnumProperty(169, "300"));
        m4.addEnum("400", this.getEnumProperty(170, "400"));
        m4.addEnum("500", this.getEnumProperty(171, "500"));
        m4.addEnum("600", this.getEnumProperty(172, "600"));
        m4.addEnum("700", this.getEnumProperty(173, "700"));
        m4.addEnum("800", this.getEnumProperty(174, "800"));
        m4.addEnum("900", this.getEnumProperty(175, "900"));
        m4.setDefault("400");
        m4.addShorthand(generics[100]);
        FOPropertyMapping.addPropertyMaker("font-weight", m4);
    }

    private void createHyphenationProperties() {
        PropertyMaker m4 = new StringProperty.Maker(81);
        m4.setInherited(true);
        m4.setDefault("none");
        m4.addShorthand(generics[268]);
        FOPropertyMapping.addPropertyMaker("country", m4);
        m4 = new StringProperty.Maker(134);
        m4.setInherited(true);
        m4.setDefault("none");
        m4.addShorthand(generics[268]);
        FOPropertyMapping.addPropertyMaker("language", m4);
        m4 = new StringProperty.Maker(218);
        m4.setInherited(true);
        m4.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("script", m4);
        m4 = new EnumProperty.Maker(116);
        m4.useGeneric(this.genericBoolean);
        m4.setInherited(true);
        m4.setDefault("false");
        FOPropertyMapping.addPropertyMaker("hyphenate", m4);
        m4 = new OptionalCharacterProperty.Maker(117);
        m4.setInherited(true);
        m4.setDefault("-");
        FOPropertyMapping.addPropertyMaker("hyphenation-character", m4);
        m4 = new NumberProperty.PositiveIntegerMaker(120);
        m4.setInherited(true);
        m4.setDefault("2");
        FOPropertyMapping.addPropertyMaker("hyphenation-push-character-count", m4);
        m4 = new NumberProperty.PositiveIntegerMaker(121);
        m4.setInherited(true);
        m4.setDefault("2");
        FOPropertyMapping.addPropertyMaker("hyphenation-remain-character-count", m4);
    }

    private void createMarginBlockProperties() {
        PropertyMaker m4 = new LengthProperty.Maker(151);
        m4.setInherited(false);
        m4.setDefault("0pt");
        m4.addShorthand(generics[147]);
        m4.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("margin-top", m4);
        m4 = new LengthProperty.Maker(148);
        m4.setInherited(false);
        m4.setDefault("0pt");
        m4.addShorthand(generics[147]);
        m4.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("margin-bottom", m4);
        m4 = new LengthProperty.Maker(149);
        m4.setInherited(false);
        m4.setDefault("0pt");
        m4.addShorthand(generics[147]);
        m4.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("margin-left", m4);
        m4 = new LengthProperty.Maker(150);
        m4.setInherited(false);
        m4.setDefault("0pt");
        m4.addShorthand(generics[147]);
        m4.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("margin-right", m4);
        m4 = new SpaceProperty.Maker(223);
        m4.useGeneric(this.genericSpace);
        SpacePropertyMaker corr = new SpacePropertyMaker(m4);
        corr.setCorresponding(151, 151, 150, 149);
        corr.setUseParent(false);
        corr.setRelative(true);
        FOPropertyMapping.addPropertyMaker("space-before", m4);
        m4 = new SpaceProperty.Maker(222);
        m4.useGeneric(this.genericSpace);
        corr = new SpacePropertyMaker(m4);
        corr.setCorresponding(148, 148, 149, 150);
        corr.setUseParent(false);
        corr.setRelative(true);
        FOPropertyMapping.addPropertyMaker("space-after", m4);
        m4 = new LengthProperty.Maker(233);
        m4.setInherited(true);
        m4.setDefault("0pt");
        m4.setPercentBase(4);
        IndentPropertyMaker sCorr = new IndentPropertyMaker(m4);
        sCorr.setCorresponding(149, 150, 151, 151);
        sCorr.setUseParent(false);
        sCorr.setRelative(true);
        sCorr.setPaddingCorresponding(new int[]{175, 176, 178, 178});
        sCorr.setBorderWidthCorresponding(new int[]{40, 44, 55, 55});
        FOPropertyMapping.addPropertyMaker("start-indent", m4);
        m4 = new LengthProperty.Maker(91);
        m4.setInherited(true);
        m4.setDefault("0pt");
        m4.setPercentBase(4);
        IndentPropertyMaker eCorr = new IndentPropertyMaker(m4);
        eCorr.setCorresponding(150, 149, 148, 148);
        eCorr.setUseParent(false);
        eCorr.setRelative(true);
        eCorr.setPaddingCorresponding(new int[]{176, 175, 173, 173});
        eCorr.setBorderWidthCorresponding(new int[]{44, 40, 30, 30});
        FOPropertyMapping.addPropertyMaker("end-indent", m4);
    }

    private void createMarginInlineProperties() {
        SpaceProperty.Maker m4 = new SpaceProperty.Maker(224);
        ((PropertyMaker)m4).useGeneric(this.genericSpace);
        FOPropertyMapping.addPropertyMaker("space-end", m4);
        m4 = new SpaceProperty.Maker(225);
        ((PropertyMaker)m4).useGeneric(this.genericSpace);
        FOPropertyMapping.addPropertyMaker("space-start", m4);
    }

    private void createRelativePosProperties() {
        EnumProperty.Maker m4 = new EnumProperty.Maker(203);
        m4.setInherited(false);
        m4.addEnum("static", this.getEnumProperty(136, "STATIC"));
        m4.addEnum("relative", this.getEnumProperty(110, "RELATIVE"));
        m4.setDefault("static");
        m4.addShorthand(generics[193]);
        FOPropertyMapping.addPropertyMaker("relative-position", m4);
    }

    private void createAreaAlignmentProperties() {
        PropertyMaker m4 = new LengthProperty.Maker(3);
        m4.setInherited(false);
        m4.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        m4.addEnum("baseline", this.getEnumProperty(12, "BASELINE"));
        m4.addEnum("before-edge", this.getEnumProperty(14, "BEFORE_EDGE"));
        m4.addEnum("text-before-edge", this.getEnumProperty(142, "TEXT_BEFORE_EDGE"));
        m4.addEnum("middle", this.getEnumProperty(84, "MIDDLE"));
        m4.addEnum("central", this.getEnumProperty(24, "CENTRAL"));
        m4.addEnum("after-edge", this.getEnumProperty(4, "AFTER_EDGE"));
        m4.addEnum("text-after-edge", this.getEnumProperty(141, "TEXT_AFTER_EDGE"));
        m4.addEnum("ideographic", this.getEnumProperty(59, "IDEOGRAPHIC"));
        m4.addEnum("alphabetic", this.getEnumProperty(6, "ALPHABETIC"));
        m4.addEnum("hanging", this.getEnumProperty(56, "HANGING"));
        m4.addEnum("mathematical", this.getEnumProperty(82, "MATHEMATICAL"));
        m4.setDefault("auto");
        m4.setPercentBase(12);
        m4.addShorthand(generics[256]);
        FOPropertyMapping.addPropertyMaker("alignment-adjust", m4);
        m4 = new EnumProperty.Maker(4);
        m4.setInherited(false);
        m4.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        m4.addEnum("baseline", this.getEnumProperty(12, "BASELINE"));
        m4.addEnum("before-edge", this.getEnumProperty(14, "BEFORE_EDGE"));
        m4.addEnum("text-before-edge", this.getEnumProperty(142, "TEXT_BEFORE_EDGE"));
        m4.addEnum("middle", this.getEnumProperty(84, "MIDDLE"));
        m4.addEnum("central", this.getEnumProperty(24, "CENTRAL"));
        m4.addEnum("after-edge", this.getEnumProperty(4, "AFTER_EDGE"));
        m4.addEnum("text-after-edge", this.getEnumProperty(141, "TEXT_AFTER_EDGE"));
        m4.addEnum("ideographic", this.getEnumProperty(59, "IDEOGRAPHIC"));
        m4.addEnum("alphabetic", this.getEnumProperty(6, "ALPHABETIC"));
        m4.addEnum("hanging", this.getEnumProperty(56, "HANGING"));
        m4.addEnum("mathematical", this.getEnumProperty(82, "MATHEMATICAL"));
        m4.setDefault("auto");
        m4.addShorthand(generics[256]);
        FOPropertyMapping.addPropertyMaker("alignment-baseline", m4);
        m4 = new LengthProperty.Maker(15);
        m4.setInherited(false);
        m4.addEnum("baseline", this.getEnumProperty(12, "BASELINE"));
        m4.addEnum("sub", this.getEnumProperty(137, "SUB"));
        m4.addEnum("super", this.getEnumProperty(138, "SUPER"));
        m4.setDefault("baseline");
        m4.addShorthand(generics[256]);
        m4.setPercentBase(0);
        FOPropertyMapping.addPropertyMaker("baseline-shift", m4);
        m4 = new EnumProperty.Maker(87);
        m4.setInherited(true);
        m4.addEnum("before", this.getEnumProperty(13, "BEFORE"));
        m4.addEnum("after", this.getEnumProperty(3, "AFTER"));
        m4.addEnum("center", this.getEnumProperty(23, "CENTER"));
        m4.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        m4.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("display-align", m4);
        m4 = new EnumProperty.Maker(88);
        m4.setInherited(false);
        m4.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        m4.addEnum("use-script", this.getEnumProperty(157, "USE_SCRIPT"));
        m4.addEnum("no-change", this.getEnumProperty(87, "NO_CHANGE"));
        m4.addEnum("reset-size", this.getEnumProperty(116, "RESET_SIZE"));
        m4.addEnum("ideographic", this.getEnumProperty(59, "IDEOGRAPHIC"));
        m4.addEnum("alphabetic", this.getEnumProperty(6, "ALPHABETIC"));
        m4.addEnum("hanging", this.getEnumProperty(56, "HANGING"));
        m4.addEnum("mathematical", this.getEnumProperty(82, "MATHEMATICAL"));
        m4.addEnum("central", this.getEnumProperty(24, "CENTRAL"));
        m4.addEnum("middle", this.getEnumProperty(84, "MIDDLE"));
        m4.addEnum("text-after-edge", this.getEnumProperty(141, "TEXT_AFTER_EDGE"));
        m4.addEnum("text-before-edge", this.getEnumProperty(142, "TEXT_BEFORE_EDGE"));
        m4.setDefault("auto");
        m4.addShorthand(generics[256]);
        FOPropertyMapping.addPropertyMaker("dominant-baseline", m4);
        m4 = new EnumProperty.Maker(202);
        m4.setInherited(true);
        m4.addEnum("before", this.getEnumProperty(13, "BEFORE"));
        m4.addEnum("baseline", this.getEnumProperty(12, "BASELINE"));
        m4.setDefault("before");
        FOPropertyMapping.addPropertyMaker("relative-align", m4);
    }

    private void createAreaDimensionProperties() {
        PropertyMaker m4 = new LengthRangeProperty.Maker(17);
        m4.setInherited(false);
        m4.setPercentBase(6);
        LengthProperty.Maker l = new LengthProperty.Maker(3072);
        l.setDefault("auto");
        l.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        l.setPercentBase(6);
        l.setByShorthand(true);
        m4.addSubpropMaker(l);
        l = new LengthProperty.Maker(3584);
        l.setDefault("auto");
        l.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        l.setPercentBase(6);
        l.setByShorthand(true);
        m4.addSubpropMaker(l);
        l = new LengthProperty.Maker(2560);
        l.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        l.setDefault("auto");
        l.setPercentBase(6);
        l.setByShorthand(true);
        m4.addSubpropMaker(l);
        DimensionPropertyMaker pdim = new DimensionPropertyMaker(m4);
        pdim.setCorresponding(115, 115, 264, 264);
        pdim.setExtraCorresponding(new int[][]{{162, 162, 163, 163}, {155, 155, 157, 157}});
        pdim.setRelative(true);
        m4.setCorresponding(pdim);
        FOPropertyMapping.addPropertyMaker("block-progression-dimension", m4);
        l = new LengthProperty.Maker(78);
        l.setInherited(false);
        l.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        l.addEnum("scale-to-fit", this.getEnumProperty(125, "SCALE_TO_FIT"));
        l.addEnum("scale-down-to-fit", this.getEnumProperty(185, "SCALE_DOWN_TO_FIT"));
        l.addEnum("scale-up-to-fit", this.getEnumProperty(186, "SCALE_UP_TO_FIT"));
        l.setDefault("auto");
        l.setPercentBase(8);
        FOPropertyMapping.addPropertyMaker("content-height", l);
        l = new LengthProperty.Maker(80);
        l.setInherited(false);
        l.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        l.addEnum("scale-to-fit", this.getEnumProperty(125, "SCALE_TO_FIT"));
        l.addEnum("scale-down-to-fit", this.getEnumProperty(185, "SCALE_DOWN_TO_FIT"));
        l.addEnum("scale-up-to-fit", this.getEnumProperty(186, "SCALE_UP_TO_FIT"));
        l.setDefault("auto");
        l.setPercentBase(7);
        FOPropertyMapping.addPropertyMaker("content-width", l);
        l = new LengthProperty.Maker(115);
        l.setInherited(false);
        l.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        l.setPercentBase(6);
        l.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("height", l);
        m4 = new LengthRangeProperty.Maker(127);
        m4.setInherited(false);
        m4.setPercentBase(5);
        l = new LengthProperty.Maker(3072);
        l.setDefault("auto");
        l.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        l.setPercentBase(5);
        l.setByShorthand(true);
        m4.addSubpropMaker(l);
        l = new LengthProperty.Maker(3584);
        l.setDefault("auto");
        l.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        l.setPercentBase(5);
        l.setByShorthand(true);
        m4.addSubpropMaker(l);
        l = new LengthProperty.Maker(2560);
        l.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        l.setDefault("auto");
        l.setPercentBase(5);
        l.setByShorthand(true);
        m4.addSubpropMaker(l);
        pdim = new DimensionPropertyMaker(m4);
        pdim.setRelative(true);
        pdim.setCorresponding(264, 264, 115, 115);
        pdim.setExtraCorresponding(new int[][]{{163, 163, 162, 162}, {157, 157, 155, 162}});
        m4.setCorresponding(pdim);
        FOPropertyMapping.addPropertyMaker("inline-progression-dimension", m4);
        m4 = new LengthProperty.Maker(155);
        m4.addEnum("NONE", this.getEnumProperty(95, "NONE"));
        m4.setInherited(false);
        m4.setDefault("0pt");
        m4.setPercentBase(6);
        FOPropertyMapping.addPropertyMaker("max-height", m4);
        m4 = new LengthProperty.Maker(157);
        m4.addEnum("NONE", this.getEnumProperty(95, "NONE"));
        m4.setInherited(false);
        m4.setDefault("none");
        m4.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("max-width", m4);
        m4 = new LengthProperty.Maker(162);
        m4.setInherited(false);
        m4.setDefault("0pt");
        m4.setPercentBase(6);
        FOPropertyMapping.addPropertyMaker("min-height", m4);
        m4 = new LengthProperty.Maker(163);
        m4.setInherited(false);
        m4.setDefault("");
        m4.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("min-width", m4);
        m4 = new EnumProperty.Maker(215);
        m4.setInherited(true);
        m4.addEnum("uniform", this.getEnumProperty(154, "UNIFORM"));
        m4.addEnum("non-uniform", this.getEnumProperty(94, "NON_UNIFORM"));
        m4.setDefault("uniform");
        FOPropertyMapping.addPropertyMaker("scaling", m4);
        m4 = new EnumProperty.Maker(216);
        m4.setInherited(false);
        m4.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        m4.addEnum("integer-pixels", this.getEnumProperty(69, "INTEGER_PIXELS"));
        m4.addEnum("resample-any-method", this.getEnumProperty(115, "RESAMPLE_ANY_METHOD"));
        m4.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("scaling-method", m4);
        l = new LengthProperty.Maker(264);
        l.setInherited(false);
        l.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        l.setPercentBase(5);
        l.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("width", l);
    }

    private Property calcWritingModeDependent(int pv, int wm) {
        if (pv == 73) {
            pv = wm == 79 ? 135 : (wm == 121 ? 39 : 135);
        } else if (pv == 120) {
            pv = wm == 79 ? 39 : (wm == 121 ? 135 : 39);
        }
        return this.makeWritingModeDependentEnum(pv);
    }

    private Property makeWritingModeDependentEnum(int pv) {
        if (pv == 135) {
            return this.getEnumProperty(135, "START");
        }
        if (pv == 39) {
            return this.getEnumProperty(39, "END");
        }
        return null;
    }

    private void createBlockAndLineProperties() {
        PropertyMaker m4 = new EnumProperty.Maker(118);
        m4.setInherited(true);
        m4.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        m4.addEnum("column", this.getEnumProperty(28, "COLUMN"));
        m4.addEnum("page", this.getEnumProperty(104, "PAGE"));
        m4.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("hyphenation-keep", m4);
        m4 = new NumberProperty.Maker(119);
        m4.setInherited(true);
        m4.addEnum("no-limit", this.getEnumProperty(89, "NO_LIMIT"));
        m4.setDefault("no-limit");
        FOPropertyMapping.addPropertyMaker("hyphenation-ladder-count", m4);
        m4 = new LengthProperty.Maker(135);
        m4.setInherited(true);
        m4.setDefault("0pt");
        m4.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("last-line-end-indent", m4);
        m4 = new LineHeightPropertyMaker(144);
        m4.useGeneric(this.genericSpace);
        m4.setInherited(true);
        m4.addKeyword("normal", "1.2");
        m4.setPercentBase(1);
        m4.setDefault("normal", true);
        m4.addShorthand(generics[100]);
        FOPropertyMapping.addPropertyMaker("line-height", m4);
        m4 = new EnumProperty.Maker(145);
        m4.setInherited(true);
        m4.addEnum("consider-shifts", this.getEnumProperty(30, "CONSIDER_SHIFTS"));
        m4.addEnum("disregard-shifts", this.getEnumProperty(33, "DISREGARD_SHIFTS"));
        m4.setDefault("consider-shifts");
        FOPropertyMapping.addPropertyMaker("line-height-shift-adjustment", m4);
        m4 = new EnumProperty.Maker(146);
        m4.setInherited(true);
        m4.addEnum("line-height", this.getEnumProperty(76, "LINE_HEIGHT"));
        m4.addEnum("font-height", this.getEnumProperty(52, "FONT_HEIGHT"));
        m4.addEnum("max-height", this.getEnumProperty(83, "MAX_HEIGHT"));
        m4.setDefault("max-height");
        FOPropertyMapping.addPropertyMaker("line-stacking-strategy", m4);
        m4 = new EnumProperty.Maker(143);
        m4.setInherited(true);
        m4.addEnum("ignore", this.getEnumProperty(60, "IGNORE"));
        m4.addEnum("preserve", this.getEnumProperty(108, "PRESERVE"));
        m4.addEnum("treat-as-space", this.getEnumProperty(147, "TREAT_AS_SPACE"));
        m4.addEnum("treat-as-zero-width-space", this.getEnumProperty(148, "TREAT_AS_ZERO_WIDTH_SPACE"));
        m4.setDefault("treat-as-space");
        m4.addShorthand(generics[260]);
        FOPropertyMapping.addPropertyMaker("linefeed-treatment", m4);
        m4 = new EnumProperty.Maker(262);
        m4.setInherited(true);
        m4.addEnum("ignore", this.getEnumProperty(60, "IGNORE"));
        m4.addEnum("preserve", this.getEnumProperty(108, "PRESERVE"));
        m4.addEnum("ignore-if-before-linefeed", this.getEnumProperty(62, "IGNORE_IF_BEFORE_LINEFEED"));
        m4.addEnum("ignore-if-after-linefeed", this.getEnumProperty(61, "IGNORE_IF_AFTER_LINEFEED"));
        m4.addEnum("ignore-if-surrounding-linefeed", this.getEnumProperty(63, "IGNORE_IF_SURROUNDING_LINEFEED"));
        m4.setDefault("ignore-if-surrounding-linefeed");
        m4.addShorthand(generics[260]);
        FOPropertyMapping.addPropertyMaker("white-space-treatment", m4);
        m4 = new EnumProperty.Maker(245){

            @Override
            public Property get(int subpropId, PropertyList propertyList, boolean bTryInherit, boolean bTryDefault) throws PropertyException {
                int pv;
                Property p = super.get(subpropId, propertyList, bTryInherit, bTryDefault);
                if (p != null && ((pv = p.getEnum()) == 73 || pv == 120)) {
                    p = FOPropertyMapping.this.calcWritingModeDependent(pv, propertyList.get(267).getEnum());
                }
                return p;
            }
        };
        m4.setInherited(true);
        m4.addEnum("center", this.getEnumProperty(23, "CENTER"));
        m4.addEnum("end", this.getEnumProperty(39, "END"));
        m4.addEnum("start", this.getEnumProperty(135, "START"));
        m4.addEnum("justify", this.getEnumProperty(70, "JUSTIFY"));
        m4.addEnum("left", this.getEnumProperty(73, "LEFT"));
        m4.addEnum("right", this.getEnumProperty(120, "RIGHT"));
        m4.addEnum("inside", this.getEnumProperty(135, "START"));
        m4.addEnum("outside", this.getEnumProperty(39, "END"));
        m4.setDefault("start");
        FOPropertyMapping.addPropertyMaker("text-align", m4);
        m4 = new EnumProperty.Maker(246){

            @Override
            public Property get(int subpropId, PropertyList propertyList, boolean bTryInherit, boolean bTryDefault) throws PropertyException {
                Property p = super.get(subpropId, propertyList, bTryInherit, bTryDefault);
                if (p != null && p.getEnum() == 110 && (p = propertyList.getNearestSpecified(246)).getEnum() == 110) {
                    return this.calcRelative(propertyList);
                }
                return p;
            }

            private Property calcRelative(PropertyList propertyList) throws PropertyException {
                Property corresponding = propertyList.get(245);
                if (corresponding == null) {
                    return null;
                }
                int correspondingValue = corresponding.getEnum();
                if (correspondingValue == 70) {
                    return FOPropertyMapping.this.getEnumProperty(135, "START");
                }
                if (correspondingValue == 39) {
                    return FOPropertyMapping.this.getEnumProperty(39, "END");
                }
                if (correspondingValue == 135) {
                    return FOPropertyMapping.this.getEnumProperty(135, "START");
                }
                if (correspondingValue == 23) {
                    return FOPropertyMapping.this.getEnumProperty(23, "CENTER");
                }
                if (correspondingValue == 73) {
                    return FOPropertyMapping.this.calcWritingModeDependent(73, propertyList.get(267).getEnum());
                }
                if (correspondingValue == 120) {
                    return FOPropertyMapping.this.calcWritingModeDependent(120, propertyList.get(267).getEnum());
                }
                return null;
            }
        };
        m4.setInherited(false);
        m4.addEnum("relative", this.getEnumProperty(110, "RELATIVE"));
        m4.addEnum("center", this.getEnumProperty(23, "CENTER"));
        m4.addEnum("end", this.getEnumProperty(39, "END"));
        m4.addEnum("right", this.getEnumProperty(39, "END"));
        m4.addEnum("start", this.getEnumProperty(135, "START"));
        m4.addEnum("left", this.getEnumProperty(135, "START"));
        m4.addEnum("justify", this.getEnumProperty(70, "JUSTIFY"));
        m4.addEnum("inside", this.getEnumProperty(135, "START"));
        m4.addEnum("outside", this.getEnumProperty(39, "END"));
        m4.setDefault("relative", true);
        FOPropertyMapping.addPropertyMaker("text-align-last", m4);
        m4 = new LengthProperty.Maker(250);
        m4.setInherited(true);
        m4.setDefault("0pt");
        m4.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("text-indent", m4);
        m4 = new EnumProperty.Maker(261);
        m4.useGeneric(this.genericBoolean);
        m4.setInherited(true);
        m4.setDefault("true");
        m4.addShorthand(generics[260]);
        FOPropertyMapping.addPropertyMaker("white-space-collapse", m4);
        m4 = new EnumProperty.Maker(266);
        m4.setInherited(true);
        m4.addEnum("wrap", this.getEnumProperty(161, "WRAP"));
        m4.addEnum("no-wrap", this.getEnumProperty(93, "NO_WRAP"));
        m4.setDefault("wrap");
        m4.addShorthand(generics[260]);
        FOPropertyMapping.addPropertyMaker("wrap-option", m4);
    }

    private void createCharacterProperties() {
        PropertyMaker m4 = new CharacterProperty.Maker(69);
        m4.setInherited(false);
        m4.setDefault("none");
        FOPropertyMapping.addPropertyMaker("character", m4);
        m4 = new SpacingPropertyMaker(141);
        m4.useGeneric(this.genericSpace);
        m4.setInherited(true);
        m4.getSubpropMaker(4096).setDefault("force");
        m4.getSubpropMaker(1024).setDefault("discard");
        m4.setDefault("normal");
        m4.addEnum("normal", this.getEnumProperty(97, "NORMAL"));
        FOPropertyMapping.addPropertyMaker("letter-spacing", m4);
        m4 = new EnumProperty.Maker(237);
        m4.setInherited(false);
        m4.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        m4.addEnum("suppress", this.getEnumProperty(139, "SUPPRESS"));
        m4.addEnum("retain", this.getEnumProperty(118, "RETAIN"));
        m4.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("suppress-at-line-break", m4);
        m4 = new TextDecorationMaker(248);
        m4.setInherited(false);
        m4.addEnum("none", this.getEnumProperty(95, "NONE"));
        m4.addEnum("underline", this.getEnumProperty(153, "UNDERLINE"));
        m4.addEnum("overline", this.getEnumProperty(103, "OVERLINE"));
        m4.addEnum("line-through", this.getEnumProperty(77, "LINE_THROUGH"));
        m4.addEnum("blink", this.getEnumProperty(17, "BLINK"));
        m4.addEnum("no-underline", this.getEnumProperty(92, "NO_UNDERLINE"));
        m4.addEnum("no-overline", this.getEnumProperty(91, "NO_OVERLINE"));
        m4.addEnum("no-line-through", this.getEnumProperty(90, "NO_LINE_THROUGH"));
        m4.addEnum("no-blink", this.getEnumProperty(86, "NO_BLINK"));
        m4.setDefault("none");
        FOPropertyMapping.addPropertyMaker("text-decoration", m4);
        m4 = new ToBeImplementedProperty.Maker(251);
        m4.setInherited(false);
        m4.setDefault("none");
        FOPropertyMapping.addPropertyMaker("text-shadow", m4);
        m4 = new EnumProperty.Maker(252);
        m4.setInherited(true);
        m4.addEnum("none", this.getEnumProperty(95, "NONE"));
        m4.addEnum("capitalize", this.getEnumProperty(22, "CAPITALIZE"));
        m4.addEnum("uppercase", this.getEnumProperty(155, "UPPERCASE"));
        m4.addEnum("lowercase", this.getEnumProperty(78, "LOWERCASE"));
        m4.setDefault("none");
        FOPropertyMapping.addPropertyMaker("text-transform", m4);
        m4 = new EnumProperty.Maker(254);
        m4.useGeneric(this.genericBoolean);
        m4.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        m4.setInherited(false);
        m4.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("treat-as-word-space", m4);
        m4 = new SpacingPropertyMaker(265);
        m4.useGeneric(this.genericSpace);
        m4.setInherited(true);
        m4.getSubpropMaker(4096).setDefault("force");
        m4.getSubpropMaker(1024).setDefault("discard");
        m4.setDefault("normal");
        m4.addEnum("normal", this.getEnumProperty(97, "NORMAL"));
        FOPropertyMapping.addPropertyMaker("word-spacing", m4);
    }

    private void createColorProperties() {
        PropertyMaker m4 = new ColorProperty.Maker(72);
        m4.useGeneric(this.genericColor);
        m4.setInherited(true);
        m4.setDefault("black");
        FOPropertyMapping.addPropertyMaker("color", m4);
        m4 = new StringProperty.Maker(73);
        m4.setInherited(false);
        m4.setDefault("");
        FOPropertyMapping.addPropertyMaker("color-profile-name", m4);
        m4 = new EnumProperty.Maker(204);
        m4.setInherited(false);
        m4.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        m4.addEnum("perceptual", this.getEnumProperty(107, "PERCEPTUAL"));
        m4.addEnum("relative-colorimetric", this.getEnumProperty(111, "RELATIVE_COLOMETRIC"));
        m4.addEnum("saturation", this.getEnumProperty(124, "SATURATION"));
        m4.addEnum("absolute-colorimetric", this.getEnumProperty(2, "ABSOLUTE_COLORMETRIC"));
        m4.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("rendering-intent", m4);
    }

    private void createFloatProperties() {
        EnumProperty.Maker m4 = new EnumProperty.Maker(70);
        m4.setInherited(false);
        m4.addEnum("start", this.getEnumProperty(135, "START"));
        m4.addEnum("end", this.getEnumProperty(39, "END"));
        m4.addEnum("left", this.getEnumProperty(135, "START"));
        m4.addEnum("right", this.getEnumProperty(39, "END"));
        m4.addEnum("both", this.getEnumProperty(19, "BOTH"));
        m4.addEnum("none", this.getEnumProperty(95, "NONE"));
        m4.setDefault("none");
        FOPropertyMapping.addPropertyMaker("clear", m4);
        m4 = new EnumProperty.Maker(95);
        m4.setInherited(false);
        m4.addEnum("before", this.getEnumProperty(13, "BEFORE"));
        m4.addEnum("start", this.getEnumProperty(135, "START"));
        m4.addEnum("end", this.getEnumProperty(39, "END"));
        m4.addEnum("left", this.getEnumProperty(135, "START"));
        m4.addEnum("right", this.getEnumProperty(39, "END"));
        m4.addEnum("none", this.getEnumProperty(95, "NONE"));
        m4.setDefault("none");
        FOPropertyMapping.addPropertyMaker("float", m4);
        m4 = new EnumProperty.Maker(130);
        m4.setInherited(false);
        m4.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        m4.addEnum("none", this.getEnumProperty(95, "NONE"));
        m4.addEnum("line", this.getEnumProperty(75, "LINE"));
        m4.addEnum("indent", this.getEnumProperty(65, "INDENT"));
        m4.addEnum("block", this.getEnumProperty(18, "BLOCK"));
        m4.setDefault("none");
        FOPropertyMapping.addPropertyMaker("intrusion-displace", m4);
    }

    private void createKeepsAndBreaksProperties() {
        PropertyMaker m4 = new EnumProperty.Maker(58);
        m4.useGeneric(this.genericBreak);
        m4.addShorthand(generics[179]);
        FOPropertyMapping.addPropertyMaker("break-after", m4);
        m4 = new EnumProperty.Maker(59);
        m4.useGeneric(this.genericBreak);
        m4.addShorthand(generics[180]);
        FOPropertyMapping.addPropertyMaker("break-before", m4);
        m4 = new KeepProperty.Maker(131);
        m4.useGeneric(this.genericKeep);
        m4.setInherited(true);
        m4.setDefault("auto");
        m4.addShorthand(generics[181]);
        FOPropertyMapping.addPropertyMaker("keep-together", m4);
        m4 = new KeepProperty.Maker(132);
        m4.useGeneric(this.genericKeep);
        m4.setInherited(false);
        m4.setDefault("auto");
        m4.addShorthand(generics[179]);
        FOPropertyMapping.addPropertyMaker("keep-with-next", m4);
        m4 = new KeepProperty.Maker(133);
        m4.useGeneric(this.genericKeep);
        m4.setInherited(false);
        m4.setDefault("auto");
        m4.addShorthand(generics[180]);
        FOPropertyMapping.addPropertyMaker("keep-with-previous", m4);
        m4 = new NumberProperty.Maker(168);
        m4.setInherited(true);
        m4.setDefault("2");
        FOPropertyMapping.addPropertyMaker("orphans", m4);
        m4 = new NumberProperty.Maker(263);
        m4.setInherited(true);
        m4.setDefault("2");
        FOPropertyMapping.addPropertyMaker("widows", m4);
        m4 = new LengthProperty.Maker(270);
        m4.setInherited(true);
        m4.setDefault("0pt");
        FOPropertyMapping.addPropertyMaker("fox:widow-content-limit", m4);
        m4 = new LengthProperty.Maker(271);
        m4.setInherited(true);
        m4.setDefault("0pt");
        FOPropertyMapping.addPropertyMaker("fox:orphan-content-limit", m4);
    }

    private void createLayoutProperties() {
        PropertyMaker m4 = new ToBeImplementedProperty.Maker(71);
        m4.setInherited(false);
        m4.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("clip", m4);
        m4 = new EnumProperty.Maker(169);
        m4.setInherited(false);
        m4.addEnum("visible", this.getEnumProperty(159, "VISIBLE"));
        m4.addEnum("hidden", this.getEnumProperty(57, "HIDDEN"));
        m4.addEnum("scroll", this.getEnumProperty(126, "SCROLL"));
        m4.addEnum("error-if-overflow", this.getEnumProperty(42, "ERROR_IF_OVERFLOW"));
        m4.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        m4.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("overflow", m4);
        m4 = new ReferenceOrientationMaker(197);
        m4.setInherited(true);
        m4.setDefault("0");
        FOPropertyMapping.addPropertyMaker("reference-orientation", m4);
        m4 = new EnumProperty.Maker(226);
        m4.setInherited(false);
        m4.addEnum("none", this.getEnumProperty(95, "NONE"));
        m4.addEnum("all", this.getEnumProperty(5, "ALL"));
        m4.setDefault("none");
        FOPropertyMapping.addPropertyMaker("span", m4);
        m4 = new EnumProperty.Maker(272);
        m4.useGeneric(this.genericBoolean);
        m4.setInherited(true);
        m4.setDefault("false");
        FOPropertyMapping.addPropertyMaker("fox:disable-column-balancing", m4);
    }

    private void createLeaderAndRuleProperties() {
        PropertyMaker m4 = new EnumProperty.Maker(136);
        m4.setInherited(true);
        m4.addEnum("none", this.getEnumProperty(95, "NONE"));
        m4.addEnum("reference-area", this.getEnumProperty(109, "REFERENCE_AREA"));
        m4.addEnum("page", this.getEnumProperty(104, "PAGE"));
        m4.setDefault("none");
        FOPropertyMapping.addPropertyMaker("leader-alignment", m4);
        m4 = new EnumProperty.Maker(138);
        m4.setInherited(true);
        m4.addEnum("space", this.getEnumProperty(134, "SPACE"));
        m4.addEnum("rule", this.getEnumProperty(123, "RULE"));
        m4.addEnum("dots", this.getEnumProperty(35, "DOTS"));
        m4.addEnum("use-content", this.getEnumProperty(158, "USECONTENT"));
        m4.setDefault("space");
        FOPropertyMapping.addPropertyMaker("leader-pattern", m4);
        m4 = new LengthProperty.Maker(139);
        m4.setInherited(true);
        m4.setDefault("use-font-metrics", true);
        m4.addKeyword("use-font-metrics", "0pt");
        m4.setPercentBase(3);
        FOPropertyMapping.addPropertyMaker("leader-pattern-width", m4);
        m4 = new LengthRangeProperty.Maker(137);
        m4.setInherited(true);
        m4.setPercentBase(3);
        LengthProperty.Maker sub = new LengthProperty.Maker(3072);
        sub.setDefault("0pt");
        sub.setPercentBase(5);
        sub.setByShorthand(true);
        m4.addSubpropMaker(sub);
        sub = new LengthProperty.Maker(3584);
        sub.setDefault("12.0pt");
        sub.setPercentBase(5);
        sub.setByShorthand(true);
        m4.addSubpropMaker(sub);
        sub = new LengthProperty.Maker(2560);
        sub.setDefault("100%", true);
        sub.setPercentBase(5);
        sub.setByShorthand(true);
        m4.addSubpropMaker(sub);
        FOPropertyMapping.addPropertyMaker("leader-length", m4);
        m4 = new EnumProperty.Maker(213);
        m4.setInherited(true);
        m4.addEnum("none", this.getEnumProperty(95, "NONE"));
        m4.addEnum("dotted", this.getEnumProperty(36, "DOTTED"));
        m4.addEnum("dashed", this.getEnumProperty(31, "DASHED"));
        m4.addEnum("solid", this.getEnumProperty(133, "SOLID"));
        m4.addEnum("double", this.getEnumProperty(37, "DOUBLE"));
        m4.addEnum("groove", this.getEnumProperty(55, "GROOVE"));
        m4.addEnum("ridge", this.getEnumProperty(119, "RIDGE"));
        m4.setDefault("solid");
        FOPropertyMapping.addPropertyMaker("rule-style", m4);
        m4 = new LengthProperty.Maker(214);
        m4.setInherited(true);
        m4.setDefault("1.0pt");
        FOPropertyMapping.addPropertyMaker("rule-thickness", m4);
    }

    private void createDynamicProperties() {
        PropertyMaker m4 = new ToBeImplementedProperty.Maker(2);
        m4.setInherited(false);
        m4.setDefault("");
        FOPropertyMapping.addPropertyMaker("active-state", m4);
        m4 = new ToBeImplementedProperty.Maker(5);
        m4.setInherited(true);
        m4.setDefault("false");
        FOPropertyMapping.addPropertyMaker("auto-restore", m4);
        m4 = new ToBeImplementedProperty.Maker(61);
        m4.setInherited(false);
        m4.setDefault("");
        FOPropertyMapping.addPropertyMaker("case-name", m4);
        m4 = new ToBeImplementedProperty.Maker(62);
        m4.setInherited(false);
        m4.setDefault("");
        FOPropertyMapping.addPropertyMaker("case-title", m4);
        m4 = new ToBeImplementedProperty.Maker(85);
        m4.setInherited(false);
        m4.setDefault("0pt");
        FOPropertyMapping.addPropertyMaker("destination-placement-offset", m4);
        m4 = new StringProperty.Maker(94);
        m4.setInherited(false);
        m4.setDefault("");
        FOPropertyMapping.addPropertyMaker("external-destination", m4);
        m4 = new ToBeImplementedProperty.Maker(123);
        m4.setInherited(false);
        m4.setDefault("false");
        FOPropertyMapping.addPropertyMaker("indicate-destination", m4);
        m4 = new StringProperty.Maker(128);
        m4.setInherited(false);
        m4.setDefault("");
        FOPropertyMapping.addPropertyMaker("internal-destination", m4);
        m4 = new EnumProperty.Maker(219);
        m4.setInherited(false);
        m4.addEnum("new", this.getEnumProperty(188, "NEW"));
        m4.addEnum("replace", this.getEnumProperty(187, "REPLACE"));
        m4.setDefault("replace");
        FOPropertyMapping.addPropertyMaker("show-destination", m4);
        m4 = new EnumProperty.Maker(234);
        m4.setInherited(false);
        m4.addEnum("show", this.getEnumProperty(130, "SHOW"));
        m4.addEnum("hide", this.getEnumProperty(58, "HIDE"));
        m4.setDefault("show");
        FOPropertyMapping.addPropertyMaker("starting-state", m4);
        m4 = new StringProperty.Maker(238);
        m4.setInherited(false);
        m4.setDefault("xsl-any");
        FOPropertyMapping.addPropertyMaker("switch-to", m4);
        m4 = new ToBeImplementedProperty.Maker(242);
        m4.setInherited(false);
        m4.setDefault("use-target-processing-context");
        FOPropertyMapping.addPropertyMaker("target-presentation-context", m4);
        m4 = new ToBeImplementedProperty.Maker(243);
        m4.setInherited(false);
        m4.setDefault("document-root");
        FOPropertyMapping.addPropertyMaker("target-processing-context", m4);
        m4 = new ToBeImplementedProperty.Maker(244);
        m4.setInherited(false);
        m4.setDefault("use-normal-stylesheet");
        FOPropertyMapping.addPropertyMaker("target-stylesheet", m4);
    }

    private void createMarkersProperties() {
        PropertyMaker m4 = new StringProperty.Maker(152);
        m4.setInherited(false);
        m4.setDefault("");
        FOPropertyMapping.addPropertyMaker("marker-class-name", m4);
        m4 = new StringProperty.Maker(207);
        m4.setInherited(false);
        m4.setDefault("");
        FOPropertyMapping.addPropertyMaker("retrieve-class-name", m4);
        m4 = new EnumProperty.Maker(208);
        m4.setInherited(false);
        m4.addEnum("first-starting-within-page", this.getEnumProperty(54, "FSWP"));
        m4.addEnum("first-including-carryover", this.getEnumProperty(49, "FIC"));
        m4.addEnum("last-starting-within-page", this.getEnumProperty(81, "LSWP"));
        m4.addEnum("last-ending-within-page", this.getEnumProperty(74, "LEWP"));
        m4.setDefault("first-starting-within-page");
        FOPropertyMapping.addPropertyMaker("retrieve-position", m4);
        m4 = new EnumProperty.Maker(205);
        m4.setInherited(false);
        m4.addEnum("page", this.getEnumProperty(104, "PAGE"));
        m4.addEnum("page-sequence", this.getEnumProperty(105, "PAGE_SEQUENCE"));
        m4.addEnum("document", this.getEnumProperty(34, "DOCUMENT"));
        m4.setDefault("page-sequence");
        FOPropertyMapping.addPropertyMaker("retrieve-boundary", m4);
        m4 = new EnumProperty.Maker(209);
        m4.setInherited(false);
        m4.addEnum("first-starting", this.getEnumProperty(189, "FIRST_STARTING"));
        m4.addEnum("first-including-carryover", this.getEnumProperty(204, "FIRST_INCLUDING_CARRYOVER"));
        m4.addEnum("last-starting", this.getEnumProperty(190, "LAST_STARTING"));
        m4.addEnum("last-ending", this.getEnumProperty(191, "LAST_ENDING"));
        m4.setDefault("first-starting");
        FOPropertyMapping.addPropertyMaker("retrieve-position-within-table", m4);
        m4 = new EnumProperty.Maker(206);
        m4.setInherited(false);
        m4.addEnum("table", this.getEnumProperty(192, "TABLE"));
        m4.addEnum("table-fragment", this.getEnumProperty(193, "TABLE_FRAGMENT"));
        m4.addEnum("page", this.getEnumProperty(104, "PAGE"));
        m4.setDefault("table");
        FOPropertyMapping.addPropertyMaker("retrieve-boundary-within-table", m4);
    }

    private void createNumberToStringProperties() {
        PropertyMaker m4 = new StringProperty.Maker(110);
        m4.setInherited(false);
        m4.setDefault("1");
        FOPropertyMapping.addPropertyMaker("format", m4);
        m4 = new CharacterProperty.Maker(113);
        m4.setInherited(false);
        m4.setDefault("none");
        FOPropertyMapping.addPropertyMaker("grouping-separator", m4);
        m4 = new NumberProperty.Maker(114);
        m4.setInherited(false);
        m4.setDefault("0");
        FOPropertyMapping.addPropertyMaker("grouping-size", m4);
        m4 = new EnumProperty.Maker(142);
        m4.setInherited(false);
        m4.addEnum("alphabetic", this.getEnumProperty(6, "ALPHABETIC"));
        m4.addEnum("traditional", this.getEnumProperty(146, "TRADITIONAL"));
        m4.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        m4.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("letter-value", m4);
        m4 = new StringProperty.Maker(288);
        m4.setInherited(false);
        m4.setDefault("");
        FOPropertyMapping.addPropertyMaker("fox:number-conversion-features", m4);
    }

    private void createPaginationAndLayoutProperties() {
        PropertyMaker m4 = new EnumProperty.Maker(16);
        m4.setInherited(false);
        m4.addEnum("blank", this.getEnumProperty(16, "BLANK"));
        m4.addEnum("not-blank", this.getEnumProperty(98, "NOT_BLANK"));
        m4.addEnum("any", this.getEnumProperty(8, "ANY"));
        m4.setDefault("any");
        FOPropertyMapping.addPropertyMaker("blank-or-not-blank", m4);
        m4 = new NumberProperty.PositiveIntegerMaker(74);
        m4.setInherited(false);
        m4.setDefault("1");
        FOPropertyMapping.addPropertyMaker("column-count", m4);
        LengthProperty.Maker l = new LengthProperty.Maker(75);
        l.setInherited(false);
        l.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        l.setDefault("0.25in");
        FOPropertyMapping.addPropertyMaker("column-gap", l);
        m4 = new LengthProperty.Maker(93);
        m4.setInherited(true);
        m4.setDefault("0pt");
        m4.setPercentBase(0);
        FOPropertyMapping.addPropertyMaker("extent", m4);
        m4 = new StringProperty.Maker(98);
        m4.setInherited(false);
        m4.setDefault("");
        FOPropertyMapping.addPropertyMaker("flow-name", m4);
        m4 = new EnumProperty.Maker(109);
        m4.setInherited(false);
        m4.addEnum("even", this.getEnumProperty(43, "EVEN"));
        m4.addEnum("odd", this.getEnumProperty(99, "ODD"));
        m4.addEnum("end-on-even", this.getEnumProperty(40, "END_ON_EVEN"));
        m4.addEnum("end-on-odd", this.getEnumProperty(41, "END_ON_ODD"));
        m4.addEnum("no-force", this.getEnumProperty(88, "NO_FORCE"));
        m4.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        m4.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("force-page-count", m4);
        m4 = new NumberProperty.PositiveIntegerMaker(126);
        m4.setInherited(false);
        m4.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        m4.addEnum("auto-odd", this.getEnumProperty(11, "AUTO_ODD"));
        m4.addEnum("auto-even", this.getEnumProperty(10, "AUTO_EVEN"));
        m4.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("initial-page-number", m4);
        m4 = new StringProperty.Maker(153);
        m4.setInherited(false);
        m4.setDefault("");
        FOPropertyMapping.addPropertyMaker("master-name", m4);
        m4 = new StringProperty.Maker(154);
        m4.setInherited(false);
        m4.setDefault("");
        FOPropertyMapping.addPropertyMaker("master-reference", m4);
        m4 = new NumberProperty.Maker(156);
        m4.setInherited(false);
        m4.addEnum("no-limit", this.getEnumProperty(89, "NO_LIMIT"));
        m4.setDefault("no-limit");
        FOPropertyMapping.addPropertyMaker("maximum-repeats", m4);
        m4 = new EnumProperty.Maker(161);
        m4.setInherited(false);
        m4.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        m4.addEnum("paginate", this.getEnumProperty(106, "PAGINATE"));
        m4.addEnum("bounded-in-one-dimension", this.getEnumProperty(21, "BOUNDED_IN_ONE_DIMENSION"));
        m4.addEnum("unbounded", this.getEnumProperty(152, "UNBOUNDED"));
        m4.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("media-usage", m4);
        m4 = new EnumProperty.Maker(167);
        m4.setInherited(false);
        m4.addEnum("odd", this.getEnumProperty(99, "ODD"));
        m4.addEnum("even", this.getEnumProperty(43, "EVEN"));
        m4.addEnum("any", this.getEnumProperty(8, "ANY"));
        m4.setDefault("any");
        FOPropertyMapping.addPropertyMaker("odd-or-even", m4);
        l = new PageDimensionMaker(183);
        l.setInherited(false);
        l.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        l.addEnum("indefinite", this.getEnumProperty(64, "INDEFINITE"));
        l.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("page-height", l);
        m4 = new EnumProperty.Maker(185);
        m4.setInherited(false);
        m4.addEnum("first", this.getEnumProperty(50, "FIRST"));
        m4.addEnum("last", this.getEnumProperty(72, "LAST"));
        m4.addEnum("rest", this.getEnumProperty(117, "REST"));
        m4.addEnum("any", this.getEnumProperty(8, "ANY"));
        m4.addEnum("only", this.getEnumProperty(184, "ONLY"));
        m4.setDefault("any");
        FOPropertyMapping.addPropertyMaker("page-position", m4);
        l = new PageDimensionMaker(186);
        l.setInherited(false);
        l.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        l.addEnum("indefinite", this.getEnumProperty(64, "INDEFINITE"));
        l.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("page-width", l);
        m4 = new EnumProperty.Maker(194);
        m4.useGeneric(this.genericBoolean);
        m4.setInherited(false);
        m4.setDefault("false");
        FOPropertyMapping.addPropertyMaker("precedence", m4);
        m4 = new StringProperty.Maker(199);
        m4.setInherited(false);
        m4.setDefault("");
        FOPropertyMapping.addPropertyMaker("region-name", m4);
    }

    private void createTableProperties() {
        PropertyMaker m4 = new TableBorderPrecedence(20);
        m4.setInherited(false);
        m4.addEnum("force", this.getEnumProperty(53, "FORCE"));
        FOPropertyMapping.addPropertyMaker("border-after-precedence", m4);
        m4 = new TableBorderPrecedence(24);
        m4.setInherited(false);
        m4.addEnum("force", this.getEnumProperty(53, "FORCE"));
        FOPropertyMapping.addPropertyMaker("border-before-precedence", m4);
        m4 = new EnumProperty.Maker(31);
        m4.setInherited(true);
        m4.setDefault("collapse");
        m4.addEnum("separate", this.getEnumProperty(129, "SEPARATE"));
        m4.addEnum("collapse-with-precedence", this.getEnumProperty(27, "COLLAPSE_WITH_PRECEDENCE"));
        m4.addEnum("collapse", this.getEnumProperty(26, "COLLAPSE"));
        FOPropertyMapping.addPropertyMaker("border-collapse", m4);
        m4 = new TableBorderPrecedence(34);
        m4.setInherited(false);
        m4.addEnum("force", this.getEnumProperty(53, "FORCE"));
        FOPropertyMapping.addPropertyMaker("border-end-precedence", m4);
        m4 = new LengthPairProperty.Maker(45);
        m4.setInherited(true);
        m4.addShorthand(generics[46]);
        LengthProperty.Maker sub = new LengthProperty.Maker(512);
        sub.setDefault("0pt");
        sub.setByShorthand(true);
        m4.addSubpropMaker(sub);
        sub = new LengthProperty.Maker(1536);
        sub.setDefault("0pt");
        sub.setByShorthand(true);
        m4.addSubpropMaker(sub);
        FOPropertyMapping.addPropertyMaker("border-separation", m4);
        m4 = new TableBorderPrecedence(48);
        m4.setInherited(false);
        m4.addEnum("force", this.getEnumProperty(53, "FORCE"));
        FOPropertyMapping.addPropertyMaker("border-start-precedence", m4);
        m4 = new EnumProperty.Maker(60);
        m4.setInherited(true);
        m4.addEnum("before", this.getEnumProperty(13, "BEFORE"));
        m4.addEnum("after", this.getEnumProperty(3, "AFTER"));
        m4.addEnum("start", this.getEnumProperty(135, "START"));
        m4.addEnum("end", this.getEnumProperty(39, "END"));
        m4.addEnum("top", this.getEnumProperty(145, "TOP"));
        m4.addEnum("bottom", this.getEnumProperty(20, "BOTTOM"));
        m4.addEnum("left", this.getEnumProperty(73, "LEFT"));
        m4.addEnum("right", this.getEnumProperty(120, "RIGHT"));
        m4.setDefault("before");
        FOPropertyMapping.addPropertyMaker("caption-side", m4);
        m4 = new TableFObj.ColumnNumberPropertyMaker(76);
        m4.setInherited(false);
        FOPropertyMapping.addPropertyMaker("column-number", m4);
        m4 = new LengthProperty.Maker(77);
        m4.setInherited(false);
        m4.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        m4.setDefault("auto");
        m4.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("column-width", m4);
        m4 = new EnumProperty.Maker(90);
        m4.setInherited(true);
        m4.addEnum("show", this.getEnumProperty(130, "SHOW"));
        m4.addEnum("hide", this.getEnumProperty(58, "HIDE"));
        m4.setDefault("show");
        FOPropertyMapping.addPropertyMaker("empty-cells", m4);
        m4 = new EnumProperty.Maker(92);
        m4.setInherited(false);
        m4.useGeneric(this.genericBoolean);
        m4.setDefault("false");
        FOPropertyMapping.addPropertyMaker("ends-row", m4);
        m4 = new NumberProperty.PositiveIntegerMaker(164);
        m4.setInherited(false);
        m4.setDefault("1");
        FOPropertyMapping.addPropertyMaker("number-columns-repeated", m4);
        m4 = new NumberProperty.PositiveIntegerMaker(165);
        m4.setInherited(false);
        m4.setDefault("1");
        FOPropertyMapping.addPropertyMaker("number-columns-spanned", m4);
        m4 = new NumberProperty.PositiveIntegerMaker(166);
        m4.setInherited(false);
        m4.setDefault("1");
        FOPropertyMapping.addPropertyMaker("number-rows-spanned", m4);
        m4 = new EnumProperty.Maker(235);
        m4.useGeneric(this.genericBoolean);
        m4.setInherited(false);
        m4.setDefault("false");
        FOPropertyMapping.addPropertyMaker("starts-row", m4);
        m4 = new EnumProperty.Maker(239);
        m4.setInherited(false);
        m4.setDefault("auto");
        m4.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        m4.addEnum("fixed", this.getEnumProperty(51, "FIXED"));
        FOPropertyMapping.addPropertyMaker("table-layout", m4);
        m4 = new EnumProperty.Maker(240);
        m4.useGeneric(this.genericBoolean);
        m4.setInherited(false);
        m4.setDefault("false");
        FOPropertyMapping.addPropertyMaker("table-omit-footer-at-break", m4);
        m4 = new EnumProperty.Maker(241);
        m4.useGeneric(this.genericBoolean);
        m4.setInherited(false);
        m4.setDefault("false");
        FOPropertyMapping.addPropertyMaker("table-omit-header-at-break", m4);
        m4 = new EnumProperty.Maker(289);
        m4.useGeneric(this.genericBoolean);
        m4.setDefault("false");
        FOPropertyMapping.addPropertyMaker("fox:header", m4);
    }

    private void createWritingModeProperties() {
        PropertyMaker m4 = new EnumProperty.Maker(86);
        m4.setInherited(true);
        m4.addEnum("ltr", this.getEnumProperty(80, "LTR"));
        m4.addEnum("rtl", this.getEnumProperty(122, "RTL"));
        m4.setDefault("ltr");
        FOPropertyMapping.addPropertyMaker("direction", m4);
        m4 = new ToBeImplementedProperty.Maker(111);
        m4.setInherited(true);
        m4.setDefault("0deg");
        FOPropertyMapping.addPropertyMaker("glyph-orientation-horizontal", m4);
        m4 = new ToBeImplementedProperty.Maker(112);
        m4.setInherited(true);
        m4.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("glyph-orientation-vertical", m4);
        m4 = new LengthProperty.Maker(247);
        m4.setInherited(false);
        m4.addEnum("use-font-metrics", this.getEnumProperty(156, "USE_FONT_METRICS"));
        m4.setDefault("use-font-metrics");
        m4.setPercentBase(1);
        FOPropertyMapping.addPropertyMaker("text-altitude", m4);
        m4 = new LengthProperty.Maker(249);
        m4.setInherited(false);
        m4.addEnum("use-font-metrics", this.getEnumProperty(156, "USE_FONT_METRICS"));
        m4.setDefault("use-font-metrics");
        m4.setPercentBase(1);
        FOPropertyMapping.addPropertyMaker("text-depth", m4);
        m4 = new EnumProperty.Maker(255);
        m4.setInherited(false);
        m4.addEnum("normal", this.getEnumProperty(97, "NORMAL"));
        m4.addEnum("embed", this.getEnumProperty(38, "EMBED"));
        m4.addEnum("bidi-override", this.getEnumProperty(15, "BIDI_OVERRIDE"));
        m4.setDefault("normal");
        FOPropertyMapping.addPropertyMaker("unicode-bidi", m4);
        m4 = new EnumProperty.Maker(267);
        m4.setInherited(true);
        m4.setDefault("lr-tb");
        m4.addEnum("lr-tb", this.getEnumProperty(79, "LR_TB"));
        m4.addEnum("rl-tb", this.getEnumProperty(121, "RL_TB"));
        m4.addEnum("tb-rl", this.getEnumProperty(140, "TB_RL"));
        m4.addEnum("tb-lr", this.getEnumProperty(203, "TB_LR"));
        m4.addKeyword("lr", "lr-tb");
        m4.addKeyword("rl", "rl-tb");
        m4.addKeyword("tb", "tb-rl");
        FOPropertyMapping.addPropertyMaker("writing-mode", m4);
    }

    private void createChangeBarProperties() {
        PropertyMaker m4 = new StringProperty.Maker(63);
        m4.setInherited(false);
        m4.setDefault("");
        FOPropertyMapping.addPropertyMaker("change-bar-class", m4);
        m4 = new ColorProperty.Maker(64);
        m4.setInherited(true);
        m4.setDefault("black");
        FOPropertyMapping.addPropertyMaker("change-bar-color", m4);
        m4 = new EnumProperty.Maker(66);
        m4.setInherited(true);
        m4.setDefault("start");
        m4.addEnum("start", this.getEnumProperty(135, "START"));
        m4.addEnum("end", this.getEnumProperty(39, "END"));
        m4.addEnum("left", this.getEnumProperty(73, "LEFT"));
        m4.addEnum("right", this.getEnumProperty(120, "RIGHT"));
        m4.addEnum("inside", this.getEnumProperty(68, "INSIDE"));
        m4.addEnum("outside", this.getEnumProperty(102, "OUTSIDE"));
        m4.addEnum("alternate", this.getEnumProperty(198, "ALTERNATE"));
        FOPropertyMapping.addPropertyMaker("change-bar-placement", m4);
        m4 = new EnumProperty.Maker(67);
        m4.useGeneric(this.genericBorderStyle);
        m4.setInherited(true);
        m4.setDefault("solid");
        FOPropertyMapping.addPropertyMaker("change-bar-style", m4);
        m4 = new LengthProperty.Maker(68);
        m4.setInherited(true);
        m4.setDefault("6pt");
        FOPropertyMapping.addPropertyMaker("change-bar-width", m4);
        m4 = new LengthProperty.Maker(65);
        m4.setInherited(true);
        m4.setDefault("6pt");
        FOPropertyMapping.addPropertyMaker("change-bar-offset", m4);
    }

    private void createMiscProperties() {
        PropertyMaker m4 = new StringProperty.Maker(79);
        m4.setInherited(false);
        m4.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("content-type", m4);
        m4 = new StringProperty.Maker(122);
        m4.setInherited(false);
        m4.setDefault("");
        FOPropertyMapping.addPropertyMaker("id", m4);
        m4 = new StringProperty.Maker(273);
        m4.setInherited(false);
        m4.setDefault("");
        FOPropertyMapping.addPropertyMaker("fox:alt-text", m4);
        m4 = new StringProperty.Maker(294);
        m4.setInherited(false);
        m4.setDefault("");
        FOPropertyMapping.addPropertyMaker("fox:abbreviation", m4);
        m4 = new EnumProperty.Maker(291);
        m4.setInherited(false);
        m4.addEnum("select-first-fitting", this.getEnumProperty(205, "SELECT_FIRST_FITTING"));
        m4.setDefault("select-first-fitting");
        FOPropertyMapping.addPropertyMaker("fox:auto-toggle", m4);
        m4 = new LengthProperty.Maker(292);
        m4.setInherited(false);
        m4.setDefault("0pt");
        FOPropertyMapping.addPropertyMaker("fox:background-image-width", m4);
        m4 = new LengthProperty.Maker(293);
        m4.setInherited(false);
        m4.setDefault("0pt");
        FOPropertyMapping.addPropertyMaker("fox:background-image-height", m4);
        m4 = new CondLengthProperty.Maker(275);
        m4.useGeneric(this.genericCondCornerRadius);
        m4.addShorthand(generics[284]);
        m4.addShorthand(generics[283]);
        m4.getSubpropMaker(1024).setDefault("discard");
        FOPropertyMapping.addPropertyMaker("fox:border-before-radius-start", m4);
        m4 = new CondLengthProperty.Maker(276);
        m4.useGeneric(this.genericCondCornerRadius);
        m4.addShorthand(generics[285]);
        m4.addShorthand(generics[283]);
        m4.getSubpropMaker(1024).setDefault("discard");
        FOPropertyMapping.addPropertyMaker("fox:border-before-radius-end", m4);
        m4 = new CondLengthProperty.Maker(277);
        m4.useGeneric(this.genericCondCornerRadius);
        m4.addShorthand(generics[286]);
        m4.addShorthand(generics[283]);
        m4.getSubpropMaker(1024).setDefault("discard");
        FOPropertyMapping.addPropertyMaker("fox:border-after-radius-start", m4);
        m4 = new CondLengthProperty.Maker(278);
        m4.useGeneric(this.genericCondCornerRadius);
        m4.addShorthand(generics[287]);
        m4.addShorthand(generics[283]);
        m4.getSubpropMaker(1024).setDefault("discard");
        FOPropertyMapping.addPropertyMaker("fox:border-after-radius-end", m4);
        m4 = new CondLengthProperty.Maker(279);
        m4.useGeneric(this.genericCondCornerRadius);
        m4.addShorthand(generics[284]);
        m4.addShorthand(generics[283]);
        m4.getSubpropMaker(1024).setDefault("discard");
        FOPropertyMapping.addPropertyMaker("fox:border-start-radius-before", m4);
        m4 = new CondLengthProperty.Maker(280);
        m4.useGeneric(this.genericCondCornerRadius);
        m4.addShorthand(generics[286]);
        m4.addShorthand(generics[283]);
        m4.getSubpropMaker(1024).setDefault("discard");
        FOPropertyMapping.addPropertyMaker("fox:border-start-radius-after", m4);
        m4 = new CondLengthProperty.Maker(281);
        m4.useGeneric(this.genericCondCornerRadius);
        m4.addShorthand(generics[285]);
        m4.addShorthand(generics[283]);
        m4.getSubpropMaker(1024).setDefault("discard");
        FOPropertyMapping.addPropertyMaker("fox:border-end-radius-before", m4);
        m4 = new CondLengthProperty.Maker(282);
        m4.useGeneric(this.genericCondCornerRadius);
        m4.addShorthand(generics[287]);
        m4.addShorthand(generics[283]);
        m4.getSubpropMaker(1024).setDefault("discard");
        FOPropertyMapping.addPropertyMaker("fox:border-end-radius-after", m4);
        m4 = new LengthProperty.Maker(196);
        m4.setInherited(true);
        m4.setDefault("6pt");
        m4.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("provisional-label-separation", m4);
        m4 = new LengthProperty.Maker(195);
        m4.setInherited(true);
        m4.setDefault("24pt");
        m4.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("provisional-distance-between-starts", m4);
        m4 = new StringProperty.Maker(198);
        m4.setInherited(false);
        m4.setDefault("");
        FOPropertyMapping.addPropertyMaker("ref-id", m4);
        m4 = new EnumProperty.Maker(217);
        m4.useGeneric(this.genericBoolean);
        m4.setInherited(true);
        m4.setDefault("true");
        FOPropertyMapping.addPropertyMaker("score-spaces", m4);
        m4 = new URIProperty.Maker(232);
        m4.setInherited(false);
        m4.setDefault("");
        FOPropertyMapping.addPropertyMaker("src", m4);
        m4 = new EnumProperty.Maker(257);
        m4.setInherited(false);
        m4.addEnum("visible", this.getEnumProperty(159, "VISIBLE"));
        m4.addEnum("hidden", this.getEnumProperty(57, "HIDDEN"));
        m4.addEnum("collapse", this.getEnumProperty(26, "COLLAPSE"));
        m4.setDefault("visible");
        FOPropertyMapping.addPropertyMaker("visibility", m4);
        m4 = new NumberProperty.Maker(269);
        m4.setInherited(false);
        m4.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        m4.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("z-index", m4);
        m4 = new StringProperty.Maker(290);
        m4.setInherited(false);
        m4.setDefault("");
        FOPropertyMapping.addPropertyMaker("fox:layer", m4);
    }

    private void createShorthandProperties() {
        PropertyMaker m4 = new ToBeImplementedProperty.Maker(7);
        m4.setInherited(false);
        m4.setDefault("none");
        FOPropertyMapping.addPropertyMaker("background", m4);
        m4 = new BackgroundPositionShorthand.Maker(11);
        m4.setInherited(false);
        m4.addKeyword("left", "0pt 50%");
        m4.addKeyword("left center", "0pt 50%");
        m4.addKeyword("center left", "0pt 50%");
        m4.addKeyword("right", "100% 50%");
        m4.addKeyword("right center", "100% 50%");
        m4.addKeyword("center right", "100% 50%");
        m4.addKeyword("center", "50% 50%");
        m4.addKeyword("center center", "50% 50%");
        m4.addKeyword("top", "50% 0pt");
        m4.addKeyword("top center", "50% 0pt");
        m4.addKeyword("center top", "50% 0pt");
        m4.addKeyword("bottom", "50% 100%");
        m4.addKeyword("bottom center", "50% 100%");
        m4.addKeyword("center bottom", "50% 100%");
        m4.addKeyword("top left", "0pt 0pt");
        m4.addKeyword("left top", "0pt 0pt");
        m4.addKeyword("top right", "100% 0pt");
        m4.addKeyword("right top", "100% 0pt");
        m4.addKeyword("bottom left", "0pt 100%");
        m4.addKeyword("left bottom", "0pt 100%");
        m4.addKeyword("bottom right", "100% 100%");
        m4.addKeyword("right bottom", "100% 100%");
        m4.setDefault("0pt 0pt");
        m4.setPercentBase(0);
        m4.setDatatypeParser(new BackgroundPositionShorthand.Parser());
        FOPropertyMapping.addPropertyMaker("background-position", m4);
        m4 = new ListProperty.Maker(18);
        m4.setInherited(false);
        m4.setDefault("");
        m4.setDatatypeParser(new GenericShorthandParser());
        FOPropertyMapping.addPropertyMaker("border", m4);
        m4 = new ListProperty.Maker(27);
        m4.setInherited(false);
        m4.setDefault("");
        m4.setDatatypeParser(new BorderShorthandParser(this));
        FOPropertyMapping.addPropertyMaker("border-bottom", m4);
        m4 = new ListProperty.Maker(32);
        m4.setInherited(false);
        m4.setDefault("");
        m4.setDatatypeParser(new BoxPropShorthandParser());
        FOPropertyMapping.addPropertyMaker("border-color", m4);
        m4 = new ListProperty.Maker(37);
        m4.setInherited(false);
        m4.setDefault("");
        m4.setDatatypeParser(new BorderShorthandParser(this));
        FOPropertyMapping.addPropertyMaker("border-left", m4);
        m4 = new ListProperty.Maker(41);
        m4.setInherited(false);
        m4.setDefault("");
        m4.setDatatypeParser(new BorderShorthandParser(this));
        FOPropertyMapping.addPropertyMaker("border-right", m4);
        m4 = new ListProperty.Maker(51);
        m4.setInherited(false);
        m4.setDefault("");
        m4.setDatatypeParser(new BoxPropShorthandParser());
        FOPropertyMapping.addPropertyMaker("border-style", m4);
        m4 = new ListProperty.Maker(46);
        m4.setInherited(true);
        m4.setDefault("0pt");
        m4.setDatatypeParser(new BorderSpacingShorthandParser());
        FOPropertyMapping.addPropertyMaker("border-spacing", m4);
        m4 = new ListProperty.Maker(52);
        m4.setInherited(false);
        m4.setDefault("");
        m4.setDatatypeParser(new BorderShorthandParser(this));
        FOPropertyMapping.addPropertyMaker("border-top", m4);
        m4 = new ListProperty.Maker(56);
        m4.setInherited(false);
        m4.setDefault("");
        m4.setDatatypeParser(new BoxPropShorthandParser());
        FOPropertyMapping.addPropertyMaker("border-width", m4);
        m4 = new ListProperty.Maker(283);
        m4.setInherited(false);
        m4.setDatatypeParser(new BoxCornerPropShorthandParser());
        m4.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("fox:border-radius", m4);
        m4 = new ListProperty.Maker(284);
        m4.setInherited(false);
        m4.setDatatypeParser(new BoxCornerPropShorthandParser());
        m4.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("fox:border-before-start-radius", m4);
        m4 = new ListProperty.Maker(285);
        m4.setInherited(false);
        m4.setDatatypeParser(new BoxCornerPropShorthandParser());
        m4.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("fox:border-before-end-radius", m4);
        m4 = new ListProperty.Maker(286);
        m4.setInherited(false);
        m4.setDatatypeParser(new BoxCornerPropShorthandParser());
        m4.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("fox:border-after-start-radius", m4);
        m4 = new ListProperty.Maker(287);
        m4.setInherited(false);
        m4.setDatatypeParser(new BoxCornerPropShorthandParser());
        m4.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("fox:border-after-end-radius", m4);
        m4 = new ToBeImplementedProperty.Maker(82);
        m4.setInherited(false);
        m4.setDefault("");
        FOPropertyMapping.addPropertyMaker("cue", m4);
        m4 = new FontShorthandProperty.Maker(100);
        m4.setInherited(true);
        m4.addEnum("caption", this.getEnumProperty(178, "CAPTION"));
        m4.addEnum("icon", this.getEnumProperty(179, "ICON"));
        m4.addEnum("message-box", this.getEnumProperty(181, "MESSAGE_BOX"));
        m4.addEnum("menu", this.getEnumProperty(180, "MENU"));
        m4.addEnum("small-caption", this.getEnumProperty(182, "SMALL_CAPTION"));
        m4.addEnum("status-bar", this.getEnumProperty(183, "STATUS_BAR"));
        m4.setDefault("");
        m4.setDatatypeParser(new FontShorthandParser());
        FOPropertyMapping.addPropertyMaker("font", m4);
        m4 = new ListProperty.Maker(147);
        m4.setInherited(false);
        m4.setDefault("");
        m4.setDatatypeParser(new BoxPropShorthandParser());
        m4.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("margin", m4);
        m4 = new ListProperty.Maker(170);
        m4.setInherited(false);
        m4.setDatatypeParser(new BoxPropShorthandParser());
        m4.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("padding", m4);
        m4 = new EnumProperty.Maker(179);
        m4.setInherited(false);
        m4.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        m4.addEnum("always", this.getEnumProperty(7, "ALWAYS"));
        m4.addEnum("avoid", this.getEnumProperty(176, "AVOID"));
        m4.addEnum("left", this.getEnumProperty(73, "LEFT"));
        m4.addEnum("right", this.getEnumProperty(120, "RIGHT"));
        m4.setDefault("auto");
        m4.setDatatypeParser(new PageBreakShorthandParser());
        FOPropertyMapping.addPropertyMaker("page-break-after", m4);
        m4 = new EnumProperty.Maker(180);
        m4.setInherited(false);
        m4.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        m4.addEnum("always", this.getEnumProperty(7, "ALWAYS"));
        m4.addEnum("avoid", this.getEnumProperty(176, "AVOID"));
        m4.addEnum("left", this.getEnumProperty(73, "LEFT"));
        m4.addEnum("right", this.getEnumProperty(120, "RIGHT"));
        m4.setDefault("auto");
        m4.setDatatypeParser(new PageBreakShorthandParser());
        FOPropertyMapping.addPropertyMaker("page-break-before", m4);
        m4 = new EnumProperty.Maker(181);
        m4.setInherited(true);
        m4.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        m4.addEnum("avoid", this.getEnumProperty(176, "AVOID"));
        m4.setDefault("auto");
        m4.setDatatypeParser(new PageBreakShorthandParser());
        FOPropertyMapping.addPropertyMaker("page-break-inside", m4);
        m4 = new ToBeImplementedProperty.Maker(187);
        m4.setInherited(false);
        m4.setDefault("");
        FOPropertyMapping.addPropertyMaker("pause", m4);
        m4 = new EnumProperty.Maker(193);
        m4.setInherited(false);
        m4.addEnum("static", this.getEnumProperty(136, "STATIC"));
        m4.addEnum("relative", this.getEnumProperty(110, "RELATIVE"));
        m4.addEnum("absolute", this.getEnumProperty(1, "ABSOLUTE"));
        m4.addEnum("fixed", this.getEnumProperty(51, "FIXED"));
        m4.setDefault("static");
        m4.setDatatypeParser(new PositionShorthandParser());
        FOPropertyMapping.addPropertyMaker("position", m4);
        m4 = new ToBeImplementedProperty.Maker(220);
        m4.setInherited(false);
        m4.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("size", m4);
        m4 = new LengthProperty.Maker(256);
        m4.setInherited(false);
        m4.addEnum("baseline", this.getEnumProperty(12, "BASELINE"));
        m4.addEnum("middle", this.getEnumProperty(84, "MIDDLE"));
        m4.addEnum("sub", this.getEnumProperty(137, "SUB"));
        m4.addEnum("super", this.getEnumProperty(138, "SUPER"));
        m4.addEnum("text-top", this.getEnumProperty(144, "TEXT_TOP"));
        m4.addEnum("text-bottom", this.getEnumProperty(143, "TEXT_BOTTOM"));
        m4.addEnum("top", this.getEnumProperty(145, "TOP"));
        m4.addEnum("bottom", this.getEnumProperty(20, "BOTTOM"));
        m4.setDatatypeParser(new VerticalAlignShorthandParser());
        m4.setDefault("baseline");
        m4.setPercentBase(12);
        FOPropertyMapping.addPropertyMaker("vertical-align", m4);
        m4 = new EnumProperty.Maker(260);
        m4.setInherited(true);
        m4.addEnum("normal", this.getEnumProperty(97, "NORMAL"));
        m4.addEnum("pre", this.getEnumProperty(177, "PRE"));
        m4.addEnum("nowrap", this.getEnumProperty(93, "NO_WRAP"));
        m4.setDefault("normal");
        m4.setDatatypeParser(new WhiteSpaceShorthandParser());
        FOPropertyMapping.addPropertyMaker("white-space", m4);
        m4 = new StringProperty.Maker(268);
        m4.setInherited(true);
        m4.setDefault("");
        m4.setDatatypeParser(new XMLLangShorthandParser());
        FOPropertyMapping.addPropertyMaker("xml:lang", m4);
        m4 = new URIProperty.Maker(274);
        m4.setInherited(true);
        m4.setDefault("");
        FOPropertyMapping.addPropertyMaker("xml:base", m4);
    }

    static {
        FOPropertyMapping gp = new FOPropertyMapping();
        gp.createShorthandProperties();
        gp.createGenerics();
        gp.createAccessibilityProperties();
        gp.createAbsolutePositionProperties();
        gp.createAuralProperties();
        gp.createBorderPaddingBackgroundProperties();
        gp.createFontProperties();
        gp.createHyphenationProperties();
        gp.createMarginBlockProperties();
        gp.createMarginInlineProperties();
        gp.createRelativePosProperties();
        gp.createAreaAlignmentProperties();
        gp.createAreaDimensionProperties();
        gp.createBlockAndLineProperties();
        gp.createCharacterProperties();
        gp.createColorProperties();
        gp.createFloatProperties();
        gp.createKeepsAndBreaksProperties();
        gp.createLayoutProperties();
        gp.createLeaderAndRuleProperties();
        gp.createDynamicProperties();
        gp.createMarkersProperties();
        gp.createNumberToStringProperties();
        gp.createPaginationAndLayoutProperties();
        gp.createTableProperties();
        gp.createWritingModeProperties();
        gp.createMiscProperties();
        gp.createChangeBarProperties();
        FOPropertyMapping.addSubpropMakerName("length", 2048);
        FOPropertyMapping.addSubpropMakerName("conditionality", 1024);
        FOPropertyMapping.addSubpropMakerName("block-progression-direction", 512);
        FOPropertyMapping.addSubpropMakerName("inline-progression-direction", 1536);
        FOPropertyMapping.addSubpropMakerName("within-line", 5120);
        FOPropertyMapping.addSubpropMakerName("within-column", 4608);
        FOPropertyMapping.addSubpropMakerName("within-page", 5632);
        FOPropertyMapping.addSubpropMakerName("minimum", 3072);
        FOPropertyMapping.addSubpropMakerName("maximum", 2560);
        FOPropertyMapping.addSubpropMakerName("optimum", 3584);
        FOPropertyMapping.addSubpropMakerName("precedence", 4096);
    }
}

