/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.complexscripts.util;

import org.apache.fop.util.CharUtilities;

public final class UTF32 {
    private UTF32() {
    }

    public static Integer[] toUTF32(String s2, int substitution, boolean errorOnSubstitution) throws IllegalArgumentException {
        int n = s2.length();
        if (n == 0) {
            return new Integer[0];
        }
        Integer[] sa = new Integer[n];
        int k = 0;
        for (int i = 0; i < n; ++i) {
            int c = s2.charAt(i);
            if (c >= 55296 && c < 57344) {
                char s22;
                int s1 = c;
                char c2 = s22 = i + 1 < n ? s2.charAt(i + 1) : (char)'\u0000';
                if (s1 < 56320) {
                    if (s22 >= '\udc00' && s22 < '\ue000') {
                        c = (s1 - 55296 << 10) + (s22 - 56320) + 65536;
                        ++i;
                    } else {
                        if (errorOnSubstitution) {
                            throw new IllegalArgumentException("isolated high (leading) surrogate");
                        }
                        c = substitution;
                    }
                } else {
                    if (errorOnSubstitution) {
                        throw new IllegalArgumentException("isolated low (trailing) surrogate");
                    }
                    c = substitution;
                }
            }
            sa[k++] = c;
        }
        if (k == n) {
            return sa;
        }
        Integer[] na = new Integer[k];
        System.arraycopy(sa, 0, na, 0, k);
        return na;
    }

    public static String fromUTF32(Integer[] sa) throws IllegalArgumentException {
        StringBuffer sb = new StringBuffer();
        Integer[] integerArray = sa;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int s2 = integerArray[i];
            if (s2 < 65535) {
                if (s2 < 55296 || s2 > 57343) {
                    sb.append((char)s2);
                    continue;
                }
                String ncr = CharUtilities.charToNCRef(s2);
                throw new IllegalArgumentException("illegal scalar value 0x" + ncr.substring(2, ncr.length() - 1) + "; cannot be UTF-16 surrogate");
            }
            if (s2 < 0x110000) {
                int s1 = (s2 - 65536 >> 10 & 0x3FF) + 55296;
                int s22 = (s2 - 65536 >> 0 & 0x3FF) + 56320;
                sb.append((char)s1);
                sb.append((char)s22);
                continue;
            }
            String ncr = CharUtilities.charToNCRef(s2);
            throw new IllegalArgumentException("illegal scalar value 0x" + ncr.substring(2, ncr.length() - 1) + "; out of range for UTF-16");
        }
        return sb.toString();
    }
}

