/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.modca;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import org.apache.fop.afp.Factory;
import org.apache.fop.afp.ioca.ImageCellPosition;
import org.apache.fop.afp.ioca.ImageInputDescriptor;
import org.apache.fop.afp.ioca.ImageOutputControl;
import org.apache.fop.afp.ioca.ImageRasterData;
import org.apache.fop.afp.ioca.ImageRasterPattern;
import org.apache.fop.afp.modca.AbstractAFPObject;
import org.apache.fop.afp.modca.AbstractResourceGroupContainer;
import org.apache.fop.afp.modca.IMImageObject;
import org.apache.fop.afp.modca.IncludePageOverlay;

public class PageObject
extends AbstractResourceGroupContainer {
    public PageObject(Factory factory, String name, int width, int height, int rotation, int widthRes, int heightRes) {
        super(factory, name, width, height, rotation, widthRes, heightRes);
    }

    public void createIncludePageOverlay(String name, int x, int y, int orientation) {
        this.getActiveEnvironmentGroup().createOverlay(name);
        IncludePageOverlay ipo = new IncludePageOverlay(name, x, y, orientation);
        this.addObject(ipo);
    }

    public void createShading(int x, int y, int w, int h2, int red, int green, int blue) {
        int xCoord = 0;
        int yCoord = 0;
        int areaWidth = 0;
        int areaHeight = 0;
        switch (this.rotation) {
            case 90: {
                xCoord = areaWidth - y - h2;
                yCoord = x;
                areaWidth = h2;
                areaHeight = w;
                break;
            }
            case 180: {
                xCoord = areaWidth - x - w;
                yCoord = areaHeight - y - h2;
                areaWidth = w;
                areaHeight = h2;
                break;
            }
            case 270: {
                xCoord = y;
                yCoord = areaHeight - x - w;
                areaWidth = h2;
                areaHeight = w;
                break;
            }
            default: {
                xCoord = x;
                yCoord = y;
                areaWidth = w;
                areaHeight = h2;
            }
        }
        float shade = (float)((double)red * 0.3 + (double)green * 0.59 + (double)blue * 0.11);
        int grayscale = Math.round(shade / 255.0f * 16.0f);
        IMImageObject imImageObject = this.factory.createIMImageObject();
        ImageOutputControl imageOutputControl = new ImageOutputControl(0, 0);
        ImageInputDescriptor imageInputDescriptor = new ImageInputDescriptor();
        ImageCellPosition imageCellPosition = new ImageCellPosition(xCoord, yCoord);
        imageCellPosition.setXFillSize(areaWidth);
        imageCellPosition.setYFillSize(areaHeight);
        imageCellPosition.setXSize(64);
        imageCellPosition.setYSize(8);
        byte[] rasterData = ImageRasterPattern.getRasterData(grayscale);
        ImageRasterData imageRasterData = this.factory.createImageRasterData(rasterData);
        imImageObject.setImageOutputControl(imageOutputControl);
        imImageObject.setImageInputDescriptor(imageInputDescriptor);
        imImageObject.setImageCellPosition(imageCellPosition);
        imImageObject.setImageRasterData(imageRasterData);
        this.addObject(imImageObject);
    }

    @Override
    protected void writeStart(OutputStream os) throws IOException {
        byte[] data = new byte[17];
        this.copySF(data, (byte)-88, (byte)-81);
        os.write(data);
    }

    @Override
    protected void writeContent(OutputStream os) throws IOException {
        this.writeTriplets(os);
        this.writeObjects((Collection)this.invokeMediumMaps, os);
        this.getActiveEnvironmentGroup().writeToStream(os);
        this.writeObjects((Collection)this.objects, os);
    }

    @Override
    protected void writeEnd(OutputStream os) throws IOException {
        byte[] data = new byte[17];
        this.copySF(data, (byte)-87, (byte)-81);
        os.write(data);
    }

    @Override
    public void addObject(Object obj) {
        this.endPresentationObject();
        super.addObject(obj);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    protected boolean canWrite(AbstractAFPObject ao) {
        return true;
    }
}

