/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.ioca;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.afp.ioca.BandImage;
import org.apache.fop.afp.ioca.IDEStructureParameter;
import org.apache.fop.afp.ioca.TilePosition;
import org.apache.fop.afp.ioca.TileSize;
import org.apache.fop.afp.ioca.TransparencyMask;
import org.apache.fop.afp.modca.AbstractStructuredObject;
import org.apache.fop.afp.util.BinaryUtils;

public class Tile
extends AbstractStructuredObject {
    private static final int MAX_DATA_LEN = 8191;
    private TilePosition tilePosition;
    private TileSize tileSize;
    private BandImage bandImage;
    private TransparencyMask transparencyMask;
    private byte[] data;
    private IDEStructureParameter ideStructureParameter;
    private byte encoding = (byte)3;
    private byte ideSize = 1;

    @Override
    public void writeContent(OutputStream os) throws IOException {
        this.tilePosition.writeToStream(os);
        this.tileSize.writeToStream(os);
        os.write(this.getImageEncodingParameter());
        os.write(this.getImageIDESizeParameter());
        if (this.bandImage != null) {
            this.bandImage.writeToStream(os);
        }
        if (this.ideStructureParameter != null) {
            this.ideStructureParameter.writeToStream(os);
        }
        if (this.transparencyMask != null) {
            this.transparencyMask.writeToStream(os);
        }
        if (this.data != null) {
            this.writeData(os);
        }
    }

    private void writeData(OutputStream os) throws IOException {
        byte[] dataHeader = new byte[]{-2, -100, 0, 0, 0, 0, 0};
        int lengthOffset = 2;
        if (this.ideSize == 24) {
            byte[] red = new byte[this.data.length / 3];
            byte[] green = new byte[this.data.length / 3];
            byte[] blue = new byte[this.data.length / 3];
            for (int j = 0; j < this.data.length / 3; ++j) {
                red[j] = this.data[3 * j];
                green[j] = this.data[3 * j + 1];
                blue[j] = this.data[3 * j + 2];
            }
            dataHeader[4] = 1;
            Tile.writeChunksToStream(red, dataHeader, 2, 8191, os);
            dataHeader[4] = 2;
            Tile.writeChunksToStream(green, dataHeader, 2, 8191, os);
            dataHeader[4] = 3;
            Tile.writeChunksToStream(blue, dataHeader, 2, 8191, os);
        } else {
            byte[] c = new byte[this.data.length / 4];
            byte[] m4 = new byte[this.data.length / 4];
            byte[] y = new byte[this.data.length / 4];
            byte[] k = new byte[this.data.length / 4];
            for (int j = 0; j < this.data.length / 4; ++j) {
                c[j] = this.data[4 * j];
                m4[j] = this.data[4 * j + 1];
                y[j] = this.data[4 * j + 2];
                k[j] = this.data[4 * j + 3];
            }
            dataHeader[4] = 1;
            Tile.writeChunksToStream(c, dataHeader, 2, 8191, os);
            dataHeader[4] = 2;
            Tile.writeChunksToStream(m4, dataHeader, 2, 8191, os);
            dataHeader[4] = 3;
            Tile.writeChunksToStream(y, dataHeader, 2, 8191, os);
            dataHeader[4] = 4;
            Tile.writeChunksToStream(k, dataHeader, 2, 8191, os);
        }
    }

    @Override
    protected void writeStart(OutputStream os) throws IOException {
        byte[] startData = new byte[]{-116, 0};
        os.write(startData);
    }

    @Override
    protected void writeEnd(OutputStream os) throws IOException {
        byte[] endData = new byte[]{-115, 0};
        os.write(endData);
    }

    public void setPosition(TilePosition tilePosition) {
        this.tilePosition = tilePosition;
    }

    public void setSize(TileSize tileSize) {
        this.tileSize = tileSize;
    }

    public void setImageData(byte[] imageData) {
        this.data = (byte[])imageData.clone();
    }

    protected static void writeChunksToStream(byte[] data, byte[] dataHeader, int lengthOffset, int maxChunkLength, OutputStream os) throws IOException {
        int dataLength = data.length;
        int numFullChunks = dataLength / (maxChunkLength -= 3);
        int lastChunkLength = dataLength % maxChunkLength;
        byte[] len = new byte[]{31, -1};
        int off = 0;
        if (numFullChunks > 0) {
            dataHeader[lengthOffset] = len[0];
            dataHeader[lengthOffset + 1] = len[1];
            int i = 0;
            while (i < numFullChunks) {
                os.write(dataHeader);
                os.write(data, off, maxChunkLength);
                ++i;
                off += maxChunkLength;
            }
        }
        if (lastChunkLength > 0) {
            len = BinaryUtils.convert(3 + lastChunkLength, 2);
            dataHeader[lengthOffset] = len[0];
            dataHeader[lengthOffset + 1] = len[1];
            os.write(dataHeader);
            os.write(data, off, lastChunkLength);
        }
    }

    public void setImageEncodingParameter(byte encoding) {
        this.encoding = encoding;
    }

    public void setImageIDESizeParameter(byte ideSize) {
        this.ideSize = ideSize;
    }

    public void setIDEStructureParameter(IDEStructureParameter ideStructureParameter) {
        this.ideStructureParameter = ideStructureParameter;
    }

    private byte[] getImageEncodingParameter() {
        byte[] encodingData = new byte[]{-107, 2, this.encoding, (byte)(this.encoding == -125 ? 254 : 1)};
        return encodingData;
    }

    private byte[] getImageIDESizeParameter() {
        if (this.ideSize != 1) {
            byte[] ideSizeData = new byte[]{-106, 1, this.ideSize};
            return ideSizeData;
        }
        return new byte[0];
    }

    public void setBandImage(BandImage bandImage) {
        this.bandImage = bandImage;
    }

    public void setTransparencyMask(TransparencyMask transparencyMask) {
        this.transparencyMask = transparencyMask;
    }
}

