/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.fonts;

import java.awt.Rectangle;
import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.fop.afp.fonts.CharacterSet;
import org.apache.fop.fonts.FontType;
import org.apache.fop.fonts.Typeface;

public abstract class AFPFont
extends Typeface {
    private static final double STRIKEOUT_POSITION_FACTOR = 0.45;
    protected final String name;
    private final boolean embeddable;

    public AFPFont(String name, boolean embeddable) {
        this.name = name;
        this.embeddable = embeddable;
    }

    @Override
    public URI getFontURI() {
        return null;
    }

    @Override
    public String getFontName() {
        return this.name;
    }

    @Override
    public String getEmbedFontName() {
        return this.name;
    }

    @Override
    public String getFullName() {
        return this.getFontName();
    }

    @Override
    public Set<String> getFamilyNames() {
        HashSet<String> s2 = new HashSet<String>();
        s2.add(this.name);
        return s2;
    }

    @Override
    public FontType getFontType() {
        return FontType.OTHER;
    }

    @Override
    public boolean hasKerningInfo() {
        return false;
    }

    @Override
    public Map<Integer, Map<Integer, Integer>> getKerningInfo() {
        return null;
    }

    public abstract CharacterSet getCharacterSet(int var1);

    public boolean isEmbeddable() {
        return this.embeddable;
    }

    protected static final char toUnicodeCodepoint(int character) {
        return (char)character;
    }

    @Override
    public int getUnderlineThickness(int size) {
        return this.getBoundingBox((int)45, (int)size).height;
    }

    @Override
    public int getStrikeoutPosition(int size) {
        return (int)(0.45 * (double)this.getCapHeight(size));
    }

    @Override
    public int getStrikeoutThickness(int size) {
        return this.getBoundingBox((int)45, (int)size).height;
    }

    @Override
    public abstract Rectangle getBoundingBox(int var1, int var2);

    @Override
    public int[] getWidths() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return "name=" + this.name;
    }
}

