/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.jws;

import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.loader.SchemaLoader;
import org.json.JSONObject;
import org.json.JSONTokener;

public abstract class AbstractJWSUtils {
    private Schema jwsSchema;
    private Schema jwsProtectedHeaderSchema;
    private Schema jwsUnprotectedHeaderSchema;

    protected AbstractJWSUtils() {
    }

    public Schema getJWSSchema() {
        if (this.jwsSchema == null) {
            this.jwsSchema = this.loadSchema(this.getJWSSchemaJSON(), this.getJWSSchemaDefinitions());
        }
        return this.jwsSchema;
    }

    public Schema getJWSProtectedHeaderSchema() {
        if (this.jwsProtectedHeaderSchema == null) {
            this.jwsProtectedHeaderSchema = this.loadSchema(this.getJWSProtectedHeaderSchemaJSON(), this.getJWSProtectedHeaderSchemaDefinitions());
        }
        return this.jwsProtectedHeaderSchema;
    }

    public Schema getJWSUnprotectedHeaderSchema() {
        if (this.jwsUnprotectedHeaderSchema == null) {
            this.jwsUnprotectedHeaderSchema = this.loadSchema(this.getJWSUnprotectedHeaderSchemaJSON(), this.getJWSUnprotectedHeaderSchemaDefinitions());
        }
        return this.jwsUnprotectedHeaderSchema;
    }

    public abstract JSONObject getJWSSchemaJSON();

    public abstract Map<URI, JSONObject> getJWSSchemaDefinitions();

    public abstract JSONObject getJWSProtectedHeaderSchemaJSON();

    public abstract Map<URI, JSONObject> getJWSProtectedHeaderSchemaDefinitions();

    public abstract JSONObject getJWSUnprotectedHeaderSchemaJSON();

    public abstract Map<URI, JSONObject> getJWSUnprotectedHeaderSchemaDefinitions();

    public List<String> validateAgainstJWSSchema(InputStream is) {
        return this.validateAgainstJWSSchema(this.parseJson(is));
    }

    public List<String> validateAgainstJWSSchema(String jsonString) {
        return this.validateAgainstJWSSchema(this.parseJson(jsonString));
    }

    public List<String> validateAgainstJWSSchema(JSONObject json) {
        return this.validateAgainstSchema(json, this.getJWSSchema());
    }

    public List<String> validateAgainstJWSProtectedHeaderSchema(InputStream is) {
        return this.validateAgainstJWSProtectedHeaderSchema(this.parseJson(is));
    }

    public List<String> validateAgainstJWSProtectedHeaderSchema(String jsonString) {
        return this.validateAgainstJWSProtectedHeaderSchema(this.parseJson(jsonString));
    }

    public List<String> validateAgainstJWSProtectedHeaderSchema(JSONObject json) {
        return this.validateAgainstSchema(json, this.getJWSProtectedHeaderSchema());
    }

    public List<String> validateAgainstJWSUnprotectedHeaderSchema(InputStream is) {
        return this.validateAgainstJWSUnprotectedHeaderSchema(this.parseJson(is));
    }

    public List<String> validateAgainstJWSUnprotectedHeaderSchema(String jsonString) {
        return this.validateAgainstJWSUnprotectedHeaderSchema(this.parseJson(jsonString));
    }

    public List<String> validateAgainstJWSUnprotectedHeaderSchema(JSONObject json) {
        return this.validateAgainstSchema(json, this.getJWSUnprotectedHeaderSchema());
    }

    public List<String> validateAgainstSchema(JSONObject json, Schema schema) {
        try {
            schema.validate(json);
        }
        catch (ValidationException e) {
            return e.getAllMessages();
        }
        catch (Exception e) {
            return Collections.singletonList(e.getMessage());
        }
        return Collections.emptyList();
    }

    public JSONObject parseJson(String json) {
        return new JSONObject(new JSONTokener(json));
    }

    public JSONObject parseJson(InputStream inputStream) {
        return new JSONObject(new JSONTokener(inputStream));
    }

    public Schema loadSchema(JSONObject schemaJSON, Map<URI, JSONObject> definitions) {
        SchemaLoader.SchemaLoaderBuilder builder = SchemaLoader.builder().schemaJson(schemaJSON).draftV7Support();
        for (Map.Entry<URI, JSONObject> definition : definitions.entrySet()) {
            builder.registerSchemaByURI(definition.getKey(), definition.getValue());
        }
        SchemaLoader loader = builder.build();
        return loader.load().build();
    }
}

