/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.definition.xmldsig.XMLDSigElement;
import eu.europa.esig.dss.definition.xmldsig.XMLDSigPaths;
import eu.europa.esig.dss.enumerations.MimeTypeEnum;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.resolver.ResourceResolverContext;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class CounterSignatureResolver
extends ResourceResolverSpi {
    private final DSSDocument document;

    public CounterSignatureResolver(DSSDocument document) {
        this.document = document;
    }

    @Override
    public XMLSignatureInput engineResolveURI(ResourceResolverContext context) throws ResourceResolverException {
        Node node = this.resolveNode(context.attr);
        if (node != null) {
            return this.createFromNode(node);
        }
        Object[] exArgs = new Object[]{String.format("Unable to find a signed content by URI : '%s'", context.attr.getNodeValue())};
        throw new ResourceResolverException("generic.EmptyMessage", exArgs, null, context.baseUri);
    }

    private XMLSignatureInput createFromNode(Node node) {
        XMLSignatureInput result = new XMLSignatureInput(DSSXMLUtils.serializeNode(node));
        result.setMIMEType(MimeTypeEnum.XML.getMimeTypeString());
        return result;
    }

    private boolean isXPointerSlash(String uri) {
        return uri.equals("#xpointer(/)");
    }

    @Override
    public boolean engineCanResolveURI(ResourceResolverContext context) {
        Attr uriAttr = context.attr;
        return uriAttr != null && (DomUtils.isXPointerQuery(uriAttr.getNodeValue()) || DomUtils.isElementReference(uriAttr.getNodeValue())) && this.resolveNode(uriAttr) != null;
    }

    private Node resolveNode(Attr uriAttr) {
        if (uriAttr == null) {
            return null;
        }
        String uriValue = DSSUtils.decodeURI(uriAttr.getNodeValue());
        Document documentDom = DomUtils.buildDOM(this.document);
        Node node = DomUtils.getNode(documentDom, XMLDSigPaths.ALL_SIGNATURE_VALUES_PATH + DomUtils.getXPathByIdAttribute(uriValue));
        if (node == null && this.isXPointerSlash(uriValue) && XMLDSigElement.SIGNATURE_VALUE.getTagName().equals(documentDom.getLocalName())) {
            node = documentDom;
        } else if (node == null && DomUtils.isXPointerQuery(uriValue)) {
            String xPointerId = DomUtils.getXPointerId(uriValue);
            node = DomUtils.getNode(documentDom, XMLDSigPaths.ALL_SIGNATURE_VALUES_PATH + DomUtils.getXPathByIdAttribute(xPointerId));
        }
        if (node != null) {
            return node;
        }
        return null;
    }
}

