/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.ValidationData;
import eu.europa.esig.dss.validation.ValidationDataContainer;
import eu.europa.esig.dss.xades.signature.XAdESLevelBaselineLT;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import java.util.List;
import org.w3c.dom.Element;

public class XAdESLevelBaselineLTA
extends XAdESLevelBaselineLT {
    public XAdESLevelBaselineLTA(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
    }

    @Override
    protected void extendSignatures(List<AdvancedSignature> signatures) {
        super.extendSignatures(signatures);
        boolean addTimestampValidationData = false;
        for (AdvancedSignature signature : signatures) {
            this.initializeSignatureBuilder((XAdESSignature)signature);
            this.assertSignatureValid(signature);
            if (!this.xadesSignature.hasLTAProfile()) continue;
            addTimestampValidationData = true;
        }
        ValidationDataContainer validationDataContainer = null;
        if (addTimestampValidationData) {
            validationDataContainer = this.documentValidator.getValidationData(signatures);
        }
        for (AdvancedSignature signature : signatures) {
            this.initializeSignatureBuilder((XAdESSignature)signature);
            this.assertExtendSignatureToLTAPossible();
            Element levelLTUnsignedProperties = (Element)this.unsignedSignaturePropertiesDom.cloneNode(true);
            if (this.xadesSignature.hasLTAProfile() && addTimestampValidationData) {
                String indent = this.removeLastTimestampValidationData();
                ValidationData validationDataForInclusion = validationDataContainer.getCompleteValidationDataForSignature(signature);
                this.incorporateTimestampValidationData(validationDataForInclusion, indent);
            }
            this.incorporateArchiveTimestamp();
            this.unsignedSignaturePropertiesDom = this.indentIfPrettyPrint(this.unsignedSignaturePropertiesDom, levelLTUnsignedProperties);
        }
    }

    private void assertExtendSignatureToLTAPossible() {
        if (SignatureLevel.XAdES_BASELINE_LTA.equals((Object)this.params.getSignatureLevel())) {
            this.assertDetachedDocumentsContainBinaries();
        }
    }
}

