/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.exception.IllegalInputException;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLToken;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPToken;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.ValidationData;
import eu.europa.esig.dss.validation.ValidationDataContainer;
import eu.europa.esig.dss.xades.signature.XAdESLevelBaselineT;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Element;

public class XAdESLevelBaselineLT
extends XAdESLevelBaselineT {
    public XAdESLevelBaselineLT(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
    }

    @Override
    protected void extendSignatures(List<AdvancedSignature> signatures) {
        super.extendSignatures(signatures);
        boolean ltLevelRequired = false;
        for (AdvancedSignature signature : signatures) {
            this.initializeSignatureBuilder((XAdESSignature)signature);
            if (!this.ltLevelExtensionRequired()) continue;
            this.assertSignatureValid(signature);
            this.xadesSignature.resetCertificateSource();
            this.xadesSignature.resetRevocationSources();
            this.xadesSignature.resetTimestampSource();
            ltLevelRequired = true;
        }
        if (!ltLevelRequired) {
            return;
        }
        ValidationDataContainer validationDataContainer = this.documentValidator.getValidationData(signatures);
        for (AdvancedSignature signature : signatures) {
            this.initializeSignatureBuilder((XAdESSignature)signature);
            if (!SignatureLevel.XAdES_BASELINE_LT.equals((Object)this.params.getSignatureLevel()) && this.xadesSignature.hasLTAProfile()) continue;
            this.assertExtendSignatureToLTPossible();
            String indent = this.removeOldCertificateValues();
            this.removeOldRevocationValues();
            Element levelTUnsignedProperties = (Element)this.unsignedSignaturePropertiesDom.cloneNode(true);
            ValidationData validationDataForInclusion = validationDataContainer.getCompleteValidationDataForSignature(signature);
            Set<CertificateToken> certificateValuesToAdd = validationDataForInclusion.getCertificateTokens();
            Set<CRLToken> crlsToAdd = validationDataForInclusion.getCrlTokens();
            Set<OCSPToken> ocspsToAdd = validationDataForInclusion.getOcspTokens();
            this.incorporateCertificateValues(this.unsignedSignaturePropertiesDom, certificateValuesToAdd, indent);
            this.incorporateRevocationValues(this.unsignedSignaturePropertiesDom, crlsToAdd, ocspsToAdd, indent);
            this.unsignedSignaturePropertiesDom = this.indentIfPrettyPrint(this.unsignedSignaturePropertiesDom, levelTUnsignedProperties);
        }
    }

    private boolean ltLevelExtensionRequired() {
        return SignatureLevel.XAdES_BASELINE_LT.equals((Object)this.params.getSignatureLevel()) || !this.xadesSignature.hasLTAProfile();
    }

    private void assertExtendSignatureToLTPossible() {
        SignatureLevel signatureLevel = this.params.getSignatureLevel();
        if (SignatureLevel.XAdES_BASELINE_LT.equals((Object)signatureLevel) && this.xadesSignature.hasLTAProfile()) {
            throw new IllegalInputException(String.format("Cannot extend signature to '%s'. The signature is already extended with LTA level.", new Object[]{signatureLevel}));
        }
        if (this.xadesSignature.getCertificateSource().getNumberOfCertificates() == 0) {
            throw new IllegalInputException("Cannot extend signature. The signature does not contain certificates.");
        }
        if (this.xadesSignature.areAllSelfSignedCertificates()) {
            throw new IllegalInputException("Cannot extend signature. The signature contains only self-signed certificate chains.");
        }
    }
}

