/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.reference;

import eu.europa.esig.dss.definition.DSSNamespace;
import eu.europa.esig.dss.definition.xmldsig.XMLDSigNamespace;
import eu.europa.esig.dss.xades.reference.ComplexTransform;
import java.util.Objects;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XsltTransform
extends ComplexTransform {
    private static final long serialVersionUID = -5119986978252813925L;
    private final Document content;

    public XsltTransform(Document content) {
        this(XMLDSigNamespace.NS, content);
    }

    public XsltTransform(DSSNamespace xmlDSigNamespace, Document content) {
        super(xmlDSigNamespace, "http://www.w3.org/TR/1999/REC-xslt-19991116");
        Objects.requireNonNull(content, "The content cannot be null!");
        this.content = content;
    }

    @Override
    public Element createTransform(Document document, Element parentNode) {
        Element transform = super.createTransform(document, parentNode);
        Document clonedNode = (Document)this.content.cloneNode(true);
        Element contextDocumentElement = clonedNode.getDocumentElement();
        document.adoptNode(contextDocumentElement);
        return (Element)transform.appendChild(contextDocumentElement);
    }
}

