/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.reference;

import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.ReferenceValidation;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.validation.TransformsDescriptionBuilder;
import java.util.ArrayList;
import java.util.List;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.transforms.Transforms;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class XAdESReferenceValidation
extends ReferenceValidation {
    private static final long serialVersionUID = 2721340360134442005L;
    private static final Logger LOG = LoggerFactory.getLogger(XAdESReferenceValidation.class);
    private final Reference reference;
    private final String id;
    private final String uri;

    public XAdESReferenceValidation(Reference reference) {
        this.reference = reference;
        this.id = reference.getId();
        this.uri = DSSXMLUtils.getReferenceURI(reference);
    }

    public String getId() {
        return this.id;
    }

    public String getUri() {
        return this.uri;
    }

    public byte[] getOriginalContentBytes() {
        return DSSXMLUtils.getReferenceOriginalContentBytes(this.reference);
    }

    @Override
    public String getName() {
        if (Utils.isStringNotBlank(this.id)) {
            return this.id;
        }
        if (Utils.isStringNotBlank(this.uri)) {
            return this.uri;
        }
        return "";
    }

    @Override
    public List<String> getTransformationNames() {
        if (this.transforms == null) {
            this.transforms = new ArrayList();
            try {
                Transforms referenceTransforms = this.reference.getTransforms();
                if (referenceTransforms != null) {
                    Element transformsElement = referenceTransforms.getElement();
                    TransformsDescriptionBuilder transformsDescriptionBuilder = new TransformsDescriptionBuilder(transformsElement);
                    this.transforms = transformsDescriptionBuilder.build();
                }
            }
            catch (XMLSecurityException e) {
                LOG.warn("Unable to analyze trasnformations", e);
            }
        }
        return this.transforms;
    }
}

