/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.reference;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.enumerations.SignaturePackaging;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.reference.DSSReference;
import eu.europa.esig.dss.xades.reference.DSSTransform;
import eu.europa.esig.dss.xades.reference.ReferenceIdProvider;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class ReferenceVerifier {
    private static final Logger LOG = LoggerFactory.getLogger(ReferenceVerifier.class);
    private XAdESSignatureParameters signatureParameters;

    public ReferenceVerifier(XAdESSignatureParameters signatureParameters) {
        this.signatureParameters = signatureParameters;
    }

    public void checkReferencesValidity() {
        if (this.signatureParameters != null) {
            String referenceWrongMessage = "Reference setting is not correct! ";
            ReferenceIdProvider referenceIdProvider = new ReferenceIdProvider();
            referenceIdProvider.setSignatureParameters(this.signatureParameters);
            for (DSSReference reference : this.signatureParameters.getReferences()) {
                Object id;
                Document document;
                if (Utils.isStringEmpty(reference.getId())) {
                    LOG.debug("No Id defined for a reference. Generate a deterministic identifier...");
                    reference.setId(referenceIdProvider.getReferenceId());
                }
                if (reference.getObject() != null) {
                    LOG.debug("ds:Object is defined for reference with Id '{}'. Use the provided value.", (Object)reference.getId());
                    continue;
                }
                if (DomUtils.isElementReference(reference.getUri()) && !DSSXMLUtils.isObjectReferenceType(reference.getType()) && DomUtils.isDOM(reference.getContents()) && DomUtils.getElementById(document = DomUtils.buildDOM(reference.getContents()), (String)(id = DomUtils.getId(reference.getUri()))) == null) {
                    throw new IllegalArgumentException(String.format("An element with Id '%s' has not been found in the provided content!", id));
                }
                List<DSSTransform> transforms = reference.getTransforms();
                if (Utils.isCollectionNotEmpty(transforms)) {
                    id = transforms.iterator();
                    while (id.hasNext()) {
                        DSSTransform transform = id.next();
                        if (!"http://www.w3.org/2000/09/xmldsig#base64".equals(transform.getAlgorithm())) continue;
                        if (this.signatureParameters.isEmbedXML()) {
                            throw new IllegalArgumentException("Reference setting is not correct! The embedXML(true) parameter is not compatible with base64 transform.");
                        }
                        if (this.signatureParameters.isManifestSignature()) {
                            throw new IllegalArgumentException("Reference setting is not correct! Manifest signature is not compatible with base64 transform.");
                        }
                        if (!SignaturePackaging.ENVELOPING.equals((Object)this.signatureParameters.getSignaturePackaging())) {
                            throw new IllegalArgumentException("Reference setting is not correct! " + String.format("Base64 transform is not compatible with %s signature format.", new Object[]{this.signatureParameters.getSignaturePackaging()}));
                        }
                        if (transforms.size() <= 1) continue;
                        throw new IllegalArgumentException("Reference setting is not correct! Base64 transform cannot be used with other transformations.");
                    }
                    continue;
                }
                String uri = reference.getUri();
                if (Utils.isStringBlank(uri) || DomUtils.isElementReference(uri)) {
                    LOG.warn("A reference with id='{}' and uri='{}' points to an XML Node, while no transforms are defined! The configuration can lead to an unexpected result!", (Object)reference.getId(), (Object)uri);
                }
                if (!SignaturePackaging.ENVELOPED.equals((Object)this.signatureParameters.getSignaturePackaging()) || !Utils.isStringBlank(uri)) continue;
                throw new IllegalArgumentException("Reference setting is not correct! Enveloped signature must have an enveloped transformation!");
            }
        }
    }
}

