/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.enumerations.DigestMatcherType;
import eu.europa.esig.dss.enumerations.MimeType;
import eu.europa.esig.dss.enumerations.MimeTypeEnum;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.ReferenceValidation;
import eu.europa.esig.dss.validation.SignatureCryptographicVerification;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import java.util.ArrayList;
import java.util.List;
import org.apache.xml.security.signature.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class XAdESSignatureUtils {
    private static final Logger LOG = LoggerFactory.getLogger(XAdESSignatureUtils.class);

    private XAdESSignatureUtils() {
    }

    public static List<DSSDocument> getSignerDocuments(XAdESSignature signature) {
        ArrayList<DSSDocument> result = new ArrayList<DSSDocument>();
        SignatureCryptographicVerification signatureCryptographicVerification = signature.getSignatureCryptographicVerification();
        if (!signatureCryptographicVerification.isSignatureValid()) {
            return result;
        }
        List<Reference> references = signature.getReferences();
        if (Utils.isCollectionNotEmpty(references)) {
            for (Reference reference : references) {
                try {
                    DSSDocument referenceDocument;
                    if (DSSXMLUtils.isSignedProperties(reference, signature.getXAdESPaths()) || (referenceDocument = XAdESSignatureUtils.getReferenceDocument(reference, signature)) == null) continue;
                    result.add(referenceDocument);
                }
                catch (DSSException e) {
                    LOG.warn("Not able to extract an original content for a reference with name '{}' and URI '{}'. Reason : {}", reference.getId(), reference.getURI(), e.getMessage());
                }
            }
        }
        return result;
    }

    private static DSSDocument getReferenceDocument(Reference reference, XAdESSignature signature) {
        DSSDocument document = XAdESSignatureUtils.getDSObject(reference, signature);
        if (document != null) {
            return document;
        }
        document = XAdESSignatureUtils.getDSManifest(reference, signature);
        if (document != null) {
            return document;
        }
        try {
            byte[] referencedBytes = reference.getReferencedBytes();
            if (referencedBytes != null) {
                return new InMemoryDocument(referencedBytes, reference.getURI());
            }
            LOG.warn("Reference bytes returned null value : {}", (Object)reference.getId());
        }
        catch (Exception e) {
            LOG.warn("Unable to retrieve reference {}. Reason : {}", reference.getId(), e.getMessage(), e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("A referenced document not found for a reference with Id : [{}]", (Object)reference.getId());
        }
        return null;
    }

    private static DSSDocument getDSObject(Reference reference, XAdESSignature signature) {
        try {
            byte[] bytes;
            String objectId;
            Node objectById;
            if ((reference.typeIsReferenceToObject() || Utils.isStringEmpty(reference.getType())) && (objectById = signature.getObjectById(objectId = DomUtils.getId(reference.getURI()))) != null && objectById.hasChildNodes() && (bytes = DSSXMLUtils.getNodeBytes(objectById.getFirstChild())) != null) {
                return new InMemoryDocument(bytes, objectId, (MimeType)MimeTypeEnum.XML);
            }
        }
        catch (Exception e) {
            LOG.debug("An error occurred during an attempt to extract signed object. Reason : {}", (Object)e.getMessage());
        }
        return null;
    }

    private static DSSDocument getDSManifest(Reference reference, XAdESSignature signature) {
        try {
            byte[] bytes;
            String manifestId;
            Element manifestById;
            if ((reference.typeIsReferenceToManifest() || Utils.isStringEmpty(reference.getType())) && (manifestById = signature.getManifestById(manifestId = DomUtils.getId(reference.getURI()))) != null && (bytes = DSSXMLUtils.getNodeBytes(manifestById)) != null) {
                return new InMemoryDocument(bytes, manifestId, (MimeType)MimeTypeEnum.XML);
            }
        }
        catch (Exception e) {
            LOG.debug("An error occurred during an attempt to extract signed manifest. Reason : {}", (Object)e.getMessage());
        }
        return null;
    }

    public static boolean isKeyInfoCovered(XAdESSignature signature) {
        List<ReferenceValidation> referenceValidations = signature.getReferenceValidations();
        if (Utils.isCollectionNotEmpty(referenceValidations)) {
            for (ReferenceValidation referenceValidation : referenceValidations) {
                if (!DigestMatcherType.KEY_INFO.equals((Object)referenceValidation.getType()) || !referenceValidation.isFound() || !referenceValidation.isIntact()) continue;
                return true;
            }
        }
        return false;
    }
}

