/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.ws.validation.common;

import eu.europa.esig.dss.exception.IllegalInputException;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.policy.ValidationPolicyFacade;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.SignedDocumentValidator;
import eu.europa.esig.dss.validation.reports.Reports;
import eu.europa.esig.dss.ws.converter.RemoteDocumentConverter;
import eu.europa.esig.dss.ws.dto.RemoteDocument;
import eu.europa.esig.dss.ws.dto.exception.DSSRemoteServiceException;
import eu.europa.esig.dss.ws.validation.dto.DataToValidateDTO;
import eu.europa.esig.dss.ws.validation.dto.WSReportsDTO;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteDocumentValidationService {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteDocumentValidationService.class);
    private CertificateVerifier verifier;
    private ValidationPolicy defaultValidationPolicy;

    public void setVerifier(CertificateVerifier verifier) {
        this.verifier = verifier;
    }

    public void setDefaultValidationPolicy(InputStream validationPolicy) {
        try {
            this.defaultValidationPolicy = ValidationPolicyFacade.newFacade().getValidationPolicy(validationPolicy);
        }
        catch (Exception e) {
            throw new DSSRemoteServiceException(String.format("Unable to instantiate validation policy: %s", e.getMessage()), e);
        }
    }

    public void setDefaultValidationPolicy(ValidationPolicy validationPolicy) {
        this.defaultValidationPolicy = validationPolicy;
    }

    public WSReportsDTO validateDocument(DataToValidateDTO dataToValidate) {
        LOG.info("ValidateDocument in process...");
        SignedDocumentValidator validator = this.initValidator(dataToValidate);
        RemoteDocument policy = dataToValidate.getPolicy();
        Reports reports = policy != null ? validator.validateDocument(this.getValidationPolicy(policy)) : (this.defaultValidationPolicy != null ? validator.validateDocument(this.defaultValidationPolicy) : validator.validateDocument());
        WSReportsDTO reportsDTO = new WSReportsDTO(reports.getDiagnosticDataJaxb(), reports.getSimpleReportJaxb(), reports.getDetailedReportJaxb(), reports.getEtsiValidationReportJaxb());
        LOG.info("ValidateDocument is finished");
        return reportsDTO;
    }

    public List<RemoteDocument> getOriginalDocuments(DataToValidateDTO dataToValidate) {
        List<AdvancedSignature> signatures;
        LOG.info("GetOriginalDocuments in process...");
        SignedDocumentValidator validator = this.initValidator(dataToValidate);
        String signatureId = dataToValidate.getSignatureId();
        if (signatureId == null && !(signatures = validator.getSignatures()).isEmpty()) {
            LOG.debug("SignatureId is not defined, the first signature is used");
            signatureId = signatures.get(0).getId();
        }
        List<DSSDocument> originalDocuments = validator.getOriginalDocuments(signatureId);
        List<RemoteDocument> remoteDocuments = RemoteDocumentConverter.toRemoteDocuments(originalDocuments);
        LOG.info("GetOriginalDocuments is finished");
        return remoteDocuments;
    }

    private ValidationPolicy getValidationPolicy(RemoteDocument policy) {
        ValidationPolicy validationPolicy;
        ByteArrayInputStream bais = new ByteArrayInputStream(policy.getBytes());
        try {
            validationPolicy = ValidationPolicyFacade.newFacade().getValidationPolicy(bais);
        }
        catch (Throwable throwable) {
            try {
                try {
                    bais.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new IllegalInputException(String.format("Unable to load the validation policy : %s", e.getMessage()), e);
            }
        }
        bais.close();
        return validationPolicy;
    }

    protected SignedDocumentValidator initValidator(DataToValidateDTO dataToValidate) {
        DSSDocument signedDocument = RemoteDocumentConverter.toDSSDocument(dataToValidate.getSignedDocument());
        SignedDocumentValidator signedDocValidator = SignedDocumentValidator.fromDocument(signedDocument);
        if (Utils.isCollectionNotEmpty(dataToValidate.getOriginalDocuments())) {
            signedDocValidator.setDetachedContents(RemoteDocumentConverter.toDSSDocuments(dataToValidate.getOriginalDocuments()));
        }
        signedDocValidator.setCertificateVerifier(this.verifier);
        if (dataToValidate.getTokenExtractionStrategy() != null) {
            signedDocValidator.setTokenExtractionStrategy(dataToValidate.getTokenExtractionStrategy());
        }
        return signedDocValidator;
    }
}

