/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.ws.converter;

import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.ws.dto.RemoteCertificate;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class RemoteCertificateConverter {
    private RemoteCertificateConverter() {
    }

    public static CertificateToken toCertificateToken(RemoteCertificate remoteCertificate) {
        if (remoteCertificate == null || Utils.isArrayEmpty(remoteCertificate.getEncodedCertificate())) {
            return null;
        }
        return DSSUtils.loadCertificate(remoteCertificate.getEncodedCertificate());
    }

    public static RemoteCertificate toRemoteCertificate(CertificateToken certificate) {
        if (certificate == null) {
            return null;
        }
        return new RemoteCertificate(certificate.getEncoded());
    }

    public static List<CertificateToken> toCertificateTokens(List<RemoteCertificate> remoteCertificates) {
        if (Utils.isCollectionNotEmpty(remoteCertificates)) {
            LinkedList<CertificateToken> certificateTokens = new LinkedList<CertificateToken>();
            for (RemoteCertificate remoteCertificate : remoteCertificates) {
                CertificateToken certificateToken = RemoteCertificateConverter.toCertificateToken(remoteCertificate);
                if (certificateToken == null) continue;
                certificateTokens.add(certificateToken);
            }
            return certificateTokens;
        }
        return Collections.emptyList();
    }
}

