/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.timestamp;

import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.SignedDocumentValidator;
import eu.europa.esig.dss.validation.executor.ValidationLevel;
import eu.europa.esig.dss.validation.scope.DetachedTimestampScopeFinder;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import eu.europa.esig.dss.validation.timestamp.TimestampValidator;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.tsp.TSPException;

public class DetachedTimestampValidator
extends SignedDocumentValidator
implements TimestampValidator {
    protected TimestampType timestampType;
    protected TimestampToken timestampToken;

    DetachedTimestampValidator() {
    }

    public DetachedTimestampValidator(DSSDocument timestampFile) {
        this(timestampFile, TimestampType.CONTENT_TIMESTAMP);
    }

    public DetachedTimestampValidator(DSSDocument timestampFile, TimestampType timestampType) {
        this.document = timestampFile;
        this.timestampType = timestampType;
    }

    @Override
    public boolean isSupported(DSSDocument dssDocument) {
        byte firstByte = DSSUtils.readFirstByte(dssDocument);
        if (DSSASN1Utils.isASN1SequenceTag(firstByte)) {
            return DSSUtils.isTimestampToken(dssDocument);
        }
        return false;
    }

    @Override
    protected void assertConfigurationValid() {
        Objects.requireNonNull(this.certificateVerifier, "CertificateVerifier is not defined");
    }

    @Override
    protected List<TimestampToken> buildDetachedTimestamps() {
        return Collections.singletonList(this.getTimestamp());
    }

    @Override
    public TimestampToken getTimestamp() {
        if (this.timestampToken == null) {
            this.timestampToken = this.createTimestampToken();
            DetachedTimestampScopeFinder timestampScopeFinder = this.getTimestampScopeFinder();
            this.prepareDetachedTimestampScopeFinder(timestampScopeFinder);
            this.findTimestampScopes(this.timestampToken, timestampScopeFinder);
        }
        return this.timestampToken;
    }

    protected TimestampToken createTimestampToken() {
        Objects.requireNonNull(this.certificateVerifier, "CertificateVerifier is not defined");
        Objects.requireNonNull(this.document, "The timestampFile must be defined!");
        Objects.requireNonNull(this.timestampType, "The TimestampType must be defined!");
        try {
            TimestampToken newTimestampToken = new TimestampToken(DSSUtils.toByteArray(this.document), this.timestampType);
            newTimestampToken.setFileName(this.document.getName());
            newTimestampToken.matchData(this.getTimestampedData());
            return newTimestampToken;
        }
        catch (IOException | CMSException | TSPException e) {
            throw new DSSException(String.format("Unable to create a TimestampToken. Reason : %s", e.getMessage()), e);
        }
    }

    @Override
    public void setValidationLevel(ValidationLevel validationLevel) {
        if (ValidationLevel.BASIC_SIGNATURES == validationLevel) {
            throw new IllegalArgumentException("Minimal level is " + (Object)((Object)ValidationLevel.TIMESTAMPS));
        }
        super.setValidationLevel(validationLevel);
    }

    public void setTimestampedData(DSSDocument document) {
        Objects.requireNonNull(document, "The document is null");
        this.setDetachedContents(Arrays.asList(document));
    }

    @Override
    public DSSDocument getTimestampedData() {
        int size = Utils.collectionSize(this.detachedContents);
        if (size == 0) {
            return null;
        }
        if (size > 1) {
            throw new IllegalArgumentException("Only one detached document shall be provided for a timestamp validation!");
        }
        return (DSSDocument)this.detachedContents.iterator().next();
    }

    @Override
    protected DetachedTimestampScopeFinder getTimestampScopeFinder() {
        return new DetachedTimestampScopeFinder();
    }

    protected void prepareDetachedTimestampScopeFinder(DetachedTimestampScopeFinder timestampScopeFinder) {
        timestampScopeFinder.setDefaultDigestAlgorithm(this.getDefaultDigestAlgorithm());
        timestampScopeFinder.setTokenIdentifierProvider(this.getTokenIdentifierProvider());
        timestampScopeFinder.setTimestampedData(this.getTimestampedData());
    }

    @Override
    public List<DSSDocument> getOriginalDocuments(String signatureId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<DSSDocument> getOriginalDocuments(AdvancedSignature advancedSignature) {
        throw new UnsupportedOperationException("getOriginalDocuments(AdvancedSignature) is not supported for DetachedTimestampValidator!");
    }
}

