/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.scope;

import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.scope.SignatureScope;
import java.util.List;
import java.util.Objects;

public abstract class SignatureScopeWithTransformations
extends SignatureScope {
    private static final long serialVersionUID = -7049827869970167023L;
    private final List<String> transformations;

    protected SignatureScopeWithTransformations(String name, Digest digest, List<String> transformations) {
        super(name, digest);
        this.transformations = transformations;
    }

    protected String addTransformationIfNeeded(String description) {
        if (Utils.isCollectionNotEmpty(this.transformations)) {
            description = description + " with transformations.";
        }
        return description;
    }

    @Override
    public List<String> getTransformations() {
        return this.transformations;
    }

    @Override
    public String toString() {
        return "SignatureScopeWithTransformations{transformations=" + this.transformations + "} " + super.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SignatureScopeWithTransformations)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SignatureScopeWithTransformations that = (SignatureScopeWithTransformations)o;
        return Objects.equals(this.transformations, that.transformations);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.transformations != null ? this.transformations.hashCode() : 0);
        return result;
    }
}

