/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp.checks.vts.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlCRS;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateRevocationSelectorResultCheck;
import java.util.Date;

public class SatisfyingRevocationDataExistsCheck<T extends XmlConstraintsConclusion>
extends CertificateRevocationSelectorResultCheck<T> {
    private final CertificateWrapper certificateWrapper;
    private final Date controlTime;

    public SatisfyingRevocationDataExistsCheck(I18nProvider i18nProvider, T result, XmlCRS crsResult, CertificateWrapper certificateWrapper, Date controlTime, LevelConstraint constraint) {
        super(i18nProvider, result, crsResult, constraint);
        this.certificateWrapper = certificateWrapper;
        this.controlTime = controlTime;
    }

    @Override
    protected String buildAdditionalInfo() {
        String latestAcceptableRevocationId = this.crsResult.getLatestAcceptableRevocationId();
        if (latestAcceptableRevocationId != null) {
            return this.i18nProvider.getMessage(MessageTag.CERTIFICATE_REVOCATION_FOUND, latestAcceptableRevocationId, this.certificateWrapper.getId(), ValidationProcessUtils.getFormattedDate(this.controlTime));
        }
        return this.i18nProvider.getMessage(MessageTag.CERTIFICATE_REVOCATION_NOT_FOUND, this.certificateWrapper.getId(), ValidationProcessUtils.getFormattedDate(this.controlTime));
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_VTS_IRDPFC;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_VTS_IRDPFC_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.NO_POE;
    }
}

