/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.diagnostic.CertificateRevocationWrapper;
import eu.europa.esig.dss.diagnostic.RevocationWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;
import java.util.List;
import java.util.stream.Collectors;

public class PastValidationAcceptableRevocationDataAvailable<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    private final List<CertificateRevocationWrapper> revocationData;

    public PastValidationAcceptableRevocationDataAvailable(I18nProvider i18nProvider, T result, List<CertificateRevocationWrapper> revocationData, LevelConstraint constraint) {
        super(i18nProvider, result, constraint);
        this.revocationData = revocationData;
    }

    @Override
    protected boolean process() {
        return Utils.isCollectionNotEmpty(this.revocationData);
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_XCV_IARDPFC;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_XCV_IARDPFC_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.TRY_LATER;
    }

    @Override
    protected String buildAdditionalInfo() {
        if (Utils.isCollectionNotEmpty(this.revocationData)) {
            List revocationDataIds = this.revocationData.stream().map(RevocationWrapper::getId).collect(Collectors.toList());
            return this.i18nProvider.getMessage(MessageTag.ACCEPTABLE_REVOCATION, revocationDataIds);
        }
        return null;
    }
}

