/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlPSV;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import java.util.Date;

public class BestSignatureTimeAfterCertificateIssuanceAndBeforeCertificateExpirationCheck
extends ChainItem<XmlPSV> {
    private final Date controlTime;
    private final CertificateWrapper certificate;
    private final SubIndication currentTimeSubIndication;

    public BestSignatureTimeAfterCertificateIssuanceAndBeforeCertificateExpirationCheck(I18nProvider i18nProvider, XmlPSV result, Date controlTime, CertificateWrapper certificate, SubIndication currentTimeSubIndication, LevelConstraint constraint) {
        super(i18nProvider, result, constraint);
        this.controlTime = controlTime;
        this.certificate = certificate;
        this.currentTimeSubIndication = currentTimeSubIndication;
    }

    @Override
    protected boolean process() {
        return this.certificate.getNotBefore() != null && this.controlTime.compareTo(this.certificate.getNotBefore()) >= 0 && this.certificate.getNotAfter() != null && this.controlTime.compareTo(this.certificate.getNotAfter()) <= 0;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.TSV_ISCNVABST;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.TSV_ISCNVABST_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return this.currentTimeSubIndication;
    }

    @Override
    protected String buildAdditionalInfo() {
        String notBeforeStr = this.certificate.getNotBefore() == null ? " ? " : ValidationProcessUtils.getFormattedDate(this.certificate.getNotBefore());
        String notAfterStr = this.certificate.getNotAfter() == null ? " ? " : ValidationProcessUtils.getFormattedDate(this.certificate.getNotAfter());
        String validationTime = ValidationProcessUtils.getFormattedDate(this.controlTime);
        return this.i18nProvider.getMessage(MessageTag.CERTIFICATE_VALIDITY, validationTime, notBeforeStr, notAfterStr);
    }
}

