/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.trust.filter;

import eu.europa.esig.dss.diagnostic.TrustedServiceWrapper;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.AbstractTrustedServiceFilter;
import java.util.Collections;
import java.util.Set;

public class ServiceByTLUrlFilter
extends AbstractTrustedServiceFilter {
    private final Set<String> tlUrls;

    public ServiceByTLUrlFilter(String tlUrl) {
        this(Collections.singleton(tlUrl));
    }

    public ServiceByTLUrlFilter(Set<String> tlUrls) {
        this.tlUrls = tlUrls;
    }

    @Override
    protected boolean isAcceptable(TrustedServiceWrapper service) {
        for (String url : this.tlUrls) {
            if (!Utils.areStringsEqualIgnoreCase(url, service.getTrustedList().getUrl())) continue;
            return true;
        }
        return false;
    }
}

