/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.trust.filter;

import eu.europa.esig.dss.diagnostic.TrustedServiceWrapper;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.AbstractTrustedServiceFilter;
import java.util.Date;

public class ServiceByMRAEquivalenceStartingDateFilter
extends AbstractTrustedServiceFilter {
    private final Date date;

    public ServiceByMRAEquivalenceStartingDateFilter(Date date) {
        this.date = date;
    }

    @Override
    protected boolean isAcceptable(TrustedServiceWrapper service) {
        Date startDate = service.getMraTrustServiceEquivalenceStatusStartingTime();
        if (startDate == null || this.date == null) {
            return false;
        }
        Date endDate = service.getMraTrustServiceEquivalenceStatusEndingTime();
        return !this.date.before(startDate) && (endDate == null || !this.date.after(endDate));
    }
}

