/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.trust.consistency;

import eu.europa.esig.dss.diagnostic.TrustedServiceWrapper;
import eu.europa.esig.dss.enumerations.AdditionalServiceInformation;
import eu.europa.esig.dss.enumerations.ServiceQualification;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.qualification.trust.consistency.TrustedServiceCondition;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

class TrustedServiceQualifierAndAdditionalServiceInfoConsistency
implements TrustedServiceCondition {
    private static final Map<ServiceQualification, AdditionalServiceInformation> CORRESPONDENCE_MAP_QUALIFIER_ASI = new EnumMap<ServiceQualification, AdditionalServiceInformation>(ServiceQualification.class);

    TrustedServiceQualifierAndAdditionalServiceInfoConsistency() {
    }

    @Override
    public boolean isConsistent(TrustedServiceWrapper trustedService) {
        List<String> asis = trustedService.getAdditionalServiceInfos();
        List<String> qualifiers = ServiceQualification.getUsageQualifiers(trustedService.getCapturedQualifiers());
        return this.isQualifierInAdditionServiceInfos(qualifiers, asis);
    }

    private boolean isQualifierInAdditionServiceInfos(List<String> qualifiers, List<String> asis) {
        if (Utils.collectionSize(asis) >= 1 && Utils.collectionSize(qualifiers) == 1) {
            String currentUsage = qualifiers.get(0);
            ServiceQualification serviceQualification = ServiceQualification.getByUri(currentUsage);
            AdditionalServiceInformation expectedASI = CORRESPONDENCE_MAP_QUALIFIER_ASI.get((Object)serviceQualification);
            return expectedASI != null && asis.contains(expectedASI.getUri());
        }
        return true;
    }

    static {
        CORRESPONDENCE_MAP_QUALIFIER_ASI.put(ServiceQualification.QC_FOR_ESIG, AdditionalServiceInformation.FOR_ESIGNATURES);
        CORRESPONDENCE_MAP_QUALIFIER_ASI.put(ServiceQualification.QC_FOR_ESEAL, AdditionalServiceInformation.FOR_ESEALS);
        CORRESPONDENCE_MAP_QUALIFIER_ASI.put(ServiceQualification.QC_FOR_WSA, AdditionalServiceInformation.FOR_WEB_AUTHENTICATION);
    }
}

