/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.trust;

public enum TrustedServiceStatus {
    UNDER_SUPERVISION("under supervision", "http://uri.etsi.org/TrstSvc/TrustedList/Svcstatus/undersupervision", false, true),
    SUPERVISION_OF_SERVICE_IN_CESSATION("supervision in cessation", "http://uri.etsi.org/TrstSvc/TrustedList/Svcstatus/supervisionincessation", false, true),
    SUPERVISION_CEASED("supervision ceased", "http://uri.etsi.org/TrstSvc/TrustedList/Svcstatus/supervisionceased", false, false),
    SUPERVISION_REVOKED("supervision revoked", "http://uri.etsi.org/TrstSvc/TrustedList/Svcstatus/supervisionrevoked", false, false),
    ACCREDITED("accredited", "http://uri.etsi.org/TrstSvc/TrustedList/Svcstatus/accredited", false, true),
    ACCREDITATION_CEASED("accreditation ceased", "http://uri.etsi.org/TrstSvc/TrustedList/Svcstatus/accreditationceased", false, false),
    ACCREDITATION_REVOKED("accreditation revoked", "http://uri.etsi.org/TrstSvc/TrustedList/Svcstatus/accreditationrevoked", false, false),
    GRANTED("granted", "http://uri.etsi.org/TrstSvc/TrustedList/Svcstatus/granted", true, true),
    WITHDRAWN("withdrawn", "http://uri.etsi.org/TrstSvc/TrustedList/Svcstatus/withdrawn", true, false),
    SET_BY_NATIONAL_LAW("set by national law", "http://uri.etsi.org/TrstSvc/TrustedList/Svcstatus/setbynationallaw", true, false),
    RECONIZED_AT_NATIONAL_LEVEL("recognised at national level", "http://uri.etsi.org/TrstSvc/TrustedList/Svcstatus/recognisedatnationallevel", true, false),
    DEPRECATED_BY_NATIONAL_LAW("deprecated by national law", "http://uri.etsi.org/TrstSvc/TrustedList/Svcstatus/deprecatedbynationallaw", true, false),
    DEPRECATED_AT_NATIONAL_LEVEL("deprecated at national level", "http://uri.etsi.org/TrstSvc/TrustedList/Svcstatus/deprecatedatnationallevel", true, false);

    private final String shortName;
    private final String uri;
    private final boolean postEidas;
    private final boolean valid;

    private TrustedServiceStatus(String shortName, String uri, boolean postEidas, boolean valid) {
        this.shortName = shortName;
        this.uri = uri;
        this.postEidas = postEidas;
        this.valid = valid;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getUri() {
        return this.uri;
    }

    public boolean isPreEidas() {
        return !this.isPostEidas();
    }

    public boolean isPostEidas() {
        return this.postEidas;
    }

    public boolean isValid() {
        return this.valid;
    }

    public static boolean isAcceptableStatusBeforeEIDAS(String uri) {
        TrustedServiceStatus tss = TrustedServiceStatus.fromUri(uri);
        return tss != null && tss.isPreEidas() && tss.isValid();
    }

    public static boolean isAcceptableStatusAfterEIDAS(String uri) {
        TrustedServiceStatus tss = TrustedServiceStatus.fromUri(uri);
        return tss != null && tss.isPostEidas() && tss.isValid();
    }

    public static TrustedServiceStatus fromUri(String uri) {
        for (TrustedServiceStatus status : TrustedServiceStatus.values()) {
            if (!status.getUri().equals(uri)) continue;
            return status;
        }
        return null;
    }
}

