/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.timestamp;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlTLAnalysis;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationTimestampQualification;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.diagnostic.TrustedServiceWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.TimestampQualification;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.GrantedStatusCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.RelatedToMraEnactedTrustServiceCheck;
import eu.europa.esig.dss.validation.process.qualification.signature.checks.AcceptableListOfTrustedListsCheck;
import eu.europa.esig.dss.validation.process.qualification.signature.checks.AcceptableTrustedListCheck;
import eu.europa.esig.dss.validation.process.qualification.signature.checks.AcceptableTrustedListPresenceCheck;
import eu.europa.esig.dss.validation.process.qualification.signature.checks.TrustedListReachedForCertificateChainCheck;
import eu.europa.esig.dss.validation.process.qualification.timestamp.checks.GrantedStatusAtProductionTimeCheck;
import eu.europa.esig.dss.validation.process.qualification.timestamp.checks.QTSTCheck;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.TrustedServiceFilter;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.TrustedServicesFilterFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class TimestampQualificationBlock
extends Chain<XmlValidationTimestampQualification> {
    private final TimestampWrapper timestamp;
    private final List<XmlTLAnalysis> tlAnalysis;
    private final List<XmlTLAnalysis> relatedTLAnalyses = new ArrayList<XmlTLAnalysis>();
    private TimestampQualification tstQualif = TimestampQualification.NA;

    public TimestampQualificationBlock(I18nProvider i18nProvider, TimestampWrapper timestamp, List<XmlTLAnalysis> tlAnalysis) {
        super(i18nProvider, new XmlValidationTimestampQualification());
        this.timestamp = timestamp;
        this.tlAnalysis = tlAnalysis;
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.TST_QUALIFICATION;
    }

    @Override
    protected void initChain() {
        CertificateWrapper signingCertificate = this.timestamp.getSigningCertificate();
        ChainItem<XmlValidationTimestampQualification> item = this.firstItem = this.isTrustedListReachedForCertificateChain(signingCertificate);
        if (signingCertificate != null && signingCertificate.isTrustedListReached()) {
            List<TrustedServiceWrapper> originalTSPs = signingCertificate.getTrustedServices();
            Set listOfTrustedListUrls = originalTSPs.stream().filter(t2 -> t2.getListOfTrustedLists() != null).map(t2 -> t2.getListOfTrustedLists().getUrl()).collect(Collectors.toSet());
            HashSet<String> acceptableLOTLUrls = new HashSet<String>();
            for (String lotlURL : listOfTrustedListUrls) {
                XmlTLAnalysis lotlAnalysis = this.getTlAnalysis(lotlURL);
                if (lotlAnalysis == null) continue;
                this.relatedTLAnalyses.add(lotlAnalysis);
                AcceptableListOfTrustedListsCheck<XmlValidationTimestampQualification> acceptableLOTL = this.isAcceptableLOTL(lotlAnalysis);
                item = item.setNextItem(acceptableLOTL);
                if (!acceptableLOTL.process()) continue;
                acceptableLOTLUrls.add(lotlURL);
            }
            Set trustedListUrls = originalTSPs.stream().filter(t2 -> t2.getTrustedList() != null && (t2.getListOfTrustedLists() == null || acceptableLOTLUrls.contains(t2.getListOfTrustedLists().getUrl()))).map(t2 -> t2.getTrustedList().getUrl()).collect(Collectors.toSet());
            HashSet<String> acceptableTLUrls = new HashSet<String>();
            if (Utils.isCollectionNotEmpty(trustedListUrls)) {
                for (String tlURL : trustedListUrls) {
                    XmlTLAnalysis currentTL = this.getTlAnalysis(tlURL);
                    if (currentTL == null) continue;
                    this.relatedTLAnalyses.add(currentTL);
                    AcceptableTrustedListCheck<XmlValidationTimestampQualification> acceptableTL = this.isAcceptableTL(currentTL);
                    item = item.setNextItem(acceptableTL);
                    if (!acceptableTL.process()) continue;
                    acceptableTLUrls.add(tlURL);
                }
            }
            item = item.setNextItem(this.isAcceptableTLPresent(acceptableTLUrls));
            if (Utils.isCollectionNotEmpty(acceptableTLUrls)) {
                TrustedServiceFilter filter = TrustedServicesFilterFactory.createFilterByUrls(acceptableTLUrls);
                List<TrustedServiceWrapper> acceptableServices = filter.filter(originalTSPs);
                if (this.isMRAEnactedForTrustedList(acceptableServices)) {
                    filter = TrustedServicesFilterFactory.createMRAEnactedFilter();
                    acceptableServices = filter.filter(acceptableServices);
                    item = item.setNextItem(this.hasMraEnactedTrustedService(acceptableServices));
                }
                filter = TrustedServicesFilterFactory.createFilterByQTST();
                List<TrustedServiceWrapper> qtstServices = filter.filter(acceptableServices);
                item = item.setNextItem(this.hasQTST(qtstServices));
                filter = TrustedServicesFilterFactory.createFilterByGranted();
                List<TrustedServiceWrapper> grantedServices = filter.filter(qtstServices);
                item = item.setNextItem(this.hasGrantedStatus(grantedServices));
                filter = TrustedServicesFilterFactory.createFilterByDate(this.timestamp.getProductionTime());
                List<TrustedServiceWrapper> grantedAtDateServices = filter.filter(grantedServices);
                item = item.setNextItem(this.hasGrantedStatusAtDate(grantedAtDateServices));
                this.tstQualif = Utils.isCollectionNotEmpty(grantedAtDateServices) ? TimestampQualification.QTSA : TimestampQualification.TSA;
            }
        }
    }

    private XmlTLAnalysis getTlAnalysis(String url) {
        for (XmlTLAnalysis xmlTLAnalysis : this.tlAnalysis) {
            if (!Utils.areStringsEqual(url, xmlTLAnalysis.getURL())) continue;
            return xmlTLAnalysis;
        }
        return null;
    }

    @Override
    protected void addAdditionalInfo() {
        this.setIndication();
        this.determineFinalQualification();
    }

    private void setIndication() {
        XmlConclusion conclusion = ((XmlValidationTimestampQualification)this.result).getConclusion();
        if (conclusion != null) {
            if (Utils.isCollectionNotEmpty(conclusion.getErrors())) {
                conclusion.setIndication(Indication.FAILED);
            } else if (Utils.isCollectionNotEmpty(conclusion.getWarnings())) {
                conclusion.setIndication(Indication.INDETERMINATE);
            } else {
                conclusion.setIndication(Indication.PASSED);
            }
        }
    }

    private void determineFinalQualification() {
        ((XmlValidationTimestampQualification)this.result).setTimestampQualification(this.tstQualif);
    }

    @Override
    protected void collectAdditionalMessages(XmlConclusion conclusion) {
        for (XmlTLAnalysis relatedTLAnalysis : this.relatedTLAnalyses) {
            this.collectAllMessages(conclusion, relatedTLAnalysis.getConclusion());
        }
    }

    private ChainItem<XmlValidationTimestampQualification> isTrustedListReachedForCertificateChain(CertificateWrapper signingCertificate) {
        return new TrustedListReachedForCertificateChainCheck<XmlValidationTimestampQualification>(this.i18nProvider, (XmlValidationTimestampQualification)this.result, signingCertificate, this.getFailLevelConstraint());
    }

    private AcceptableListOfTrustedListsCheck<XmlValidationTimestampQualification> isAcceptableLOTL(XmlTLAnalysis xmlLOTLAnalysis) {
        return new AcceptableListOfTrustedListsCheck<XmlValidationTimestampQualification>(this.i18nProvider, (XmlValidationTimestampQualification)this.result, xmlLOTLAnalysis, this.getWarnLevelConstraint());
    }

    private AcceptableTrustedListCheck<XmlValidationTimestampQualification> isAcceptableTL(XmlTLAnalysis xmlTLAnalysis) {
        return new AcceptableTrustedListCheck<XmlValidationTimestampQualification>(this.i18nProvider, (XmlValidationTimestampQualification)this.result, xmlTLAnalysis, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlValidationTimestampQualification> isAcceptableTLPresent(Set<String> acceptableUrls) {
        return new AcceptableTrustedListPresenceCheck<XmlValidationTimestampQualification>(this.i18nProvider, (XmlValidationTimestampQualification)this.result, acceptableUrls, this.getFailLevelConstraint());
    }

    private ChainItem<XmlValidationTimestampQualification> hasMraEnactedTrustedService(List<TrustedServiceWrapper> services) {
        return new RelatedToMraEnactedTrustServiceCheck<XmlValidationTimestampQualification>(this.i18nProvider, (XmlValidationTimestampQualification)this.result, services, this.getFailLevelConstraint());
    }

    private ChainItem<XmlValidationTimestampQualification> hasQTST(List<TrustedServiceWrapper> services) {
        return new QTSTCheck(this.i18nProvider, (XmlValidationTimestampQualification)this.result, services, this.getFailLevelConstraint());
    }

    private ChainItem<XmlValidationTimestampQualification> hasGrantedStatus(List<TrustedServiceWrapper> services) {
        return new GrantedStatusCheck<XmlValidationTimestampQualification>(this.i18nProvider, (XmlValidationTimestampQualification)this.result, services, this.getFailLevelConstraint());
    }

    private ChainItem<XmlValidationTimestampQualification> hasGrantedStatusAtDate(List<TrustedServiceWrapper> services) {
        return new GrantedStatusAtProductionTimeCheck(this.i18nProvider, (XmlValidationTimestampQualification)this.result, services, this.getFailLevelConstraint());
    }

    private boolean isMRAEnactedForTrustedList(List<TrustedServiceWrapper> trustedServices) {
        for (TrustedServiceWrapper trustedService : trustedServices) {
            if (!Utils.isTrue(trustedService.getTrustedList().isMra())) continue;
            return true;
        }
        return false;
    }
}

