/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlSubXCV;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.jaxb.XmlGeneralName;
import eu.europa.esig.dss.diagnostic.jaxb.XmlGeneralSubtree;
import eu.europa.esig.dss.enumerations.GeneralNameType;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateNameConstraintsCheck
extends ChainItem<XmlSubXCV> {
    private static final Logger LOG = LoggerFactory.getLogger(CertificateNameConstraintsCheck.class);
    private final CertificateWrapper certificate;

    public CertificateNameConstraintsCheck(I18nProvider i18nProvider, XmlSubXCV result, CertificateWrapper certificate, LevelConstraint constraint) {
        super(i18nProvider, result, constraint);
        this.certificate = certificate;
    }

    @Override
    protected boolean process() {
        ArrayList<CertificateWrapper> certificateChain = new ArrayList<CertificateWrapper>();
        certificateChain.add(this.certificate);
        certificateChain.addAll(this.certificate.getCertificateChain());
        Set<Map<String, String>> permittedSubtrees = null;
        Set<Map<String, String>> excludedSubtrees = null;
        for (int i = certificateChain.size() - 1; i > -1; --i) {
            CertificateWrapper cert = (CertificateWrapper)certificateChain.get(i);
            if (i == 0) {
                Map<String, String> certDN = this.toDNMap(cert.getCertificateDN());
                List<Map<String, String>> subAltNames = this.getSubjectAlternativeNamesDNList(cert.getSubjectAlternativeNames());
                if (permittedSubtrees != null) {
                    if (!this.isWithinDNSubtrees(certDN, permittedSubtrees)) {
                        return false;
                    }
                    for (Map<String, String> subAltName : subAltNames) {
                        if (this.isWithinDNSubtrees(subAltName, permittedSubtrees)) continue;
                        return false;
                    }
                }
                if (excludedSubtrees != null) {
                    if (this.isWithinDNSubtrees(certDN, excludedSubtrees)) {
                        return false;
                    }
                    for (Map<String, String> subAltName : subAltNames) {
                        if (!this.isWithinDNSubtrees(subAltName, excludedSubtrees)) continue;
                        return false;
                    }
                }
            }
            Set<Map<String, String>> certPermittedSubtrees = this.toGeneralSubtreeMapSet(cert.getPermittedSubtrees());
            Set<Map<String, String>> certExcludedSubtrees = this.toGeneralSubtreeMapSet(cert.getExcludedSubtrees());
            if (Utils.isCollectionNotEmpty(certPermittedSubtrees)) {
                permittedSubtrees = permittedSubtrees != null ? this.intersect(permittedSubtrees, certPermittedSubtrees) : certPermittedSubtrees;
            }
            if (!Utils.isCollectionNotEmpty(certExcludedSubtrees)) continue;
            excludedSubtrees = excludedSubtrees != null ? this.union(excludedSubtrees, certExcludedSubtrees) : certExcludedSubtrees;
        }
        return true;
    }

    private Map<String, String> toDNMap(String rfc2253EncodedString) {
        Map.Entry<String, String> rdn;
        if (Utils.isStringEmpty(rfc2253EncodedString)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        int nextEnd = rfc2253EncodedString.indexOf(44);
        int searchOffset = 0;
        int dnOffset = 0;
        while (nextEnd >= 0) {
            if (nextEnd > 0 && rfc2253EncodedString.charAt(nextEnd - 1) != '\\') {
                String nextStr = rfc2253EncodedString.substring(dnOffset, nextEnd);
                rdn = this.getRDN(nextStr);
                if (rdn != null) {
                    result.put(rdn.getKey(), rdn.getValue());
                }
                dnOffset = nextEnd + 1;
            }
            searchOffset = nextEnd + 1;
            nextEnd = rfc2253EncodedString.indexOf(44, searchOffset);
        }
        String substring = rfc2253EncodedString.substring(dnOffset);
        rdn = this.getRDN(substring);
        if (rdn != null) {
            result.put(rdn.getKey(), rdn.getValue());
        }
        return result;
    }

    private Map.Entry<String, String> getRDN(String str) {
        int nextEquals = str.indexOf(61);
        if (nextEquals >= 0 && str.length() >= nextEquals + 1) {
            return new AbstractMap.SimpleEntry<String, String>(str.substring(0, nextEquals), str.substring(nextEquals + 1));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Unable to build an RDN for string '{}'! Not a DN.", (Object)str);
        }
        return null;
    }

    private List<Map<String, String>> getSubjectAlternativeNamesDNList(List<XmlGeneralName> subjectAlternativeNames) {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        for (XmlGeneralName generalName : subjectAlternativeNames) {
            if (GeneralNameType.DIRECTORY_NAME.equals((Object)generalName.getType())) {
                result.add(this.toDNMap(generalName.getValue()));
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("The GeneralName of type '{}' is skipped.", (Object)generalName.getType());
        }
        return result;
    }

    private boolean isWithinDNSubtrees(Map<String, String> certDN, Set<Map<String, String>> permittedSubtrees) {
        for (Map<String, String> permittedSubtree : permittedSubtrees) {
            if (!this.isWithinDNSubtree(certDN, permittedSubtree)) continue;
            return true;
        }
        return false;
    }

    private Set<Map<String, String>> toGeneralSubtreeMapSet(List<XmlGeneralSubtree> generalSubtrees) {
        HashSet<Map<String, String>> result = new HashSet<Map<String, String>>();
        for (XmlGeneralSubtree xmlGeneralSubtree : generalSubtrees) {
            if (GeneralNameType.DIRECTORY_NAME == xmlGeneralSubtree.getType()) {
                Map<String, String> dnMap;
                if (xmlGeneralSubtree.getMinimum() != null && xmlGeneralSubtree.getMinimum().intValue() != 0) {
                    LOG.warn("'Minimum' field of GeneralSubtree is not supported! The value is skipped.");
                }
                if (xmlGeneralSubtree.getMaximum() != null) {
                    LOG.warn("'Maximum' field of GeneralSubtree is not supported! The value is skipped.");
                }
                if (Utils.isMapNotEmpty(dnMap = this.toDNMap(xmlGeneralSubtree.getValue()))) {
                    result.add(dnMap);
                    continue;
                }
                LOG.warn("Unable to build a DN map for general subtree with value '{}'", (Object)xmlGeneralSubtree.getValue());
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("The general name type '{}' is not supported and skipped!", (Object)xmlGeneralSubtree.getType().getLabel());
        }
        return result;
    }

    private Set<Map<String, String>> intersect(Set<Map<String, String>> originalSet, Set<Map<String, String>> currentSet) {
        HashSet<Map<String, String>> result = new HashSet<Map<String, String>>();
        for (Map<String, String> currentMap : currentSet) {
            for (Map<String, String> originalMap : originalSet) {
                if (this.isWithinDNSubtree(originalMap, currentMap)) {
                    result.add(currentMap);
                    continue;
                }
                if (!this.isWithinDNSubtree(currentMap, originalMap)) continue;
                result.add(originalMap);
            }
            if (!originalSet.contains(currentMap)) continue;
            result.add(currentMap);
        }
        return result;
    }

    private boolean isWithinDNSubtree(Map<String, String> dn, Map<String, String> subtree) {
        if (subtree.size() < 1) {
            return false;
        }
        if (subtree.size() > dn.size()) {
            return false;
        }
        for (Map.Entry<String, String> entry : subtree.entrySet()) {
            String subtreeKey = entry.getKey();
            String subtreeValue = entry.getValue();
            if (dn.containsKey(subtreeKey) && subtreeValue.equals(dn.get(subtreeKey))) continue;
            return false;
        }
        return true;
    }

    private Set<Map<String, String>> union(Set<Map<String, String>> originalSet, Set<Map<String, String>> currentSet) {
        HashSet<Map<String, String>> result = new HashSet<Map<String, String>>();
        for (Map<String, String> currentMap : currentSet) {
            for (Map<String, String> originalMap : originalSet) {
                if (this.isWithinDNSubtree(originalMap, currentMap)) {
                    result.add(currentMap);
                    continue;
                }
                if (this.isWithinDNSubtree(currentMap, originalMap)) {
                    result.add(originalMap);
                    continue;
                }
                result.add(currentMap);
                result.add(originalMap);
            }
            if (!originalSet.contains(currentMap)) continue;
            result.add(currentMap);
        }
        return result;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_XCV_DCSBSINC;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_XCV_DCSBSINC_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.CERTIFICATE_CHAIN_GENERAL_FAILURE;
    }
}

