/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.rac.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBlockType;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.RevocationWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.RevocationType;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevocationConsistentCheck<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    private static final Logger LOG = LoggerFactory.getLogger(RevocationConsistentCheck.class);
    protected final CertificateWrapper certificate;
    protected final RevocationWrapper revocationData;
    protected Date thisUpdate;
    protected Date producedAt;
    protected Date certNotBefore;
    protected Date certNotAfter;
    protected Date notAfterRevoc;
    protected boolean certHashOK;

    public RevocationConsistentCheck(I18nProvider i18nProvider, T result, CertificateWrapper certificate, RevocationWrapper revocationData, LevelConstraint constraint) {
        super(i18nProvider, result, constraint, revocationData.getId());
        this.certificate = certificate;
        this.revocationData = revocationData;
    }

    @Override
    protected XmlBlockType getBlockType() {
        return XmlBlockType.REV_CC;
    }

    @Override
    protected boolean process() {
        Date expiredCertsRevocationInfo;
        Date archiveCutOff;
        this.certNotBefore = this.certificate.getNotBefore();
        this.certNotAfter = this.certificate.getNotAfter();
        this.thisUpdate = this.revocationData.getThisUpdate();
        this.producedAt = this.revocationData.getProductionDate();
        this.notAfterRevoc = this.thisUpdate;
        Date expiredCertsOnCRL = this.revocationData.getExpiredCertsOnCRL();
        if (expiredCertsOnCRL != null) {
            if (expiredCertsOnCRL.before(this.notAfterRevoc)) {
                this.notAfterRevoc = expiredCertsOnCRL;
            } else {
                LOG.info("ExpiredCertsOnCRL : '{}' is not before revocation's thisUpdate : '{}'.", (Object)ValidationProcessUtils.getFormattedDate(expiredCertsOnCRL), (Object)ValidationProcessUtils.getFormattedDate(this.notAfterRevoc));
            }
        }
        if ((archiveCutOff = this.revocationData.getArchiveCutOff()) != null) {
            if (archiveCutOff.before(this.notAfterRevoc)) {
                this.notAfterRevoc = archiveCutOff;
            } else {
                LOG.info("ArchiveCutoff : '{}' is not before revocation's thisUpdate : '{}'.", (Object)ValidationProcessUtils.getFormattedDate(archiveCutOff), (Object)ValidationProcessUtils.getFormattedDate(this.notAfterRevoc));
            }
        }
        if (expiredCertsOnCRL == null && archiveCutOff == null && (expiredCertsRevocationInfo = this.getExpiredCertsRevocationInfo(this.revocationData)) != null) {
            if (expiredCertsRevocationInfo.before(this.notAfterRevoc)) {
                this.notAfterRevoc = expiredCertsRevocationInfo;
            } else {
                LOG.info("ExpiredCertsRevocationInfo : '{}' is not before revocation's thisUpdate : '{}'.", (Object)ValidationProcessUtils.getFormattedDate(expiredCertsRevocationInfo), (Object)ValidationProcessUtils.getFormattedDate(this.notAfterRevoc));
            }
        }
        this.certHashOK = this.revocationData.isCertHashExtensionPresent() && this.revocationData.isCertHashExtensionMatch();
        return this.checkThisUpdateDefined() && this.checkRevocationDataHasInformationAboutCertificate() && this.checkIssuerKnowsCertificate() && this.checkRevocationIssuerKnown() && this.checkIssuerValidAtProductionTime();
    }

    private Date getExpiredCertsRevocationInfo(RevocationWrapper revocationData) {
        CertificateWrapper revocCert = revocationData.getSigningCertificate();
        if (revocCert != null) {
            return revocCert.getCertificateTSPServiceExpiredCertsRevocationInfo();
        }
        return null;
    }

    private boolean checkThisUpdateDefined() {
        return this.thisUpdate != null;
    }

    private boolean checkRevocationDataHasInformationAboutCertificate() {
        return this.certNotBefore.compareTo(this.thisUpdate) <= 0;
    }

    private boolean checkIssuerKnowsCertificate() {
        return this.checkIssuerHasInformationForExpiredCertificate() || this.checkCertHashMatches();
    }

    private boolean checkIssuerHasInformationForExpiredCertificate() {
        return this.certNotAfter.compareTo(this.notAfterRevoc) >= 0;
    }

    private boolean checkCertHashMatches() {
        return this.certHashOK;
    }

    private boolean checkRevocationIssuerKnown() {
        return this.revocationData.getSigningCertificate() != null;
    }

    private boolean checkIssuerValidAtProductionTime() {
        return !RevocationType.OCSP.equals((Object)this.revocationData.getRevocationType()) || this.checkOCSPResponderValidAtRevocationProductionTime();
    }

    private boolean checkOCSPResponderValidAtRevocationProductionTime() {
        CertificateWrapper revocationIssuer = this.revocationData.getSigningCertificate();
        return this.producedAt.compareTo(revocationIssuer.getNotBefore()) >= 0 && this.producedAt.compareTo(revocationIssuer.getNotAfter()) <= 0;
    }

    private boolean checkRevocationThisUpdateIsInCertificateValidityRange() {
        return this.revocationData.getThisUpdate().compareTo(this.certNotBefore) >= 0 && this.revocationData.getThisUpdate().compareTo(this.certNotAfter) <= 0;
    }

    private boolean checkExpiredCertsOnCRLPresent() {
        return this.revocationData.getExpiredCertsOnCRL() != null;
    }

    private boolean checkArchiveCutOffPresent() {
        return this.revocationData.getArchiveCutOff() != null;
    }

    private boolean checkExpiredCertsRevocationInfoPresent() {
        return this.getExpiredCertsRevocationInfo(this.revocationData) != null;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_XCV_IRDC;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_XCV_IRDC_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.CERTIFICATE_CHAIN_GENERAL_FAILURE;
    }

    @Override
    protected String buildAdditionalInfo() {
        if (!this.checkThisUpdateDefined()) {
            return this.getNoThisUpdateMessage();
        }
        if (!this.checkRevocationDataHasInformationAboutCertificate()) {
            return this.getThisUpdateBeforeCertificateNotBeforeMessage();
        }
        if (!this.checkIssuerKnowsCertificate()) {
            return this.getNotAfterAfterCertificateNotAfterMessage();
        }
        if (!this.checkRevocationIssuerKnown()) {
            return this.getRevocationIssuerNotFoundMessage();
        }
        if (!this.checkIssuerValidAtProductionTime()) {
            return this.getRevocationProducesAtOutOfBoundsMessage();
        }
        if (this.checkRevocationThisUpdateIsInCertificateValidityRange()) {
            return this.getRevocationConsistentMessage();
        }
        if (this.checkCertHashMatches()) {
            return this.getRevocationCertHashOkMessage();
        }
        if (this.checkExpiredCertsOnCRLPresent()) {
            return this.getRevocationConsistentWithExpiredCertsOnCRLMessage();
        }
        if (this.checkArchiveCutOffPresent()) {
            return this.getRevocationConsistentWithArchiveCutoffMessage();
        }
        if (this.checkExpiredCertsRevocationInfoPresent()) {
            return this.getRevocationConsistentWithExpiredCertsRevocationInfoMessage();
        }
        return this.getRevocationInfoMessage();
    }

    protected String getNoThisUpdateMessage() {
        return this.i18nProvider.getMessage(MessageTag.REVOCATION_NO_THIS_UPDATE, new Object[0]);
    }

    protected String getThisUpdateBeforeCertificateNotBeforeMessage() {
        return this.i18nProvider.getMessage(MessageTag.REVOCATION_THIS_UPDATE_BEFORE, ValidationProcessUtils.getFormattedDate(this.thisUpdate), ValidationProcessUtils.getFormattedDate(this.certNotBefore), ValidationProcessUtils.getFormattedDate(this.certNotAfter));
    }

    protected String getNotAfterAfterCertificateNotAfterMessage() {
        return this.i18nProvider.getMessage(MessageTag.REVOCATION_NOT_AFTER_AFTER, ValidationProcessUtils.getFormattedDate(this.notAfterRevoc), ValidationProcessUtils.getFormattedDate(this.certNotBefore), ValidationProcessUtils.getFormattedDate(this.certNotAfter));
    }

    protected String getRevocationIssuerNotFoundMessage() {
        return this.i18nProvider.getMessage(MessageTag.REVOCATION_ISSUER_NOT_FOUND, new Object[0]);
    }

    protected String getRevocationProducesAtOutOfBoundsMessage() {
        return this.i18nProvider.getMessage(MessageTag.REVOCATION_PRODUCED_AT_OUT_OF_BOUNDS, ValidationProcessUtils.getFormattedDate(this.producedAt), ValidationProcessUtils.getFormattedDate(this.revocationData.getSigningCertificate().getNotBefore()), ValidationProcessUtils.getFormattedDate(this.revocationData.getSigningCertificate().getNotAfter()));
    }

    protected String getRevocationCertHashOkMessage() {
        return this.i18nProvider.getMessage(MessageTag.REVOCATION_CERT_HASH_OK, new Object[0]);
    }

    protected String getRevocationConsistentMessage() {
        return this.i18nProvider.getMessage(MessageTag.REVOCATION_CONSISTENT, ValidationProcessUtils.getFormattedDate(this.thisUpdate), ValidationProcessUtils.getFormattedDate(this.certNotBefore), ValidationProcessUtils.getFormattedDate(this.certNotAfter));
    }

    protected String getRevocationConsistentWithExpiredCertsOnCRLMessage() {
        return this.i18nProvider.getMessage(MessageTag.REVOCATION_CONSISTENT_CRL, ValidationProcessUtils.getFormattedDate(this.thisUpdate), ValidationProcessUtils.getFormattedDate(this.revocationData.getExpiredCertsOnCRL()), ValidationProcessUtils.getFormattedDate(this.certNotBefore), ValidationProcessUtils.getFormattedDate(this.certNotAfter));
    }

    protected String getRevocationConsistentWithArchiveCutoffMessage() {
        return this.i18nProvider.getMessage(MessageTag.REVOCATION_CONSISTENT_OCSP, ValidationProcessUtils.getFormattedDate(this.thisUpdate), ValidationProcessUtils.getFormattedDate(this.revocationData.getArchiveCutOff()), ValidationProcessUtils.getFormattedDate(this.certNotBefore), ValidationProcessUtils.getFormattedDate(this.certNotAfter));
    }

    protected String getRevocationConsistentWithExpiredCertsRevocationInfoMessage() {
        return this.i18nProvider.getMessage(MessageTag.REVOCATION_CONSISTENT_TL, ValidationProcessUtils.getFormattedDate(this.thisUpdate), ValidationProcessUtils.getFormattedDate(this.getExpiredCertsRevocationInfo(this.revocationData)), ValidationProcessUtils.getFormattedDate(this.certNotBefore), ValidationProcessUtils.getFormattedDate(this.certNotAfter));
    }

    protected String getRevocationInfoMessage() {
        return this.i18nProvider.getMessage(MessageTag.REVOCATION_INFO, ValidationProcessUtils.getFormattedDate(this.thisUpdate), ValidationProcessUtils.getFormattedDate(this.certNotBefore), ValidationProcessUtils.getFormattedDate(this.certNotAfter));
    }
}

