/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav.cc;

import eu.europa.esig.dss.detailedreport.jaxb.XmlCC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlMessage;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.Level;
import eu.europa.esig.dss.validation.process.bbb.sav.cc.AbstractCryptographicCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.CryptographicConstraintWrapper;
import java.util.Date;

public class DigestAlgorithmAtValidationTimeCheck
extends AbstractCryptographicCheck {
    private final DigestAlgorithm digestAlgo;
    private final Date validationDate;
    private final CryptographicConstraintWrapper constraintWrapper;

    protected DigestAlgorithmAtValidationTimeCheck(I18nProvider i18nProvider, DigestAlgorithm digestAlgo, Date validationDate, XmlCC result, MessageTag position, CryptographicConstraintWrapper constraintWrapper) {
        super(i18nProvider, result, position, constraintWrapper.getAlgoExpirationDateLevel());
        this.digestAlgo = digestAlgo;
        this.validationDate = validationDate;
        this.constraintWrapper = constraintWrapper;
    }

    @Override
    protected boolean process() {
        Date expirationDate = this.constraintWrapper.getExpirationDate(this.digestAlgo);
        return expirationDate == null || !expirationDate.before(this.validationDate);
    }

    @Override
    protected Level getLevel() {
        Date algoExpirationDate = this.constraintWrapper.getExpirationDate(this.digestAlgo);
        Date cryptographicSuiteUpdateDate = this.constraintWrapper.getCryptographicSuiteUpdateDate();
        if (algoExpirationDate != null && cryptographicSuiteUpdateDate != null && cryptographicSuiteUpdateDate.before(algoExpirationDate)) {
            return this.constraintWrapper.getAlgoExpirationDateAfterUpdateLevel();
        }
        return super.getLevel();
    }

    @Override
    protected XmlMessage buildConstraintMessage() {
        return this.buildXmlMessage(MessageTag.ASCCM_AR, this.getName(this.digestAlgo));
    }

    @Override
    protected XmlMessage buildErrorMessage() {
        return this.buildXmlMessage(MessageTag.ASCCM_AR_ANS_ANR, new Object[]{this.getName(this.digestAlgo), this.position});
    }
}

