/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.fc.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlFC;
import eu.europa.esig.dss.diagnostic.PDFRevisionWrapper;
import eu.europa.esig.dss.enumerations.CertificationPermission;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;

public class DocMDPCheck
extends ChainItem<XmlFC> {
    private final PDFRevisionWrapper pdfRevision;

    public DocMDPCheck(I18nProvider i18nProvider, XmlFC result, PDFRevisionWrapper pdfRevision, LevelConstraint constraint) {
        super(i18nProvider, result, constraint);
        this.pdfRevision = pdfRevision;
    }

    @Override
    protected boolean process() {
        if (!this.pdfRevision.arePdfObjectModificationsDetected()) {
            return true;
        }
        CertificationPermission docMDPPermissions = this.pdfRevision.getDocMDPPermissions();
        if (docMDPPermissions == null) {
            return true;
        }
        switch (docMDPPermissions) {
            case NO_CHANGE_PERMITTED: {
                if (!Utils.isCollectionNotEmpty(this.pdfRevision.getPdfSignatureOrFormFillChanges()) && !Utils.isCollectionNotEmpty(this.pdfRevision.getPdfAnnotationChanges()) && !Utils.isCollectionNotEmpty(this.pdfRevision.getPdfUndefinedChanges())) break;
                return false;
            }
            case MINIMAL_CHANGES_PERMITTED: {
                if (!Utils.isCollectionNotEmpty(this.pdfRevision.getPdfAnnotationChanges()) && !Utils.isCollectionNotEmpty(this.pdfRevision.getPdfUndefinedChanges())) break;
                return false;
            }
            case CHANGES_PERMITTED: {
                if (!Utils.isCollectionNotEmpty(this.pdfRevision.getPdfUndefinedChanges())) break;
                return false;
            }
            default: {
                throw new UnsupportedOperationException(String.format("The value '%s' is not supported!", new Object[]{docMDPPermissions}));
            }
        }
        return true;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_FC_ISVADMDPD;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_FC_ISVADMDPD_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.FAILED;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.FORMAT_FAILURE;
    }
}

