/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.executor.signature;

import eu.europa.esig.dss.detailedreport.DetailedReport;
import eu.europa.esig.dss.diagnostic.CertificateRevocationWrapper;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.RelatedRevocationWrapper;
import eu.europa.esig.dss.diagnostic.RevocationWrapper;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.diagnostic.jaxb.XmlLangAndValue;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignatureScope;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTrustedService;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTrustedServiceProvider;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SignatureQualification;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.enumerations.TimestampQualification;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.jaxb.object.Message;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.simplereport.jaxb.XmlCertificate;
import eu.europa.esig.dss.simplereport.jaxb.XmlCertificateChain;
import eu.europa.esig.dss.simplereport.jaxb.XmlDetails;
import eu.europa.esig.dss.simplereport.jaxb.XmlMessage;
import eu.europa.esig.dss.simplereport.jaxb.XmlPDFAInfo;
import eu.europa.esig.dss.simplereport.jaxb.XmlSemantic;
import eu.europa.esig.dss.simplereport.jaxb.XmlSignature;
import eu.europa.esig.dss.simplereport.jaxb.XmlSignatureLevel;
import eu.europa.esig.dss.simplereport.jaxb.XmlSimpleReport;
import eu.europa.esig.dss.simplereport.jaxb.XmlTimestamp;
import eu.europa.esig.dss.simplereport.jaxb.XmlTimestampLevel;
import eu.europa.esig.dss.simplereport.jaxb.XmlTimestamps;
import eu.europa.esig.dss.simplereport.jaxb.XmlTrustAnchor;
import eu.europa.esig.dss.simplereport.jaxb.XmlTrustAnchors;
import eu.europa.esig.dss.simplereport.jaxb.XmlValidationMessages;
import eu.europa.esig.dss.simplereport.jaxb.XmlValidationPolicy;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.vpfswatsp.POEExtraction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class SimpleReportBuilder {
    private final I18nProvider i18nProvider;
    private final boolean includeSemantics;
    private final Date currentTime;
    private final ValidationPolicy policy;
    private final DiagnosticData diagnosticData;
    private final DetailedReport detailedReport;
    private int totalSignatureCount = 0;
    private int validSignatureCount = 0;
    private final Set<Indication> finalIndications = new HashSet<Indication>();
    private final Set<SubIndication> finalSubIndications = new HashSet<SubIndication>();
    private POEExtraction poe;

    public SimpleReportBuilder(I18nProvider i18nProvider, Date currentTime, ValidationPolicy policy, DiagnosticData diagnosticData, DetailedReport detailedReport, boolean includeSemantics) {
        this.currentTime = currentTime;
        this.policy = policy;
        this.diagnosticData = diagnosticData;
        this.detailedReport = detailedReport;
        this.i18nProvider = i18nProvider;
        this.includeSemantics = includeSemantics;
    }

    public XmlSimpleReport build() {
        this.validSignatureCount = 0;
        this.totalSignatureCount = 0;
        this.poe = new POEExtraction();
        this.poe.init(this.diagnosticData, this.diagnosticData.getValidationDate());
        this.poe.collectAllPOE(this.diagnosticData.getTimestampList());
        XmlSimpleReport simpleReport = new XmlSimpleReport();
        this.addPolicyNode(simpleReport);
        this.addValidationTime(simpleReport);
        this.addDocumentName(simpleReport);
        boolean containerInfoPresent = this.diagnosticData.isContainerInfoPresent();
        if (containerInfoPresent) {
            this.addContainerType(simpleReport);
        }
        HashSet<String> attachedTimestampIds = new HashSet<String>();
        for (SignatureWrapper signature : this.diagnosticData.getSignatures()) {
            attachedTimestampIds.addAll(signature.getTimestampIdsList());
            simpleReport.getSignatureOrTimestamp().add(this.getSignature(signature, containerInfoPresent));
        }
        for (TimestampWrapper timestamp : this.diagnosticData.getTimestampList()) {
            if (attachedTimestampIds.contains(timestamp.getId())) continue;
            simpleReport.getSignatureOrTimestamp().add(this.getXmlTimestamp(timestamp));
        }
        this.addStatistics(simpleReport);
        if (this.includeSemantics) {
            this.addSemantics(simpleReport);
        }
        this.addPDFAProfile(simpleReport);
        return simpleReport;
    }

    private void addPolicyNode(XmlSimpleReport report) {
        XmlValidationPolicy xmlPolicy = new XmlValidationPolicy();
        xmlPolicy.setPolicyName(this.policy.getPolicyName());
        xmlPolicy.setPolicyDescription(this.policy.getPolicyDescription());
        report.setValidationPolicy(xmlPolicy);
    }

    private void addValidationTime(XmlSimpleReport report) {
        report.setValidationTime(this.currentTime);
    }

    private void addDocumentName(XmlSimpleReport report) {
        report.setDocumentName(this.diagnosticData.getDocumentName());
    }

    private void addContainerType(XmlSimpleReport simpleReport) {
        simpleReport.setContainerType(this.diagnosticData.getContainerType());
    }

    private void addSemantics(XmlSimpleReport simpleReport) {
        XmlSemantic semantic;
        for (Indication indication : this.finalIndications) {
            semantic = new XmlSemantic();
            semantic.setKey(indication.name());
            semantic.setValue(this.i18nProvider.getMessage(MessageTag.getSemantic(indication.name()), new Object[0]));
            simpleReport.getSemantic().add(semantic);
        }
        for (SubIndication subIndication : this.finalSubIndications) {
            semantic = new XmlSemantic();
            semantic.setKey(subIndication.name());
            semantic.setValue(this.i18nProvider.getMessage(MessageTag.getSemantic(subIndication.name()), new Object[0]));
            simpleReport.getSemantic().add(semantic);
        }
    }

    private void addStatistics(XmlSimpleReport simpleReport) {
        simpleReport.setValidSignaturesCount(this.validSignatureCount);
        simpleReport.setSignaturesCount(this.totalSignatureCount);
    }

    private void addPDFAProfile(XmlSimpleReport simpleReport) {
        String pdfaProfileId = this.diagnosticData.getPDFAProfileId();
        if (pdfaProfileId != null) {
            XmlPDFAInfo xmlPDFAInfo = new XmlPDFAInfo();
            xmlPDFAInfo.setPDFAProfile(pdfaProfileId);
            xmlPDFAInfo.setValid(this.diagnosticData.isPDFACompliant());
            if (Utils.isCollectionNotEmpty(this.diagnosticData.getPDFAValidationErrors())) {
                xmlPDFAInfo.setValidationMessages(this.toXmlValidationMessages(this.diagnosticData.getPDFAValidationErrors()));
            }
            simpleReport.setPDFAInfo(xmlPDFAInfo);
        }
    }

    private XmlValidationMessages toXmlValidationMessages(Collection<String> errors) {
        XmlValidationMessages xmlValidationMessages = new XmlValidationMessages();
        xmlValidationMessages.getError().addAll(errors);
        return xmlValidationMessages;
    }

    private XmlSignature getSignature(SignatureWrapper signature, boolean container) {
        XmlDetails qualificationDetails;
        XmlDetails validationDetails;
        ++this.totalSignatureCount;
        String signatureId = signature.getId();
        XmlSignature xmlSignature = new XmlSignature();
        xmlSignature.setId(signatureId);
        this.addCounterSignature(signature, xmlSignature);
        this.addSignatureScope(signature, xmlSignature);
        this.addSigningTime(signature, xmlSignature);
        this.addBestSignatureTime(signature, xmlSignature);
        this.addSignatureFormat(signature, xmlSignature);
        CertificateWrapper signingCertificate = signature.getSigningCertificate();
        if (signingCertificate != null) {
            xmlSignature.setSignedBy(this.getReadableCertificateName(signingCertificate.getId()));
        }
        if (this.isNotEmpty(validationDetails = this.getAdESValidationDetails(signatureId))) {
            xmlSignature.setAdESValidationDetails(validationDetails);
        }
        if (this.isNotEmpty(qualificationDetails = this.getQualificationDetails(signatureId))) {
            xmlSignature.setQualificationDetails(qualificationDetails);
        }
        if (container) {
            xmlSignature.setFilename(signature.getSignatureFilename());
        }
        Indication indication = this.detailedReport.getFinalIndication(signatureId);
        SubIndication subIndication = this.detailedReport.getFinalSubIndication(signatureId);
        if (Indication.TOTAL_PASSED.equals(indication)) {
            this.determineExtensionPeriod(xmlSignature);
            ++this.validSignatureCount;
        } else if (Indication.INDETERMINATE.equals(indication) && SubIndication.TRY_LATER.equals(subIndication)) {
            this.determineExtensionPeriod(xmlSignature);
        }
        xmlSignature.setIndication(indication);
        this.finalIndications.add(indication);
        if (subIndication != null) {
            xmlSignature.setSubIndication(subIndication);
            this.finalSubIndications.add(subIndication);
        }
        this.addSignatureProfile(xmlSignature);
        xmlSignature.setCertificateChain(this.getCertChain(signatureId));
        List<TimestampWrapper> timestampList = signature.getTimestampList();
        if (Utils.isCollectionNotEmpty(timestampList)) {
            XmlTimestamps xmlTimestamps = new XmlTimestamps();
            for (TimestampWrapper timestamp : timestampList) {
                Indication tstValidationIndication = this.detailedReport.getTimestampValidationIndication(timestamp.getId());
                if (tstValidationIndication == null) continue;
                xmlTimestamps.getTimestamp().add(this.getXmlTimestamp(timestamp));
            }
            if (Utils.isCollectionNotEmpty(xmlTimestamps.getTimestamp())) {
                xmlSignature.setTimestamps(xmlTimestamps);
            }
        }
        return xmlSignature;
    }

    private XmlDetails getAdESValidationDetails(String tokenId) {
        XmlDetails validationDetails = new XmlDetails();
        validationDetails.getError().addAll(this.convert(this.detailedReport.getAdESValidationErrors(tokenId)));
        validationDetails.getWarning().addAll(this.convert(this.detailedReport.getAdESValidationWarnings(tokenId)));
        validationDetails.getInfo().addAll(this.convert(this.detailedReport.getAdESValidationInfos(tokenId)));
        return validationDetails;
    }

    private XmlDetails getQualificationDetails(String tokenId) {
        XmlDetails qualificationDetails = new XmlDetails();
        qualificationDetails.getError().addAll(this.convert(this.detailedReport.getQualificationErrors(tokenId)));
        qualificationDetails.getWarning().addAll(this.convert(this.detailedReport.getQualificationWarnings(tokenId)));
        qualificationDetails.getInfo().addAll(this.convert(this.detailedReport.getQualificationInfos(tokenId)));
        return qualificationDetails;
    }

    private boolean isNotEmpty(XmlDetails details) {
        return Utils.isCollectionNotEmpty(details.getError()) || Utils.isCollectionNotEmpty(details.getWarning()) || Utils.isCollectionNotEmpty(details.getInfo());
    }

    private List<XmlMessage> convert(Collection<Message> messages) {
        return messages.stream().map(m4 -> {
            XmlMessage xmlMessage = new XmlMessage();
            xmlMessage.setKey(m4.getKey());
            xmlMessage.setValue(m4.getValue());
            return xmlMessage;
        }).collect(Collectors.toList());
    }

    private XmlCertificateChain getCertChain(String tokenId) {
        List<String> certIds = this.detailedReport.getBasicBuildingBlocksCertChain(tokenId);
        XmlCertificateChain xmlCertificateChain = new XmlCertificateChain();
        if (Utils.isCollectionNotEmpty(certIds)) {
            for (String certId : certIds) {
                XmlCertificate certificate = new XmlCertificate();
                certificate.setId(certId);
                certificate.setQualifiedName(this.getReadableCertificateName(certId));
                if (this.isTrustAnchor(certId)) {
                    certificate.setTrusted(true);
                    certificate.setTrustAnchors(this.getXmlTrustAnchors(certId));
                }
                xmlCertificateChain.getCertificate().add(certificate);
            }
        }
        return xmlCertificateChain;
    }

    private XmlTrustAnchors getXmlTrustAnchors(String certId) {
        List<XmlTrustedServiceProvider> xmlTrustedServiceProviders = this.filterByCertificateId(certId);
        if (Utils.isCollectionNotEmpty(xmlTrustedServiceProviders)) {
            XmlTrustAnchors xmlTrustAnchors = new XmlTrustAnchors();
            for (XmlTrustedServiceProvider trustedServiceProvider : xmlTrustedServiceProviders) {
                XmlTrustAnchor trustAnchor = new XmlTrustAnchor();
                trustAnchor.setCountryCode(trustedServiceProvider.getTL().getCountryCode());
                trustAnchor.setTSLType(trustedServiceProvider.getTL().getTSLType());
                trustAnchor.setTrustServiceProvider(this.getEnOrFirst(trustedServiceProvider.getTSPNames()));
                List<String> tspRegistrationIdentifiers = trustedServiceProvider.getTSPRegistrationIdentifiers();
                if (Utils.isCollectionNotEmpty(tspRegistrationIdentifiers)) {
                    trustAnchor.setTrustServiceProviderRegistrationId(tspRegistrationIdentifiers.get(0));
                }
                trustAnchor.getTrustServiceName().addAll(this.getUniqueServiceNames(trustedServiceProvider));
                xmlTrustAnchors.getTrustAnchor().add(trustAnchor);
            }
            return xmlTrustAnchors;
        }
        return null;
    }

    private Set<String> getUniqueServiceNames(XmlTrustedServiceProvider trustedServiceProvider) {
        HashSet<String> result = new HashSet<String>();
        for (XmlTrustedService xmlTrustedService : trustedServiceProvider.getTrustedServices()) {
            result.add(this.getEnOrFirst(xmlTrustedService.getServiceNames()));
        }
        return result;
    }

    private String getEnOrFirst(List<XmlLangAndValue> langAndValues) {
        if (Utils.isCollectionNotEmpty(langAndValues)) {
            for (XmlLangAndValue langAndValue : langAndValues) {
                if (langAndValue.getLang() == null || !"en".equalsIgnoreCase(langAndValue.getLang())) continue;
                return langAndValue.getValue();
            }
            return langAndValues.get(0).getValue();
        }
        return null;
    }

    private List<XmlTrustedServiceProvider> filterByCertificateId(String certId) {
        CertificateWrapper certificate = this.diagnosticData.getCertificateById(certId);
        ArrayList<XmlTrustedServiceProvider> result = new ArrayList<XmlTrustedServiceProvider>();
        for (XmlTrustedServiceProvider xmlTrustedServiceProvider : certificate.getTrustServiceProviders()) {
            List<XmlTrustedService> trustedServices = xmlTrustedServiceProvider.getTrustedServices();
            boolean foundCertId = false;
            for (XmlTrustedService xmlTrustedService : trustedServices) {
                if (!Utils.areStringsEqual(certId, xmlTrustedService.getServiceDigitalIdentifier().getId())) continue;
                foundCertId = true;
                break;
            }
            if (!foundCertId) continue;
            result.add(xmlTrustedServiceProvider);
        }
        return result;
    }

    private void addBestSignatureTime(SignatureWrapper signature, XmlSignature xmlSignature) {
        xmlSignature.setBestSignatureTime(this.detailedReport.getBestSignatureTime(signature.getId()));
    }

    private void addCounterSignature(SignatureWrapper signature, XmlSignature xmlSignature) {
        if (signature.isCounterSignature()) {
            xmlSignature.setCounterSignature(true);
            xmlSignature.setParentId(signature.getParent().getId());
        }
    }

    private void addSignatureScope(SignatureWrapper signature, XmlSignature xmlSignature) {
        List<XmlSignatureScope> signatureScopes = signature.getSignatureScopes();
        if (Utils.isCollectionNotEmpty(signatureScopes)) {
            for (XmlSignatureScope signatureScope : signatureScopes) {
                xmlSignature.getSignatureScope().add(this.getXmlSignatureScope(signatureScope));
            }
        }
    }

    private eu.europa.esig.dss.simplereport.jaxb.XmlSignatureScope getXmlSignatureScope(XmlSignatureScope signatureScope) {
        eu.europa.esig.dss.simplereport.jaxb.XmlSignatureScope xmlSignatureScope = new eu.europa.esig.dss.simplereport.jaxb.XmlSignatureScope();
        xmlSignatureScope.setId(signatureScope.getSignerData().getId());
        xmlSignatureScope.setName(signatureScope.getName());
        xmlSignatureScope.setScope(signatureScope.getScope().name());
        xmlSignatureScope.setValue(signatureScope.getDescription());
        return xmlSignatureScope;
    }

    private void addSigningTime(SignatureWrapper signature, XmlSignature xmlSignature) {
        xmlSignature.setSigningTime(signature.getClaimedSigningTime());
    }

    private void addSignatureFormat(SignatureWrapper signature, XmlSignature xmlSignature) {
        xmlSignature.setSignatureFormat(signature.getSignatureFormat());
    }

    private String getReadableCertificateName(String certId) {
        CertificateWrapper certificateWrapper = this.diagnosticData.getUsedCertificateByIdNullSafe(certId);
        return certificateWrapper.getReadableCertificateName();
    }

    private boolean isTrustAnchor(String certId) {
        CertificateWrapper certificateWrapper = this.diagnosticData.getUsedCertificateByIdNullSafe(certId);
        return certificateWrapper.isTrusted();
    }

    private void addSignatureProfile(XmlSignature xmlSignature) {
        SignatureQualification qualification = this.detailedReport.getSignatureQualification(xmlSignature.getId());
        if (qualification != null) {
            XmlSignatureLevel sigLevel = new XmlSignatureLevel();
            sigLevel.setValue(qualification);
            sigLevel.setDescription(qualification.getLabel());
            xmlSignature.setSignatureLevel(sigLevel);
        }
    }

    private XmlTimestamp getXmlTimestamp(TimestampWrapper timestampWrapper) {
        XmlDetails qualificationDetails;
        XmlDetails validationDetails;
        TimestampQualification timestampQualification;
        XmlTimestamp xmlTimestamp = new XmlTimestamp();
        String timestampId = timestampWrapper.getId();
        xmlTimestamp.setId(timestampId);
        xmlTimestamp.setProductionTime(timestampWrapper.getProductionTime());
        xmlTimestamp.setProducedBy(this.getProducedByName(timestampWrapper));
        xmlTimestamp.setCertificateChain(this.getCertChain(timestampId));
        xmlTimestamp.setFilename(timestampWrapper.getFilename());
        Indication indication = this.detailedReport.getFinalIndication(timestampId);
        xmlTimestamp.setIndication(indication);
        this.finalIndications.add(indication);
        SubIndication subIndication = this.detailedReport.getFinalSubIndication(timestampId);
        if (subIndication != null) {
            xmlTimestamp.setSubIndication(subIndication);
            this.finalSubIndications.add(subIndication);
        }
        if ((timestampQualification = this.detailedReport.getTimestampQualification(timestampId)) != null) {
            XmlTimestampLevel xmlTimestampLevel = new XmlTimestampLevel();
            xmlTimestampLevel.setValue(timestampQualification);
            xmlTimestampLevel.setDescription(timestampQualification.getLabel());
            xmlTimestamp.setTimestampLevel(xmlTimestampLevel);
        }
        if (this.isNotEmpty(validationDetails = this.getAdESValidationDetails(timestampId))) {
            xmlTimestamp.setAdESValidationDetails(validationDetails);
        }
        if (this.isNotEmpty(qualificationDetails = this.getQualificationDetails(timestampId))) {
            xmlTimestamp.setQualificationDetails(qualificationDetails);
        }
        if (Utils.isCollectionNotEmpty(timestampWrapper.getTimestampScopes())) {
            for (XmlSignatureScope timestampScope : timestampWrapper.getTimestampScopes()) {
                xmlTimestamp.getTimestampScope().add(this.getXmlSignatureScope(timestampScope));
            }
        }
        return xmlTimestamp;
    }

    private String getProducedByName(TimestampWrapper timestampWrapper) {
        CertificateWrapper signingCertificate = timestampWrapper.getSigningCertificate();
        if (signingCertificate != null) {
            return signingCertificate.getReadableCertificateName();
        }
        return "";
    }

    private void determineExtensionPeriod(XmlSignature xmlSignature) {
        SignatureWrapper signatureWrapper = this.diagnosticData.getSignatureById(xmlSignature.getId());
        xmlSignature.setExtensionPeriodMin(this.getMinExtensionPeriod(signatureWrapper));
        xmlSignature.setExtensionPeriodMax(this.getMaxExtensionPeriod(signatureWrapper));
    }

    private Date getMinExtensionPeriod(SignatureWrapper signatureWrapper) {
        Date min2 = null;
        ArrayList<List<CertificateWrapper>> chains = new ArrayList<List<CertificateWrapper>>();
        chains.add(signatureWrapper.getCertificateChain());
        List<RelatedRevocationWrapper> relatedRevocations = signatureWrapper.foundRevocations().getRelatedRevocationData();
        for (RevocationWrapper revocationWrapper : relatedRevocations) {
            chains.add(revocationWrapper.getCertificateChain());
        }
        for (List list : chains) {
            Date certChainMin = this.getMinExtensionPeriodForChain(list, null);
            if (certChainMin == null || min2 != null && !min2.before(certChainMin)) continue;
            min2 = certChainMin;
        }
        List<TimestampWrapper> timestampList = signatureWrapper.getTimestampList();
        for (TimestampWrapper timestampWrapper : timestampList) {
            Date certChainMin = this.getMinExtensionPeriodForChain(timestampWrapper.getCertificateChain(), timestampWrapper.getProductionTime());
            if (certChainMin == null || min2 != null && !min2.before(certChainMin)) continue;
            min2 = certChainMin;
        }
        return min2;
    }

    private Date getMinExtensionPeriodForChain(List<CertificateWrapper> certificateChain, Date usageTime) {
        Date min2 = null;
        for (CertificateWrapper certificateWrapper : certificateChain) {
            if (!ValidationProcessUtils.isRevocationCheckRequired(certificateWrapper)) continue;
            Date lastTrustedUsage = usageTime != null ? usageTime : this.poe.getLowestPOETime(certificateWrapper.getId());
            Date tempMin = null;
            boolean goodRevocationFound = false;
            List<CertificateRevocationWrapper> certificateRevocationData = certificateWrapper.getCertificateRevocationData();
            for (CertificateRevocationWrapper revocationData : certificateRevocationData) {
                if (lastTrustedUsage.before(revocationData.getThisUpdate())) {
                    goodRevocationFound = true;
                    break;
                }
                Date nextUpdate = revocationData.getNextUpdate();
                if (nextUpdate == null) {
                    nextUpdate = new Date(lastTrustedUsage.getTime() + 1000L);
                }
                if (tempMin != null && !tempMin.after(nextUpdate)) continue;
                tempMin = nextUpdate;
            }
            if (goodRevocationFound || tempMin == null || min2 != null && !min2.before(tempMin)) continue;
            min2 = tempMin;
        }
        return min2;
    }

    private Date getMaxExtensionPeriod(SignatureWrapper signatureWrapper) {
        Date max = null;
        CertificateWrapper signingCertificate = signatureWrapper.getSigningCertificate();
        if (signingCertificate != null) {
            max = signingCertificate.getNotAfter();
        }
        List<TimestampWrapper> timestampList = signatureWrapper.getAllTimestampsProducedAfterSignatureCreation();
        for (TimestampWrapper timestampWrapper : timestampList) {
            if (!timestampWrapper.isSignatureValid()) continue;
            CertificateWrapper timestampSigningCertificate = timestampWrapper.getSigningCertificate();
            List<SignatureWrapper> timestampedSignatures = timestampWrapper.getTimestampedSignatures();
            if (timestampSigningCertificate == null || !timestampedSignatures.contains(signatureWrapper) || !timestampSigningCertificate.getNotAfter().after(max)) continue;
            max = timestampSigningCertificate.getNotAfter();
        }
        return max;
    }
}

