/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.executor.certificate;

import eu.europa.esig.dss.detailedreport.DetailedReport;
import eu.europa.esig.dss.detailedreport.jaxb.XmlDetailedReport;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.simplecertificatereport.jaxb.XmlSimpleCertificateReport;
import eu.europa.esig.dss.validation.executor.AbstractProcessExecutor;
import eu.europa.esig.dss.validation.executor.certificate.CertificateProcessExecutor;
import eu.europa.esig.dss.validation.executor.certificate.DetailedReportForCertificateBuilder;
import eu.europa.esig.dss.validation.executor.certificate.SimpleReportForCertificateBuilder;
import eu.europa.esig.dss.validation.reports.CertificateReports;
import java.util.Objects;

public class DefaultCertificateProcessExecutor
extends AbstractProcessExecutor
implements CertificateProcessExecutor {
    private String certificateId;

    @Override
    public void setCertificateId(String certificateId) {
        this.certificateId = certificateId;
    }

    @Override
    public CertificateReports execute() {
        this.assertConfigurationValid();
        Objects.requireNonNull(this.certificateId, "The certificate id is missing");
        DiagnosticData diagnosticData = new DiagnosticData(this.jaxbDiagnosticData);
        DetailedReportForCertificateBuilder detailedReportBuilder = new DetailedReportForCertificateBuilder(this.getI18nProvider(), diagnosticData, this.policy, this.currentTime, this.certificateId);
        XmlDetailedReport detailedReport = detailedReportBuilder.build();
        SimpleReportForCertificateBuilder simpleReportBuilder = new SimpleReportForCertificateBuilder(diagnosticData, new DetailedReport(detailedReport), this.policy, this.currentTime, this.certificateId);
        XmlSimpleCertificateReport simpleReport = simpleReportBuilder.build();
        return new CertificateReports(this.jaxbDiagnosticData, detailedReport, simpleReport);
    }
}

