/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestAlgoAndValue;
import eu.europa.esig.dss.diagnostic.jaxb.XmlPolicy;
import eu.europa.esig.dss.diagnostic.jaxb.XmlPolicyDigestAlgoAndValue;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSPDocSpecification;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignaturePolicyStore;
import eu.europa.esig.dss.diagnostic.jaxb.XmlUserNotice;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.SignaturePolicyStore;
import eu.europa.esig.dss.model.SpDocSpecification;
import eu.europa.esig.dss.model.UserNotice;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.SignaturePolicy;
import eu.europa.esig.dss.validation.policy.SignaturePolicyValidationResult;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class XmlPolicyBuilder {
    private final SignaturePolicy signaturePolicy;
    private final SignaturePolicyValidationResult validationResult;
    private SignaturePolicyStore signaturePolicyStore;

    public XmlPolicyBuilder(SignaturePolicy signaturePolicy, SignaturePolicyValidationResult validationResult) {
        Objects.requireNonNull(signaturePolicy, "SignaturePolicy cannot be null!");
        Objects.requireNonNull(validationResult, "The result of a signature policy validation cannot be null!");
        this.signaturePolicy = signaturePolicy;
        this.validationResult = validationResult;
    }

    public XmlPolicyBuilder setSignaturePolicyStore(SignaturePolicyStore signaturePolicyStore) {
        this.signaturePolicyStore = signaturePolicyStore;
        return this;
    }

    public XmlPolicy build() {
        List<String> transformsDescription;
        SpDocSpecification spDocSpecification;
        XmlPolicy xmlPolicy = new XmlPolicy();
        xmlPolicy.setId(this.signaturePolicy.getIdentifier());
        xmlPolicy.setDescription(this.signaturePolicy.getDescription());
        xmlPolicy.setDocumentationReferences(this.signaturePolicy.getDocumentationReferences());
        xmlPolicy.setUrl(DSSUtils.removeControlCharacters(this.signaturePolicy.getUri()));
        UserNotice userNotice = this.signaturePolicy.getUserNotice();
        if (userNotice != null) {
            XmlUserNotice xmlUserNotice = new XmlUserNotice();
            xmlUserNotice.setOrganization(userNotice.getOrganization());
            if (userNotice.getNoticeNumbers() != null && userNotice.getNoticeNumbers().length > 0) {
                xmlUserNotice.getNoticeNumbers().addAll(DSSUtils.toBigIntegerList(userNotice.getNoticeNumbers()));
            }
            xmlUserNotice.setExplicitText(userNotice.getExplicitText());
            xmlPolicy.setUserNotice(xmlUserNotice);
        }
        if ((spDocSpecification = this.signaturePolicy.getDocSpecification()) != null) {
            XmlSPDocSpecification xmlSPDocSpecification = new XmlSPDocSpecification();
            xmlSPDocSpecification.setId(spDocSpecification.getId());
            xmlSPDocSpecification.setDescription(spDocSpecification.getDescription());
            Object[] documentationReferences = spDocSpecification.getDocumentationReferences();
            if (Utils.isArrayNotEmpty(documentationReferences)) {
                xmlSPDocSpecification.setDocumentationReferences(Arrays.asList(documentationReferences));
            }
            xmlPolicy.setDocSpecification(xmlSPDocSpecification);
        }
        if (Utils.isCollectionNotEmpty(transformsDescription = this.signaturePolicy.getTransformsDescription())) {
            xmlPolicy.setTransformations(transformsDescription);
        }
        XmlPolicyDigestAlgoAndValue xmlPolicyDigestAlgoAndValue = new XmlPolicyDigestAlgoAndValue();
        if (this.signaturePolicy.isZeroHash()) {
            xmlPolicyDigestAlgoAndValue.setZeroHash(this.signaturePolicy.isZeroHash());
        } else {
            xmlPolicyDigestAlgoAndValue.setDigestAlgorithmsEqual(this.validationResult.isDigestAlgorithmsEqual());
        }
        Digest digest = this.signaturePolicy.getDigest();
        if (digest != null) {
            XmlDigestAlgoAndValue xmlDigestAlgoAndValue = this.getXmlDigestAlgoAndValue(digest);
            xmlPolicyDigestAlgoAndValue.setDigestMethod(xmlDigestAlgoAndValue.getDigestMethod());
            xmlPolicyDigestAlgoAndValue.setDigestValue(xmlDigestAlgoAndValue.getDigestValue());
        }
        xmlPolicyDigestAlgoAndValue.setMatch(this.validationResult.isDigestValid());
        xmlPolicy.setDigestAlgoAndValue(xmlPolicyDigestAlgoAndValue);
        xmlPolicy.setAsn1Processable(this.validationResult.isAsn1Processable());
        xmlPolicy.setIdentified(this.validationResult.isIdentified());
        if (Utils.isStringNotBlank(this.validationResult.getProcessingErrors())) {
            xmlPolicy.setProcessingError(this.validationResult.getProcessingErrors());
        }
        return xmlPolicy;
    }

    public XmlSignaturePolicyStore buildSignaturePolicyStore() {
        Digest recalculatedDigest;
        DSSDocument signaturePolicyContent;
        if (this.signaturePolicyStore == null) {
            return null;
        }
        XmlSignaturePolicyStore xmlSignaturePolicyStore = new XmlSignaturePolicyStore();
        SpDocSpecification spDocSpecification = this.signaturePolicyStore.getSpDocSpecification();
        if (spDocSpecification != null) {
            xmlSignaturePolicyStore.setId(spDocSpecification.getId());
            xmlSignaturePolicyStore.setDescription(spDocSpecification.getDescription());
            Object[] documentationReferences = spDocSpecification.getDocumentationReferences();
            if (Utils.isArrayNotEmpty(documentationReferences)) {
                xmlSignaturePolicyStore.setDocumentationReferences(Arrays.asList(documentationReferences));
            }
        }
        if ((signaturePolicyContent = this.signaturePolicyStore.getSignaturePolicyContent()) != null && (recalculatedDigest = this.validationResult.getDigest()) != null) {
            xmlSignaturePolicyStore.setDigestAlgoAndValue(this.getXmlDigestAlgoAndValue(recalculatedDigest));
        }
        xmlSignaturePolicyStore.setSigPolDocLocalURI(this.signaturePolicyStore.getSigPolDocLocalURI());
        return xmlSignaturePolicyStore;
    }

    private XmlDigestAlgoAndValue getXmlDigestAlgoAndValue(Digest digest) {
        XmlDigestAlgoAndValue xmlDigestAlgAndValue = new XmlDigestAlgoAndValue();
        xmlDigestAlgAndValue.setDigestMethod(digest.getAlgorithm());
        xmlDigestAlgAndValue.setDigestValue(digest.getValue() == null ? DSSUtils.EMPTY_BYTE_ARRAY : digest.getValue());
        return xmlDigestAlgAndValue;
    }
}

