/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.enumerations.CertificateExtensionEnum;
import eu.europa.esig.dss.enumerations.CertificatePolicy;
import eu.europa.esig.dss.enumerations.ExtendedKeyUsage;
import eu.europa.esig.dss.enumerations.OidDescription;
import eu.europa.esig.dss.enumerations.QCStatement;
import java.util.HashMap;
import java.util.Map;

public class OidRepository {
    private static final Map<String, String> repository = new HashMap<String, String>();

    static void addToRepository(OidDescription ... oidDescriptions) {
        for (OidDescription oid : oidDescriptions) {
            repository.put(oid.getOid(), oid.getDescription());
        }
    }

    private OidRepository() {
    }

    public static String getDescription(String oid) {
        return repository.get(oid);
    }

    static {
        OidRepository.addToRepository(CertificatePolicy.values());
        OidRepository.addToRepository(QCStatement.values());
        OidRepository.addToRepository(ExtendedKeyUsage.values());
        OidRepository.addToRepository(CertificateExtensionEnum.values());
    }
}

