/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.parsing;

import eu.europa.esig.dss.enumerations.TSLType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.tsl.parsing.AbstractParsingResult;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.trustedlist.TrustedListFacade;
import eu.europa.esig.trustedlist.jaxb.tsl.NextUpdateType;
import eu.europa.esig.trustedlist.jaxb.tsl.NonEmptyURIListType;
import eu.europa.esig.trustedlist.jaxb.tsl.TSLSchemeInformationType;
import eu.europa.esig.trustedlist.jaxb.tsl.TrustStatusListType;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Objects;
import java.util.function.Supplier;
import javax.xml.datatype.XMLGregorianCalendar;

public abstract class AbstractParsingTask<T extends AbstractParsingResult>
implements Supplier<T> {
    private final DSSDocument document;

    protected AbstractParsingTask(DSSDocument document) {
        Objects.requireNonNull(document, "The document is null");
        this.document = document;
    }

    protected TrustStatusListType getJAXBObject() {
        TrustStatusListType trustStatusListType;
        block9: {
            InputStream is = this.document.openStream();
            try {
                trustStatusListType = (TrustStatusListType)this.createTrustedListFacade().unmarshall(is);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    String message = "Unable to parse binaries. Reason : '%s'";
                    if (e.getMessage() == null && e.getCause() != null) {
                        throw new DSSException(String.format(message, e.getCause().getMessage()), e);
                    }
                    throw new DSSException(String.format(message, e.getMessage()), e);
                }
            }
            is.close();
        }
        return trustStatusListType;
    }

    protected TrustedListFacade createTrustedListFacade() {
        return TrustedListFacade.newFacade();
    }

    protected void commonParseSchemeInformation(AbstractParsingResult result, TSLSchemeInformationType schemeInformation) {
        this.extractTSLType(result, schemeInformation);
        this.extractSequenceNumber(result, schemeInformation);
        this.extractTerritory(result, schemeInformation);
        this.extractVersion(result, schemeInformation);
        this.extractIssueDate(result, schemeInformation);
        this.extractNextUpdateDate(result, schemeInformation);
        this.extractDistributionPoints(result, schemeInformation);
    }

    private void extractTSLType(AbstractParsingResult result, TSLSchemeInformationType schemeInformation) {
        String tslType = schemeInformation.getTSLType();
        if (Utils.isStringNotEmpty(tslType)) {
            result.setTSLType(TSLType.fromUri(tslType));
        }
    }

    private void extractSequenceNumber(AbstractParsingResult result, TSLSchemeInformationType schemeInformation) {
        BigInteger tslSequenceNumber = schemeInformation.getTSLSequenceNumber();
        if (tslSequenceNumber != null) {
            result.setSequenceNumber(tslSequenceNumber.intValue());
        }
    }

    private void extractTerritory(AbstractParsingResult result, TSLSchemeInformationType schemeInformation) {
        result.setTerritory(schemeInformation.getSchemeTerritory());
    }

    private void extractVersion(AbstractParsingResult result, TSLSchemeInformationType schemeInformation) {
        BigInteger tslVersionIdentifier = schemeInformation.getTSLVersionIdentifier();
        if (tslVersionIdentifier != null) {
            result.setVersion(tslVersionIdentifier.intValue());
        }
    }

    private void extractIssueDate(AbstractParsingResult result, TSLSchemeInformationType schemeInformation) {
        result.setIssueDate(this.convertToDate(schemeInformation.getListIssueDateTime()));
    }

    private void extractNextUpdateDate(AbstractParsingResult result, TSLSchemeInformationType schemeInformation) {
        NextUpdateType nextUpdate = schemeInformation.getNextUpdate();
        if (nextUpdate != null) {
            result.setNextUpdateDate(this.convertToDate(nextUpdate.getDateTime()));
        }
    }

    private Date convertToDate(XMLGregorianCalendar gregorianCalendar) {
        GregorianCalendar toGregorianCalendar;
        if (gregorianCalendar != null && (toGregorianCalendar = gregorianCalendar.toGregorianCalendar()) != null) {
            return toGregorianCalendar.getTime();
        }
        return null;
    }

    private void extractDistributionPoints(AbstractParsingResult result, TSLSchemeInformationType schemeInformation) {
        NonEmptyURIListType distributionPoints = schemeInformation.getDistributionPoints();
        if (distributionPoints != null && Utils.isCollectionNotEmpty(distributionPoints.getURI())) {
            result.setDistributionPoints(Collections.unmodifiableList(distributionPoints.getURI()));
        } else {
            result.setDistributionPoints(Collections.emptyList());
        }
    }
}

