/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.function.converter;

import eu.europa.esig.dss.spi.tsl.CertificateContentEquivalence;
import eu.europa.esig.dss.spi.tsl.Condition;
import eu.europa.esig.dss.spi.tsl.QCStatementOids;
import eu.europa.esig.dss.spi.tsl.ServiceEquivalence;
import eu.europa.esig.dss.spi.tsl.ServiceTypeASi;
import eu.europa.esig.dss.spi.util.MutableTimeDependentValues;
import eu.europa.esig.dss.tsl.dto.condition.CompositeCondition;
import eu.europa.esig.dss.tsl.dto.condition.QCStatementCondition;
import eu.europa.esig.dss.tsl.function.converter.CriteriaListConverter;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.trustedlist.jaxb.ecc.CriteriaListType;
import eu.europa.esig.trustedlist.jaxb.ecc.QualifierType;
import eu.europa.esig.trustedlist.jaxb.mra.CertificateContentReferenceEquivalenceType;
import eu.europa.esig.trustedlist.jaxb.mra.CertificateContentReferencesEquivalenceListType;
import eu.europa.esig.trustedlist.jaxb.mra.QualifierEquivalenceListType;
import eu.europa.esig.trustedlist.jaxb.mra.QualifierEquivalenceType;
import eu.europa.esig.trustedlist.jaxb.mra.TrustServiceEquivalenceHistoryInstanceType;
import eu.europa.esig.trustedlist.jaxb.mra.TrustServiceEquivalenceHistoryType;
import eu.europa.esig.trustedlist.jaxb.mra.TrustServiceEquivalenceInformationType;
import eu.europa.esig.trustedlist.jaxb.mra.TrustServiceTSLQualificationExtensionEquivalenceListType;
import eu.europa.esig.trustedlist.jaxb.mra.TrustServiceTSLStatusEquivalenceListType;
import eu.europa.esig.trustedlist.jaxb.mra.TrustServiceTSLStatusEquivalenceType;
import eu.europa.esig.trustedlist.jaxb.mra.TrustServiceTSLStatusList;
import eu.europa.esig.trustedlist.jaxb.mra.TrustServiceTSLTypeEquivalenceListType;
import eu.europa.esig.trustedlist.jaxb.mra.TrustServiceTSLTypeListType;
import eu.europa.esig.trustedlist.jaxb.mra.TrustServiceTSLTypeType;
import eu.europa.esig.trustedlist.jaxb.tsl.AdditionalServiceInformationType;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustServiceEquivalenceConverter
implements Function<TrustServiceEquivalenceInformationType, MutableTimeDependentValues<ServiceEquivalence>> {
    private static final Logger LOG = LoggerFactory.getLogger(TrustServiceEquivalenceConverter.class);
    private final CriteriaListConverter criteriaConverter = new CriteriaListConverter();

    @Override
    public MutableTimeDependentValues<ServiceEquivalence> apply(TrustServiceEquivalenceInformationType t2) {
        MutableTimeDependentValues<ServiceEquivalence> result = new MutableTimeDependentValues<ServiceEquivalence>();
        ServiceEquivalence serviceEquivalence = new ServiceEquivalence.ServiceEquivalenceBuilder().setLegalInfoIdentifier(t2.getTrustServiceLegalIdentifier()).setStartDate(t2.getTrustServiceEquivalenceStatusStartingTime().toGregorianCalendar().getTime()).setStatus(t2.getTrustServiceEquivalenceStatus()).setTypeAsiEquivalence(this.getTypeASiEquivalence(t2.getTrustServiceTSLTypeEquivalenceList())).setStatusEquivalence(this.getStatusEquivalence(t2.getTrustServiceTSLStatusEquivalenceList())).setCertificateContentEquivalences(this.getCertificateEquivalence(t2.getCertificateContentReferencesEquivalenceList())).setQualifierEquivalence(this.getQualifierEquivalence(t2.getTrustServiceTSLQualificationExtensionEquivalenceList())).build();
        result.addOldest(serviceEquivalence);
        Date oldestStartDate = serviceEquivalence.getStartDate();
        for (TrustServiceEquivalenceHistoryType trustServiceEquivalenceHistory : t2.getTrustServiceEquivalenceHistory()) {
            for (TrustServiceEquivalenceHistoryInstanceType h2 : trustServiceEquivalenceHistory.getTrustServiceEquivalenceHistoryInstance()) {
                ServiceEquivalence historyServiceEquivalence = new ServiceEquivalence.ServiceEquivalenceBuilder().setLegalInfoIdentifier(serviceEquivalence.getLegalInfoIdentifier()).setStartDate(h2.getTrustServiceEquivalenceStatusStartingTime().toGregorianCalendar().getTime()).setEndDate(oldestStartDate).setStatus(h2.getTrustServiceEquivalenceStatus()).setTypeAsiEquivalence(this.getTypeASiEquivalence(h2.getTrustServiceTSLTypeEquivalenceList())).setStatusEquivalence(this.getStatusEquivalence(h2.getTrustServiceTSLStatusEquivalenceList())).setCertificateContentEquivalences(this.getCertificateEquivalence(h2.getCertificateContentReferencesEquivalenceList())).setQualifierEquivalence(this.getQualifierEquivalence(h2.getTrustServiceTSLQualificationExtensionEquivalenceList())).build();
                result.addOldest(historyServiceEquivalence);
                oldestStartDate = historyServiceEquivalence.getStartDate();
            }
        }
        return result;
    }

    private Map<ServiceTypeASi, ServiceTypeASi> getTypeASiEquivalence(TrustServiceTSLTypeEquivalenceListType serviceTSLTypeEquivalenceList) {
        if (serviceTSLTypeEquivalenceList != null) {
            TrustServiceTSLTypeListType expected = serviceTSLTypeEquivalenceList.getTrustServiceTSLTypeListPointedParty();
            TrustServiceTSLTypeListType substitute = serviceTSLTypeEquivalenceList.getTrustServiceTSLTypeListPointingParty();
            List<TrustServiceTSLTypeType> expectedServiceTSLTypes = expected.getTrustServiceTSLType();
            List<TrustServiceTSLTypeType> substituteServiceTSLTypes = substitute.getTrustServiceTSLType();
            HashMap<ServiceTypeASi, ServiceTypeASi> typeAsiEquivalence = new HashMap<ServiceTypeASi, ServiceTypeASi>();
            for (TrustServiceTSLTypeType expectedTypeASI : expectedServiceTSLTypes) {
                ServiceTypeASi staExpected = this.getServiceTypeASi(expectedTypeASI);
                for (TrustServiceTSLTypeType substituteTypeASI : substituteServiceTSLTypes) {
                    ServiceTypeASi staSubstitute = this.getServiceTypeASi(substituteTypeASI);
                    typeAsiEquivalence.put(staExpected, staSubstitute);
                }
            }
            return typeAsiEquivalence;
        }
        return null;
    }

    private ServiceTypeASi getServiceTypeASi(TrustServiceTSLTypeType expectedTypeASI) {
        ServiceTypeASi sta = new ServiceTypeASi();
        sta.setType(expectedTypeASI.getServiceTypeIdentifier());
        AdditionalServiceInformationType additionalServiceInformation = expectedTypeASI.getAdditionalServiceInformation();
        if (additionalServiceInformation != null && additionalServiceInformation.getURI() != null) {
            sta.setAsi(additionalServiceInformation.getURI().getValue());
        }
        return sta;
    }

    private Map<List<String>, List<String>> getStatusEquivalence(TrustServiceTSLStatusEquivalenceListType serviceTSLStatusEquivalenceList) {
        HashMap<List<String>, List<String>> statusEquivalenceMap = new HashMap<List<String>, List<String>>();
        TrustServiceTSLStatusEquivalenceType validEquivalences = serviceTSLStatusEquivalenceList.getTrustServiceTSLStatusValidEquivalence();
        this.extractEquivalences(validEquivalences, statusEquivalenceMap);
        TrustServiceTSLStatusEquivalenceType invalidEquivalences = serviceTSLStatusEquivalenceList.getTrustServiceTSLStatusInvalidEquivalence();
        this.extractEquivalences(invalidEquivalences, statusEquivalenceMap);
        return statusEquivalenceMap;
    }

    private void extractEquivalences(TrustServiceTSLStatusEquivalenceType statusEquivalence, Map<List<String>, List<String>> statusEquivalenceMap) {
        if (statusEquivalence != null) {
            TrustServiceTSLStatusList serviceTSLStatusListExpected = statusEquivalence.getTrustServiceTSLStatusListPointedParty();
            List<String> expected = serviceTSLStatusListExpected.getServiceStatus();
            TrustServiceTSLStatusList serviceTSLStatusListSubstitute = statusEquivalence.getTrustServiceTSLStatusListPointingParty();
            List<String> substitute = serviceTSLStatusListSubstitute.getServiceStatus();
            statusEquivalenceMap.put(expected, substitute);
        }
    }

    private List<CertificateContentEquivalence> getCertificateEquivalence(CertificateContentReferencesEquivalenceListType certificateContentEquivalenceList) {
        if (certificateContentEquivalenceList != null && Utils.isCollectionNotEmpty(certificateContentEquivalenceList.getCertificateContentReferenceEquivalence())) {
            ArrayList<CertificateContentEquivalence> certificateContentEquivalences = new ArrayList<CertificateContentEquivalence>();
            for (CertificateContentReferenceEquivalenceType certEquiv : certificateContentEquivalenceList.getCertificateContentReferenceEquivalence()) {
                CriteriaListType expected = certEquiv.getCertificateContentDeclarationPointedParty();
                CriteriaListType substitute = certEquiv.getCertificateContentDeclarationPointingParty();
                Condition condition = this.criteriaConverter.apply(substitute);
                CertificateContentEquivalence equiv = new CertificateContentEquivalence();
                equiv.setContext(certEquiv.getCertificateContentReferenceEquivalenceContext());
                equiv.setCondition(this.criteriaConverter.apply(expected));
                equiv.setContentReplacement(this.getQCStatementOids(condition));
                certificateContentEquivalences.add(equiv);
            }
            return certificateContentEquivalences;
        }
        return null;
    }

    private QCStatementOids getQCStatementOids(Condition condition) {
        QCStatementOids result = new QCStatementOids();
        ArrayList<String> qcStatementIds = new ArrayList<String>();
        ArrayList<String> qcTypeIds = new ArrayList<String>();
        ArrayList<String> qcCClegislations = new ArrayList<String>();
        ArrayList<String> qcStatementIdsToRemove = new ArrayList<String>();
        ArrayList<String> qcTypeIdsToRemove = new ArrayList<String>();
        ArrayList<String> qcCClegislationsToRemove = new ArrayList<String>();
        if (condition instanceof CompositeCondition) {
            CompositeCondition composite = (CompositeCondition)condition;
            switch (composite.getMatchingCriteriaIndicator()) {
                case ALL: {
                    for (Condition condition2 : composite.getChildren()) {
                        this.populateFromChild(condition2, qcStatementIds, qcTypeIds, qcCClegislations, qcStatementIdsToRemove, qcTypeIdsToRemove, qcCClegislationsToRemove);
                    }
                    break;
                }
                case AT_LEAST_ONE: {
                    if (composite.getChildren().size() > 1) {
                        LOG.info("First equivalence condition is used out of '{}'!", (Object)composite.getChildren().size());
                    }
                    Condition firstCondition = composite.getChildren().get(0);
                    this.populateFromChild(firstCondition, qcStatementIds, qcTypeIds, qcCClegislations, qcStatementIdsToRemove, qcTypeIdsToRemove, qcCClegislationsToRemove);
                    break;
                }
                case NONE: {
                    for (Condition childCondition : composite.getChildren()) {
                        this.populateFromChild(childCondition, qcStatementIdsToRemove, qcTypeIdsToRemove, qcCClegislationsToRemove, qcStatementIds, qcTypeIds, qcCClegislations);
                    }
                    break;
                }
                default: {
                    LOG.warn("Unsupported assert {}", (Object)composite.getMatchingCriteriaIndicator());
                }
            }
        }
        if (condition instanceof QCStatementCondition) {
            String legislation;
            String string;
            QCStatementCondition qcCondition = (QCStatementCondition)condition;
            String oid = qcCondition.getOid();
            if (Utils.isStringNotEmpty(oid)) {
                qcStatementIds.add(oid);
            }
            if (Utils.isStringNotEmpty(string = qcCondition.getType())) {
                qcTypeIds.add(string);
            }
            if (Utils.isStringNotEmpty(legislation = qcCondition.getLegislation())) {
                qcCClegislations.add(legislation);
            }
        }
        result.setQcStatementIds(qcStatementIds);
        result.setQcTypeIds(qcTypeIds);
        result.setQcCClegislations(qcCClegislations);
        result.setQcStatementIdsToRemove(qcStatementIdsToRemove);
        result.setQcTypeIdsToRemove(qcTypeIdsToRemove);
        result.setQcCClegislationsToRemove(qcCClegislationsToRemove);
        return result;
    }

    private void populateFromChild(Condition condition, List<String> qcStatementIds, List<String> qcTypeIds, List<String> qcCClegislations, List<String> qcStatementIdsToRemove, List<String> qcTypeIdsToRemove, List<String> qcCClegislationsToRemove) {
        QCStatementOids conditionResult = this.getQCStatementOids(condition);
        for (String conditionQCStatementId : conditionResult.getQcStatementIds()) {
            if (qcStatementIds.contains(conditionQCStatementId)) continue;
            qcStatementIds.add(conditionQCStatementId);
        }
        for (String conditionQCTypeId : conditionResult.getQcTypeIds()) {
            if (qcTypeIds.contains(conditionQCTypeId)) continue;
            qcTypeIds.add(conditionQCTypeId);
        }
        for (String conditionQcCClegislation : conditionResult.getQcCClegislations()) {
            if (qcCClegislations.contains(conditionQcCClegislation)) continue;
            qcCClegislations.add(conditionQcCClegislation);
        }
        for (String childQCStatementId : conditionResult.getQcStatementIdsToRemove()) {
            if (qcStatementIdsToRemove.contains(childQCStatementId)) continue;
            qcStatementIdsToRemove.add(childQCStatementId);
        }
        for (String childQCTypeId : conditionResult.getQcTypeIdsToRemove()) {
            if (qcTypeIdsToRemove.contains(childQCTypeId)) continue;
            qcTypeIdsToRemove.add(childQCTypeId);
        }
        for (String childQcCClegislation : conditionResult.getQcCClegislationsToRemove()) {
            if (qcCClegislationsToRemove.contains(childQcCClegislation)) continue;
            qcCClegislationsToRemove.add(childQcCClegislation);
        }
    }

    private Map<String, String> getQualifierEquivalence(TrustServiceTSLQualificationExtensionEquivalenceListType qualificationExtensionEquivalenceListType) {
        if (qualificationExtensionEquivalenceListType != null && Utils.isCollectionNotEmpty(qualificationExtensionEquivalenceListType.getQualifierEquivalenceList())) {
            HashMap<String, String> qualifierEquivalenceMap = new HashMap<String, String>();
            for (QualifierEquivalenceListType qualifierEquivalenceList : qualificationExtensionEquivalenceListType.getQualifierEquivalenceList()) {
                List<QualifierEquivalenceType> qualifierEquivalence = qualifierEquivalenceList.getQualifierEquivalence();
                for (QualifierEquivalenceType qualifierEquivalenceType : qualifierEquivalence) {
                    QualifierType qualifierExpected = qualifierEquivalenceType.getQualifierPointedParty();
                    QualifierType qualifierSubstitute = qualifierEquivalenceType.getQualifierPointingParty();
                    qualifierEquivalenceMap.put(qualifierExpected.getUri(), qualifierSubstitute.getUri());
                }
            }
            return qualifierEquivalenceMap;
        }
        return null;
    }
}

