/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.function.converter;

import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.tsl.Condition;
import eu.europa.esig.dss.tsl.dto.condition.CertSubjectDNAttributeCondition;
import eu.europa.esig.dss.tsl.dto.condition.CompositeCondition;
import eu.europa.esig.dss.tsl.dto.condition.ExtendedKeyUsageCondition;
import eu.europa.esig.dss.tsl.dto.condition.KeyUsageCondition;
import eu.europa.esig.dss.tsl.dto.condition.PolicyIdCondition;
import eu.europa.esig.dss.tsl.dto.condition.QCStatementCondition;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.trustedlist.enums.Assert;
import eu.europa.esig.trustedlist.jaxb.ecc.CriteriaListType;
import eu.europa.esig.trustedlist.jaxb.ecc.KeyUsageBitType;
import eu.europa.esig.trustedlist.jaxb.ecc.KeyUsageType;
import eu.europa.esig.trustedlist.jaxb.ecc.PoliciesListType;
import eu.europa.esig.trustedlist.jaxb.mra.QcStatementInfoType;
import eu.europa.esig.trustedlist.jaxb.mra.QcStatementListType;
import eu.europa.esig.trustedlist.jaxb.mra.QcStatementType;
import eu.europa.esig.trustedlist.jaxb.tslx.CertSubjectDNAttributeType;
import eu.europa.esig.trustedlist.jaxb.tslx.ExtendedKeyUsageType;
import eu.europa.esig.xades.jaxb.xades132.AnyType;
import eu.europa.esig.xades.jaxb.xades132.IdentifierType;
import eu.europa.esig.xades.jaxb.xades132.ObjectIdentifierType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.xml.bind.JAXBElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CriteriaListConverter
implements Function<CriteriaListType, Condition> {
    private static final Logger LOG = LoggerFactory.getLogger(CriteriaListConverter.class);

    @Override
    public Condition apply(CriteriaListType criteriaList) {
        Assert matchingCriteriaIndicator = criteriaList.getAssert();
        CompositeCondition condition = new CompositeCondition(matchingCriteriaIndicator);
        this.addKeyUsageConditionsIfPresent(criteriaList.getKeyUsage(), condition);
        this.addPolicyIdConditionsIfPresent(criteriaList.getPolicySet(), condition);
        this.addOtherCriteriaListConditionsIfPresent(criteriaList.getOtherCriteriaList(), condition);
        this.addCriteriaListConditionsIfPresent(criteriaList.getCriteriaList(), condition);
        return condition;
    }

    private void addKeyUsageConditionsIfPresent(List<KeyUsageType> keyUsages, CompositeCondition criteriaCondition) {
        if (Utils.isCollectionNotEmpty(keyUsages)) {
            for (KeyUsageType keyUsageType : keyUsages) {
                CompositeCondition condition = new CompositeCondition();
                for (KeyUsageBitType keyUsageBit : keyUsageType.getKeyUsageBit()) {
                    condition.addChild(new KeyUsageCondition(keyUsageBit.getName(), keyUsageBit.isValue()));
                }
                criteriaCondition.addChild(condition);
            }
        }
    }

    private void addPolicyIdConditionsIfPresent(List<PoliciesListType> policySet, CompositeCondition criteriaCondition) {
        if (Utils.isCollectionNotEmpty(policySet)) {
            for (PoliciesListType policiesListType : policySet) {
                CompositeCondition condition = new CompositeCondition();
                for (ObjectIdentifierType oidType : policiesListType.getPolicyIdentifier()) {
                    String id;
                    IdentifierType identifier = oidType.getIdentifier();
                    if (identifier == null || !Utils.isStringNotEmpty(id = DSSUtils.getObjectIdentifierValue(identifier.getValue(), identifier.getQualifier()))) continue;
                    condition.addChild(new PolicyIdCondition(id));
                }
                criteriaCondition.addChild(condition);
            }
        }
    }

    private void addOtherCriteriaListConditionsIfPresent(AnyType otherCriteriaList, CompositeCondition condition) {
        if (otherCriteriaList != null && Utils.isCollectionNotEmpty(otherCriteriaList.getContent())) {
            for (Object content : otherCriteriaList.getContent()) {
                if (!(content instanceof JAXBElement)) continue;
                JAXBElement jaxbElement = (JAXBElement)content;
                Object objectValue = jaxbElement.getValue();
                if (objectValue instanceof CertSubjectDNAttributeType) {
                    CertSubjectDNAttributeType certSubDNAttr = (CertSubjectDNAttributeType)objectValue;
                    condition.addChild(new CertSubjectDNAttributeCondition(this.extractOids(certSubDNAttr.getAttributeOID())));
                    continue;
                }
                if (objectValue instanceof ExtendedKeyUsageType) {
                    ExtendedKeyUsageType extendedKeyUsage = (ExtendedKeyUsageType)objectValue;
                    condition.addChild(new ExtendedKeyUsageCondition(this.extractOids(extendedKeyUsage.getKeyPurposeId())));
                    continue;
                }
                if (objectValue instanceof QcStatementListType) {
                    QcStatementListType qcStatementList = (QcStatementListType)objectValue;
                    CompositeCondition composite = new CompositeCondition(Assert.ALL);
                    List<QcStatementType> qcStatement = qcStatementList.getQcStatement();
                    for (QcStatementType qcStatementType : qcStatement) {
                        IdentifierType qcStatementIdentifier = qcStatementType.getQcStatementId().getIdentifier();
                        String oid = DSSUtils.getObjectIdentifierValue(qcStatementIdentifier.getValue(), qcStatementIdentifier.getQualifier());
                        String legislation = null;
                        String type = null;
                        QcStatementInfoType qcStatementInfo = qcStatementType.getQcStatementInfo();
                        if (qcStatementInfo != null) {
                            IdentifierType qcTypeIdentifier;
                            String id;
                            legislation = qcStatementInfo.getQcCClegislation();
                            ObjectIdentifierType qcType = qcStatementInfo.getQcType();
                            if (qcType != null && Utils.isStringNotEmpty(id = DSSUtils.getObjectIdentifierValue((qcTypeIdentifier = qcType.getIdentifier()).getValue(), qcTypeIdentifier.getQualifier()))) {
                                type = id;
                            }
                        }
                        composite.addChild(new QCStatementCondition(oid, type, legislation));
                    }
                    condition.addChild(composite);
                    continue;
                }
                throw new DSSException("Unsupported OtherCriteriaList");
            }
        }
    }

    private List<String> extractOids(List<ObjectIdentifierType> oits) {
        ArrayList<String> oids = new ArrayList<String>();
        if (Utils.isCollectionNotEmpty(oits)) {
            for (ObjectIdentifierType objectIdentifierType : oits) {
                String id;
                IdentifierType identifier = objectIdentifierType.getIdentifier();
                if (identifier == null || !Utils.isStringNotEmpty(id = DSSUtils.getObjectIdentifierValue(identifier.getValue(), identifier.getQualifier()))) continue;
                if (DSSUtils.isOidCode(id)) {
                    oids.add(id);
                    continue;
                }
                LOG.warn("The obtained value is not OID : '{}'!", (Object)id);
            }
        }
        return oids;
    }

    private void addCriteriaListConditionsIfPresent(List<CriteriaListType> criteriaList, CompositeCondition condition) {
        if (Utils.isCollectionNotEmpty(criteriaList)) {
            for (CriteriaListType criteriaListType : criteriaList) {
                condition.addChild(this.apply(criteriaListType));
            }
        }
    }
}

