/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.function;

import eu.europa.esig.dss.tsl.function.EULOTLOtherTSLPointer;
import eu.europa.esig.dss.tsl.function.EUTLOtherTSLPointer;
import eu.europa.esig.dss.tsl.function.MimetypeOtherTSLPointer;
import eu.europa.esig.dss.tsl.function.PDFOtherTSLPointer;
import eu.europa.esig.dss.tsl.function.SchemeTerritoryOtherTSLPointer;
import eu.europa.esig.dss.tsl.function.TypeOtherTSLPointer;
import eu.europa.esig.dss.tsl.function.XMLOtherTSLPointer;
import eu.europa.esig.trustedlist.jaxb.tsl.OtherTSLPointerType;
import java.util.Arrays;
import java.util.function.Predicate;

public class TLPredicateFactory {
    private TLPredicateFactory() {
    }

    public static Predicate<OtherTSLPointerType> createEULOTLPredicate() {
        return new EULOTLOtherTSLPointer().and(new XMLOtherTSLPointer());
    }

    public static Predicate<OtherTSLPointerType> createEUTLPredicate() {
        return new EUTLOtherTSLPointer().and(new XMLOtherTSLPointer());
    }

    public static Predicate<OtherTSLPointerType> createPredicateWithCustomTSLType(String tslType) {
        return new TypeOtherTSLPointer(tslType).and(new XMLOtherTSLPointer());
    }

    public static Predicate<OtherTSLPointerType> createEUTLCountryCodePredicate(String ... countryCodes) {
        return new SchemeTerritoryOtherTSLPointer(Arrays.asList(countryCodes)).and(new EUTLOtherTSLPointer()).and(new XMLOtherTSLPointer());
    }

    public static Predicate<OtherTSLPointerType> createXMLOtherTSLPointerPredicate() {
        return new XMLOtherTSLPointer();
    }

    public static Predicate<OtherTSLPointerType> createPDFOtherTSLPointerPredicate() {
        return new PDFOtherTSLPointer();
    }

    public static Predicate<OtherTSLPointerType> createPredicateWithCustomMimeType(String mimetype) {
        return new MimetypeOtherTSLPointer(mimetype);
    }
}

