/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.dto.condition;

import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.extension.ExtendedKeyUsages;
import eu.europa.esig.dss.spi.CertificateExtensionsUtils;
import eu.europa.esig.dss.spi.tsl.Condition;
import eu.europa.esig.dss.utils.Utils;
import java.util.Collections;
import java.util.List;

public class ExtendedKeyUsageCondition
implements Condition {
    private static final long serialVersionUID = -5969735320082024885L;
    private final List<String> extendedKeyUsageOids;

    public ExtendedKeyUsageCondition(List<String> oids) {
        this.extendedKeyUsageOids = oids;
    }

    public final List<String> getKeyPurposeIds() {
        return this.extendedKeyUsageOids == null ? Collections.emptyList() : Collections.unmodifiableList(this.extendedKeyUsageOids);
    }

    @Override
    public boolean check(CertificateToken certificateToken) {
        if (Utils.isCollectionNotEmpty(this.extendedKeyUsageOids)) {
            ExtendedKeyUsages extendedKeyUsage = CertificateExtensionsUtils.getExtendedKeyUsage(certificateToken);
            if (extendedKeyUsage == null || Utils.isCollectionEmpty(extendedKeyUsage.getOids())) {
                return false;
            }
            for (String oid : this.extendedKeyUsageOids) {
                if (extendedKeyUsage.getOids().contains(oid)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public String toString(String indent) {
        if (indent == null) {
            indent = "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(indent).append("ExtendedKeyUsageCondition: ").append(this.extendedKeyUsageOids).append('\n');
        return builder.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

