/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.standalone.task;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.FileDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.tsl.TrustedListsCertificateSource;
import eu.europa.esig.dss.spi.x509.CommonCertificateSource;
import eu.europa.esig.dss.standalone.exception.ApplicationException;
import eu.europa.esig.dss.standalone.model.ValidationModel;
import eu.europa.esig.dss.standalone.source.CertificateVerifierBuilder;
import eu.europa.esig.dss.standalone.source.DataLoaderConfigLoader;
import eu.europa.esig.dss.standalone.source.PropertyReader;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.OriginalIdentifierProvider;
import eu.europa.esig.dss.validation.SignaturePolicyProvider;
import eu.europa.esig.dss.validation.SignedDocumentValidator;
import eu.europa.esig.dss.validation.UserFriendlyIdentifierProvider;
import eu.europa.esig.dss.validation.reports.Reports;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.stream.Collectors;
import javafx.concurrent.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationTask
extends Task<Reports> {
    private static final Logger LOG = LoggerFactory.getLogger(ValidationTask.class);
    private final ValidationModel model;
    private final TrustedListsCertificateSource tslCertificateSource;

    public ValidationTask(ValidationModel model, TrustedListsCertificateSource tslCertificateSource) {
        this.model = model;
        this.tslCertificateSource = tslCertificateSource;
    }

    @Override
    protected Reports call() {
        try {
            FileDocument fileToValidate = new FileDocument(this.model.getFileToValidate());
            SignedDocumentValidator documentValidator = SignedDocumentValidator.fromDocument(fileToValidate);
            if (this.model.getOriginalDocuments() != null) {
                List<DSSDocument> fileDocuments = this.model.getOriginalDocuments().stream().map(FileDocument::new).collect(Collectors.toList());
                documentValidator.setDetachedContents(fileDocuments);
            }
            if (this.model.getSigningCertificate() != null) {
                CommonCertificateSource signingCertificateSource = new CommonCertificateSource();
                signingCertificateSource.addCertificate(DSSUtils.loadCertificate(this.model.getSigningCertificate()));
                documentValidator.setSigningCertificateSource(signingCertificateSource);
            }
            CommonCertificateSource adjunctCertificateSource = new CommonCertificateSource();
            if (Utils.isCollectionNotEmpty(this.model.getAdjunctCertificates())) {
                adjunctCertificateSource = new CommonCertificateSource();
                for (File file : this.model.getAdjunctCertificates()) {
                    adjunctCertificateSource.addCertificate(DSSUtils.loadCertificate(file));
                }
            }
            documentValidator.setTokenIdentifierProvider(this.model.isUserFriendlyIdentifiers() != false ? new UserFriendlyIdentifierProvider() : new OriginalIdentifierProvider());
            documentValidator.setIncludeSemantics(this.model.isSemantics());
            CertificateVerifier certificateVerifier = new CertificateVerifierBuilder().setTslCertificateSource(this.tslCertificateSource).setAdjunctCertificateSource(adjunctCertificateSource).build();
            documentValidator.setCertificateVerifier(certificateVerifier);
            SignaturePolicyProvider signaturePolicyProvider = new SignaturePolicyProvider();
            signaturePolicyProvider.setDataLoader(DataLoaderConfigLoader.getDataLoader());
            documentValidator.setSignaturePolicyProvider(signaturePolicyProvider);
            DSSDocument validationPolicy = null;
            validationPolicy = this.model.getValidationPolicy() != null ? new FileDocument(this.model.getValidationPolicy()) : this.loadDefaultValidationPolicy();
            return documentValidator.validateDocument(validationPolicy);
        }
        catch (Exception e) {
            this.throwException("Unable to validate the document", e);
            return null;
        }
    }

    private DSSDocument loadDefaultValidationPolicy() {
        InMemoryDocument inMemoryDocument;
        block9: {
            String policyPath = PropertyReader.getProperty("default.validation.policy");
            if (Utils.isStringEmpty(policyPath)) {
                throw new IllegalArgumentException("default.validation.policy is not defined!");
            }
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(policyPath);
            try {
                inMemoryDocument = new InMemoryDocument(is);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.throwException("Unable to load validation policy", e);
                    return null;
                }
            }
            is.close();
        }
        return inMemoryDocument;
    }

    private void throwException(String message, Exception e) {
        String exceptionMessage = message + (String)(e != null ? " : " + e.getMessage() : "");
        this.updateMessage(exceptionMessage);
        this.failed();
        LOG.error(message, e);
        throw new ApplicationException(exceptionMessage, e);
    }
}

