/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.standalone.task;

import eu.europa.esig.dss.enumerations.JWSSerializationType;
import eu.europa.esig.dss.enumerations.SigDMechanism;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.FileDocument;
import eu.europa.esig.dss.spi.tsl.TrustedListsCertificateSource;
import eu.europa.esig.dss.standalone.exception.ApplicationException;
import eu.europa.esig.dss.standalone.model.ExtensionModel;
import eu.europa.esig.dss.standalone.service.RemoteDocumentSignatureServiceBuilder;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.ws.converter.RemoteDocumentConverter;
import eu.europa.esig.dss.ws.dto.RemoteDocument;
import eu.europa.esig.dss.ws.signature.common.RemoteDocumentSignatureService;
import eu.europa.esig.dss.ws.signature.dto.parameters.RemoteSignatureParameters;
import java.util.List;
import java.util.stream.Collectors;
import javafx.concurrent.Task;

public class ExtensionTask
extends Task<DSSDocument> {
    private final ExtensionModel model;
    private final RemoteDocumentSignatureService service;

    public ExtensionTask(ExtensionModel model, TrustedListsCertificateSource tslCertificateSource) {
        this.model = model;
        RemoteDocumentSignatureServiceBuilder signatureServiceBuilder = new RemoteDocumentSignatureServiceBuilder();
        signatureServiceBuilder.setTslCertificateSource(tslCertificateSource);
        this.service = signatureServiceBuilder.build();
    }

    @Override
    protected DSSDocument call() {
        try {
            FileDocument fileToExtend = new FileDocument(this.model.getFileToExtend());
            RemoteDocument toExtendDocument = RemoteDocumentConverter.toRemoteDocument(fileToExtend);
            RemoteSignatureParameters parameters = this.buildParameters();
            RemoteDocument extendedDocument = this.service.extendDocument(toExtendDocument, parameters);
            return RemoteDocumentConverter.toDSSDocument(extendedDocument);
        }
        catch (Exception e) {
            this.throwException("Unable to extend the document", e);
            return null;
        }
    }

    private RemoteSignatureParameters buildParameters() {
        RemoteSignatureParameters parameters = new RemoteSignatureParameters();
        parameters.setAsicContainerType(this.model.getAsicContainerType());
        parameters.setSignatureLevel(this.model.getSignatureLevel());
        if (Utils.isCollectionNotEmpty(this.model.getOriginalDocuments())) {
            List<DSSDocument> fileDocuments = this.model.getOriginalDocuments().stream().map(FileDocument::new).collect(Collectors.toList());
            parameters.setDetachedContents(RemoteDocumentConverter.toRemoteDocuments(fileDocuments));
        }
        if (SignatureForm.JAdES.equals((Object)this.model.getSignatureForm())) {
            parameters.setJwsSerializationType(JWSSerializationType.JSON_SERIALIZATION);
            parameters.setSigDMechanism(SigDMechanism.OBJECT_ID_BY_URI_HASH);
        }
        return parameters;
    }

    private void throwException(String message, Exception e) {
        String exceptionMessage = message + (String)(e != null ? " : " + e.getMessage() : "");
        this.updateMessage(exceptionMessage);
        this.failed();
        throw new ApplicationException(exceptionMessage, e);
    }
}

